@extends('layouts.dash')
@section('title') RAZ @stop
@section('title_card',"")
@section('subtitle_card',"")

@section('content')
    <div class="card card-info">
        <div class="card-header">
            <h3 class="card-title">{!! $titre_versement !!}</h3>
        </div>
        <div align="center" class="card-body">
            @if($nbraz=="")
                {{ html()->form('POST', url('raz_rappel/'.$benef_type))->open() }}
                <div class="h5 col-md-12 bg-warning alert">
                        Cette opération va permettre de remettre à zéro tous les montants de rappel dans les fiches bénéficiaires.
                        <br/><br/>Cette opération de ne s'appliquera que pour les <b>{!! $libelle_beneficiaire !!} </b>.
                        <br/><br/>Cliquez sur le bouton ci-dessous pour valider l'opération.
                </div>

                <div class="col-md-12">
                    <div class="form-group" align="center">
                        {!! html()->button('Remise à zéro de tous les rappels')->type('submit')->attributes(['class' => 'btn btn-danger','style'=>'font-size:24px']) !!}
                    </div>
                </div>
                {{ html()->form()->close() }}
            @else
                <div class="h5 col-md-8 bg-success alert">
                    Opération de remise à zéro tous les montants de rappel dans les fiches bénéficiaires est terminée.
                    <br/>Cette opération de ne s'est appliquée que pour les {!! $libelle_beneficiaire !!}
                    <br/><br/><b>{!! $nbraz !!} fiches </b>bénéficiaires ont été remises à zéro par cette opération.
                </div>
            @endif
        </div>
    </div>


@stop




