@extends('layouts.dash_pop')
@section('title') Controle @stop
@section('title_card',"")
@section('subtitle_card',"")


@section('content')
    <div class="card">
        <div class="col-lg-max col-lg-offset-1 container-fluid">
            <div class="card-header bg-info h4">
                Ajouter un document - Controle N°{!! $controle->id !!}
            </div>
            <div class="card-body">
                <div class="col-lg-max col-lg-offset-1">
                    @if ($errors)
                        @foreach ($errors->all() as $error)
                            <div class='bg-danger alert'>{!! $error !!}</div>
                        @endforeach
                    @endif
                    
                 
                    {{ html()->modelForm($controle, 'POST', url('uploadfile/'))->attributes(['files'=>'true','enctype' => 'multipart/form-data','class' => 'form-horizontal'])->open() }}
                        {{ html()->hidden('id',$controle->id); }}
                        <div class="row form-group">
                            <div class="col-md-5">
                                {!! html()->label( 'Employeur','sonum') !!}
                                <div class="input-group">
                                    <div class="input-group-prepend">
                                        <span class="input-group-text" id="ref_employeur">{!! $controle->sonum !!}</span>
                                    </div>
                                    {!! html()->text('sonum', $controle->nom_employeur)->attributes(['disabled' => 'true','class' => 'form-control']) !!}
                                </div>
                            </div>
                            <div class="col-md-2">
                                {!! html()->label('Date du contrôle','date_cont') !!}
                                <div class='input-group date' id='datepicker_date_med'>
                                    {!! html()->text('date_cont', $controle->date)->attributes(['disabled' => 'true','class' => 'form-control']) !!}
                                </div>
                            </div>
                        </div>
                        <div class='form-group'>
                            <div class="col-md-8">
                                {{ html()->label( 'Fichier','Fichier') }}
                                {{ html()->file('fichier') }}
                            </div>
                        </div>
                        <div class="col-sm-9">
                            <div class='form-group'><br/>
                                {!! html()->button('Télécharger le fichier')->value('Télécharger')->type('submit')->attributes(['class' => 'btn btn-primary']) !!}
                            </div>
                        </div>
                    {{ html()->form()->close() }}
                </div>
            </div>
        </div>
    </div>
@endsection