@extends('layouts.dash')
@section('title') Mise à jour d'un controle @stop


@section('content')
    @if ($errors)
        @foreach ($errors->all() as $error)
            <div class='bg-danger alert'>{!! $error !!}</div>
        @endforeach
    @endif
    <div class="card card-info">
        <div class="card-header">
            <h2>Mise à jour d'un controle</h2>
        </div>
        <div class='card-body'>
            {{ html()->modelForm($controle, 'PUT', url('controles/' . $controle->id))->open() }}
                @include("recouvrement.controles.content")
            {{ html()->form()->close() }}
        </div>
    </div>
@stop

@section('scripts')
    <script type="text/javascript">
        $(function () {
            $('#datepicker_date_cont').datepicker({
                format: "dd/mm/yyyy",
                language: "fr",
                autoclose: true
            });
            $('#datepicker_date_valid').datepicker({
                format: "dd/mm/yyyy",
                language: "fr",
                autoclose: true
            });
        });
    </script>
@endsection