@include('forms.fbncheader_nomenu')
@include('forms.fdatatables')

<div class="col-lg-max col-lg-offset-1">
    <h2><i class="fa fa-employeurs"></i><small>Controles de l'Employeur </small>{!! $employeur->nom !!}</h2>
    <br/>
    <div class="table-responsive">
        <table id="_table" class="table table-condensed table-striped table-bordered">
            <thead>
                <tr>
                    <th width='1%'>N°</th>
                    <th width='1%'>Contrôle</th>
                    <th width='10%'>Agent1</th>
                    <th width='10%'>Agent2</th> 
                    <th width='10%'>Validation</th>
                    <th width='10%'>Observations</th>
                    <th width='200px'>&nbsp</th>
                </tr>
                </thead>
     
                <tbody>
                @foreach ($controles as $controle)
                <tr>
                    <td style="color:grey">{!! $controle->id !!}</td>
                    <td align="center">{!! $controle->date_cont !!}</td>
                    <td align="center">{!! $controle->agent1 !!}</td>
                    <td align="right">{!! $controle->agent2 !!}</td>
                    <td align="right">{!! $controle->date_valid !!}</td>
                    <td align="right">{!! $controle->observations !!}</td>
                </tr>
                @endforeach
            </tbody>
 
        </table>
    </div>

@if($user->can("COT_AJO") || $user->HasRole("ADMINISTRATEUR"))
     <div>
        <h4><a href="{!! url('recouvrement/controle_annee/'.$employeur->id) !!}" 
            class="btn btn-success"
            target="_blank">Gestion des Controles</a></h4>
    </div> 
@endif

</div>

</body></html>


<script>
$(document).ready(function() {
    $('#_table').dataTable( {
        "bAutoWidth": false,
        "bPaginate": false,
        "bInfo": true,
        "bFilter": true,
        "oLanguage": {
            "sZeroRecords": "Aucune ligne",
            "sInfo": "Affichage de _START_ &agrave; _END_ sur _TOTAL_ lignes",
            "sInfoEmpty": "Showing 0 to 0 of 0 records",
            "sInfoFiltered": "(sur un total de _MAX_ lignes)",
             "sSearch":"Chercher",
            },

        "order": [[ 1, "desc" ]]

        } );
</script>