<div class="row form-group">
    <div class="col-md-10">
        {!! html()->label('Employeur','sonum') !!}
        {!! html()->text('employeur', $employeur->id."  ".$employeur->nom)
                ->attributes(['readonly','class' => 'form-control']) !!}
        {!! html()->hidden('sonum', $employeur->id) !!}
    </div>


    <div class="col-md-2">
        {!! html()->label( 'Date d\'entrée','date') !!}
        <div class='input-group date' id='datepicker_date'>
            {!! html()->text('date', date('d/m/Y'))
                ->placeholder('')
                ->attributes([(($mode!="create")?'readonly':''),'class' => 'form-control']) !!}
            <span class='input-group-addon'><span class='glyphicon glyphicon-calendar'></span></span>
        </div>
    </div>

</div>

<div class="row form-group">
    <div class="col-md-6">
        {!! html()->label( 'Opération','type_ope') !!}
        {!! html()->select('type_ope',$types_operations,null)
            ->placeholder('A définir')
            ->attributes([(($mode!="create")?'readonly':''),'class' => 'form-control']) !!}
    </div>
    @if($mode!="create")
        <div class="col-md-4">
            {!! html()->label( 'Compte','encais_compte') !!}
            {!! html()->select('encais_compte',App\Models\MyApp::COMPTES_ENCAISSEMENT,null)
                ->placeholder('A définir')
                ->attributes([(($cotisation->transaction!="")?'readonly':''),'class' => 'form-control']) !!}
        </div>
    @endif
    <div class="col-md-2">
            {!! html()->label('Exercice','exercice') !!}
            {!! html()->select('exercice',$exercices,($mode!="create")?$cotisation->exercice:date('Y'))
                ->placeholder('A définir')
                ->attributes(['id' => 'exercice_id','class' => 'form-control','style' => 'font-weight:bold;']) !!}
    </div>
</div>

<div class="row form-group">
    <div class="col-xs-2">
        {!! html()->label('Type','type_cotis') !!}
        {!! html()->select('type_cotis',$types_cotisation,null)->placeholder('A définir')
            ->attributes([(($mode!="create")?'readonly':''),'class' => 'form-control']) !!}
    </div>
    @if($mode!="create")
    <div class="col-md-4">
        {!! html()->label( 'Date d\'encaissement','encais_date') !!}
        <div class='input-group date' id='datepicker_encais_date'>
            {!! html()->text('encais_date', $cotisation->encais_date)->placeholder('Date')
                ->attributes(['readonly','class' => 'form-control']) !!}
            <span class='input-group-addon'><span class='glyphicon glyphicon-calendar'></span></span>
        </div>
    </div>
    @endif
</div>

<div class="row form-group">
    <div class="col-md-3">
            {!! html()->label( 'Nb mois','nbmois') !!}
            {!! html()->text('nbmois', null)->placeholder('Nb mois')
                ->attributes([(($mode!="create")?'readonly':''),'class' => 'form-control']) !!}
    </div>
    <div class="col-md-3">
        {!! html()->label( 'Mois de départ','mois') !!}
        <div class="input-group">
            <div class='input-group date' id='datepicker_mois'>
                    {!! html()->text('mois', null)->placeholder('Mois de départ')
                        ->attributes([(($mode!="create")?'readonly':''),'id'=>'mois','class' => 'form-control']) !!}
                <span class='input-group-addon'><span class='glyphicon glyphicon-calendar'></span></span>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        {!! html()->label( 'Nb salariés','nbsal') !!}
        {!! html()->text('nbsal', null)->placeholder('Nb salariés')
            ->attributes([(($mode!="create")?'readonly':''),'class' => 'form-control']) !!}
    </div>
</div>

<div class="row form-group">
    <div class="col-md-3">
            {!! html()->label( 'N°Bordereau','bdx') !!}
            {!! html()->text('bdx', null)->placeholder('N°bordereau')
                ->attributes([(($mode!="create")?'readonly':''),'class' => 'form-control']) !!}
    </div>
    <div class="col-md-3">
            {!! html()->label('N°Bord.privé','bdx_prive') !!}
            {!! html()->text('bdx_prive', null)->placeholder('N°bordereau privé')
                ->attributes([(($mode!="create")?'readonly':''),'class' => 'form-control']) !!}
    </div>
</div>

<div class='row form-group'>
    <div class="col-md-10">
    {!! html()->label('observation', 'Observations') !!}
    {!! html()->textarea('observation', null)->placeholder('Observations')
        ->attributes(['class' => 'form-control', 'rows'=>'2']) !!}
    </div>
</div>

<div class='row form-group'>
    <div class='col-md-10 callout callout-danger'>
        <fieldset >
            <legend class="h4">Cotisation</legend>

            <div class="row form-group " style="padding:5px">
                <div class="col-md-3">
                    {!! html()->label('Assiette','assiette') !!}
                </div>
                <div class="col-md-3" >
                    {!! html()->text('assiette', null)->placeholder('Assiette')
                        ->attributes([(($mode!="create")?'readonly':''),'id'=>'assiette', 'class' => 'form-control','style'=>'text-align:right']) !!} 
                </div>
                <div class="col-md-2">
                    {!! html()->text('PrcTot', null)->placeholder('Assiette')
                        ->attributes(['readonly','class' => 'form-control','id'=>'PrcTot','style'=>'text-align:center']) !!} 
                </div>
            </div>

            <div class="row form-group" style="padding:5px">
                <div class="col-md-3">
                    {!! html()->label( 'CLR','clr') !!}
                </div>
                <div class="col-md-3">
                    {!! html()->text('clr', null)->placeholder("CLR")->attributes(['id'=>'CLR','class' => 'form-control','readonly','style'=>'text-align:right']) !!} 
                </div>
                <div class="col-md-2">
                    {!! html()->text('PrcCLR', null)->placeholder("CLR")
                        ->attributes(['class' => 'form-control','id'=>'PrcCLR','readonly','style'=>'text-align:center']) !!} 
                </div>
                @if($mode=="create")
                <div class="col-md-3">
                    <input type='checkbox' value='1' name='box_clr' id='box_clr' /> Sans CLR
                </div>
                @endif
            </div>

            <div class="row form-group" style="padding:5px">
                <div class="col-md-3">
                    {!! html()->label( 'CCPF','ccpf') !!}
                </div>
                <div class="col-md-3">
                    {!! html()->text('ccpf', null)->placeholder('CCPF')
                        ->attributes(['id'=>'CCPF','readonly', 'class' => 'form-control','style'=>'text-align:right']) !!} 

                </div>
                <div class="col-md-2">
                    {!! html()->text('PrcCCPF', null)->placeholder('CCPF')
                        ->attributes(['class' => 'form-control','id'=>'PrcCCPF','readonly','style'=>'text-align:center']) !!} 
                </div>
                @if($mode=="create")
                <div class="col-md-3">
                    <input type='checkbox' value='1' name='box_ccpf' id='box_ccpf' /> Sans CCPF
                </div>
                @endif
            </div>


           <div class="row form-group bg-info" style="padding:5px">
                <div class="col-md-3">
                    {!! html()->label( 'Total','total') !!}
                </div>
                <div class="col-md-3" >
                    {!! html()->text('total', null)
                        ->attributes(['class' => 'form-control','id'=>'total','style'=>'text-align:right','readonly']) !!} 
                </div>

            </div>
        </fieldset>
    </div>
</div>

<div class='row form-group'>
    @if($mode!="create")
        <a href="{!! url('/cotisation_annee').'/'.$cotisation->sonum !!}"   class="btn btn-warning pull-left"style="margin-right: 3px;">Retour</a>
    @else
        <a href="{!! url('/cotisation_annee').'/'.$employeur->id !!}"   class="btn btn-warning pull-left"style="margin-right: 3px;">Retour</a>
    @endif


    {!! html()->button('Enregistrer')->value('Enregistrer')->type('submit')->attributes(['class' => 'btn btn-primary']) !!}
</div>