@extends('layouts.dash')
@section('title') Cotisation @stop
@section('title_card')  @stop
@section('subtitle_card',"Cotisation")


@section('content')
<div class="card">
        @if ($errors)
            @foreach ($errors->all() as $error)
                <div class='bg-danger alert'>{!! $error !!}</div>
            @endforeach
        @endif
        <div class="card-header bg-info">
            <h2>Nouvelle fiche cotisation</h2>
        </div>
        <div class="card-body">
            {{ html()->form('POST', url('cotisations'))->open() }}
                @include("recouvrement.cotisations.content")
            {{ html()->form()->close() }}
        </div>
</div>
@stop


@section('scripts0')
 <script>
    $("#mois").change(function() { set_Taux(); });
    $("#assiette").change(function() { set_Taux(); });
    $("#box_clr").change(function() { set_Taux(); });
    $("#box_ccpf").change(function() { set_Taux(); });

    $(function () {
        $('#datepicker_date').datepicker({
            format: "dd/mm/yyyy",
            language: "fr",
            autoclose: true
        });

        $('#datepicker_mois').datepicker({
            format: "dd/mm/yyyy",
            language: "fr",
            autoclose: true
        });
    });


    //Positionne les taux en fonction de l'année
    function set_Taux() {
        var taux_CLR = <?php echo json_encode($taux_CLR) ?>;
        var taux_CPF = <?php echo json_encode($taux_CPF) ?>;
        var statut = <?php echo json_encode($employeur->statut) ?>;
        if(statut=="ASV") taux_CPF=0;
        
        var exercice=$("#mois").val();
        if(exercice.length<10) return;
        var year=parseInt(exercice.substr(6,4));

        $("#PrcCLR").val("");
        $("#PrcCCPF").val("");
        $("#PrcTot").val("");

        if(taux_CLR[year]) $("#PrcCLR").val(taux_CLR[year]);
        if(statut=="ASV") {
            $("#PrcCCPF").val("Non concerné");
        } else {
            if(taux_CPF[year]) $("#PrcCCPF").val(taux_CPF[year]);
        }

        var t1=parseFloat($("#PrcCLR").val());
        var t2=0;
        if(statut!="ASV") {
            t2=parseFloat($("#PrcCCPF").val());
        }
        if($("#box_clr").is(':checked')) {t1=0;$("#PrcCLR").val(0);}
        if($("#box_ccpf").is(':checked')) {t2=0;$("#PrcCCPF").val(0);}

        $("#PrcTot").val(t1+t2);

        taux_CLR[year];

        calcul();
    }

    //Calcul le total
    function calcul() {
        var t_CLR=($("#PrcCLR").val());
        var t_CCPF=($("#PrcCCPF").val());
        var statut = <?php echo json_encode($employeur->statut) ?>;
        var assiette = $("#assiette").val();
        if(assiette=="")  $("#assiette").val(0);

        var CLR = t_CLR*assiette/100;
        var CCPF = 0;
        var total=0;
        if(statut!="ASV") CCPF = t_CCPF*assiette/100;
         

        $("#CLR").val(parseInt(CLR));
        if(statut!="ASV") {
            $("#CCPF").val(parseInt(CCPF));
            total=parseInt(CLR+CCPF);
        } else {
            $("#CCPF").val("Non concerné");
            total=parseInt(CLR);
        }
        

        $("#total").val(total);

        $("#PrcCLR").val($("#PrcCLR").val()+"%");
        if(statut!="ASV") $("#PrcCCPF").val($("#PrcCCPF").val()+"%");
        else $("#PrcCCPF").val("");
        $("#PrcTot").val($("#PrcTot").val()+"%");
    }


    set_Taux();
 </script>
@stop