@extends('layouts.dash')
@section('title') Encaissement @stop
@section('title_card')  @stop

 
@section('title') Cotisation N°{!! $cotisation->id !!} @stop
 
@section('content')
     <div class="card">
        @if ($errors)
            @foreach ($errors->all() as $error)
                <div class='bg-danger alert'>{!! $error !!}</div>
            @endforeach
        @endif
        <div class="card-header bg-info">
            <h2>Encaissement de la Cotisation N°{!! $cotisation->id !!}</h2>
        </div>
        <div class="card-body">
            {{ html()->modelForm($cotisation, 'PUT', url('cotisations_encaiss/' . $cotisation->id))->open() }}
                {{ html()->hidden('sonum',$cotisation->sonum) }}
                {{ html()->hidden('origine',$origine) }}

                <div class="form-group row">
                    <div class="col-md-10">
                        {!! html()->label( 'Employeur','sonum') !!}
                        <div class="input-group">
                            <div class="input-group-prepend">
                                <span class="input-group-text" id="ref_employeur">{!! $cotisation->sonum !!}</span>
                            </div>
                            {!! html()->text('sonum', $cotisation->nom_employeur)->placeholder("")->attributes(['readonly', 'class' => 'form-control']) !!}
                        </div>
                    </div>

                    <div class="col-md-2">
                        {!! html()->label( 'Date d\'entrée','date') !!}
                        <div class='input-group date' id='datepicker_date_med'>
                            {!! html()->text('date_med', $cotisation->date)->placeholder("")->attributes(['readonly', 'class' => 'form-control']) !!}
                        </div>
                    </div>
                </div>

                <div class="row form-group">
                    <div class="col-md-2">
                        {!! html()->label( 'Exercice','exercice') !!}
                        {!! html()->text('exercice', $cotisation->exercice)->placeholder("")->attributes(['readonly', 'class' => 'form-control']) !!}
                    </div>
                    <div class="col-md-1">
                        {!! html()->label( 'Type','type_cotis') !!}
                        {!! html()->select('type_cotis',$types_cotisation,$cotisation->type_cotis)->attributes(['readonly','class' => 'form-control'])  !!}
                    </div>
                    <div class="col-md-2">
                        {!! html()->label( 'Nb mois','nbmois') !!}
                        {!! html()->text('nbmois', $cotisation->nbmois)->placeholder("")->attributes(['readonly', 'class' => 'form-control']) !!}
                    </div>
                    <div class="col-md-2">
                        {!! html()->label( 'Mois de départ','mois') !!}
                        <div class='input-group date' id='datepicker_date_med'>
                            {!! html()->text('mois', $cotisation->mois)->attributes(['readonly', 'class' => 'form-control']) !!}
                        </div>
                    </div>
                    <div class="col-md-3">
                        {!! html()->label( 'Nb salariés','nbsal') !!}
                        {!! html()->text('nbsal', $cotisation->nbsal)->attributes(['readonly', 'class' => 'form-control']) !!}
                    </div>
                </div>

                <div class="row form-group">
                    <div class="col-md-3">
                        {!! html()->label( 'N°Bordereau','bdx') !!}
                        {!! html()->text('bdx', $cotisation->bdx)->placeholder("")->attributes(['readonly', 'class' => 'form-control']) !!}
                    </div>

                    <div class="col-md-3">
                        {!! html()->label( 'N° Bordereau privé','bdx_prive') !!}
                        {!! html()->text('bdx_prive', $cotisation->bdx_prive)->placeholder("")->attributes(['readonly', 'class' => 'form-control']) !!}
                    </div>
                    <div class="col-md-5">
                        {!! html()->label( 'Observations','observation') !!}
                        {!! html()->text('observation', $cotisation->observation)->attributes(['readonly', 'class' => 'form-control', 'rows'=>'2']) !!}
                    </div>
                </div>

                <div class='col-md-8 callout callout-success'>
                    <div class="row form-group">
                        <div class="col-md-4">
                            {!! html()->label( 'Date d\'encaissement','encais_date') !!}
                            <div class='input-group date' id='datepicker_encais_date'>
                                {!! html()->text('encais_date', $cotisation->encais_date)->placeholder('Date')->attributes(['class' => 'form-control']) !!}
                                <span class='input-group-addon'><span class='glyphicon glyphicon-calendar'></span></span>
                            </div>
                        </div>
                        <div class="col-md-6">
                            {!! html()->label( 'Compte','encais_compte') !!}
                            {!! html()->select('encais_compte',App\Models\MyApp::COMPTES_ENCAISSEMENT,null)->placeholder('A définir')->attributes(['class' => 'form-control']) !!}
                        </div>
                    </div>
                </div>

                <legend class="h4">Cotisation</legend>
                <div class='col-md-8 callout callout-danger'>
                    <div class="row form-group">
                        <div class="col-md-3">
                            {!! html()->label('Compte','compte') !!}
                            {!! html()->text('compte', null)->attributes(['readonly','class' => 'form-control']) !!}
                        </div>
                        <div class="col-md-4">
                            {!! html()->label('Type de paiement','typepmt') !!}
                            {!! html()->text('typepmt', $cotisation->typepmt)->attributes(['readonly','class' => 'form-control']) !!}
                       </div>
                        <div class="col-md-4">
                            {!! html()->label( 'Date de dépôt','date_depot') !!}
                            {!! html()->text('date_depot', $cotisation->date_depot)->attributes(['readonly','class' => 'form-control']) !!}
                        </div>
                    </div>
                </div>

                <div class="col-md-8 callout callout-warning">
                    <div class="row form-group">
                        <div class="col-md-2">
                            {!! html()->label( 'Assiette','assiette') !!}
                        </div>
                        <div class="col-md-5" >
                            {!! html()->text('assiette', null)->attributes(['readonly','class' => 'form-control','style'=>'text-align:right']) !!} 
                        </div>
                        <div class="col-md-3">
                            {!! html()->text('PrcTot', null)->attributes(['class' => 'form-control','readonly','style'=>'text-align:center','id'=>'PrcTot']) !!} 
                        </div>
                    </div>
                    <div class="row form-group">
                        <div class="col-md-2">
                            {!! html()->label('CLR','clr') !!}
                        </div>
                        <div class="col-md-5">
                            {!! html()->text('clr', null)->attributes(['readonly', 'class' => 'form-control','style'=>'text-align:right']) !!} 
                        </div>
                        <div class="col-md-3">
                            {!! html()->text('PrcCLR', null)->attributes(['class' => 'form-control','readonly','style'=>'text-align:center']) !!} 
                        </div>
                    </div>
                    <div class="row form-group">
                        <div class="col-md-2">
                            {!! html()->label( 'CCPF','ccpf') !!}
                        </div>
                        <div class="col-md-5">
                            {!! html()->text('ccpf', null)->attributes(['readonly', 'class' => 'form-control','style'=>'text-align:right']) !!} 
                        </div>
                        <div class="col-md-3">
                            {!! html()->text('PrcCCPF', null)->attributes(['class' => 'form-control','readonly','style'=>'text-align:center']) !!} 
                        </div>
                    </div>
                </div>

                <div class="col-md-8 callout callout-info">
                    <div class="row form-group">
                        <div class="col-md-2">
                            {!! html()->label('Total','total') !!}
                        </div>
                        <div class="col-md-5" >
                            {!! html()->text('total', null)->attributes(['class' => 'form-control','style'=>'text-align:right','readonly']) !!} 
                        </div>
                    </div>
                    <div class="row form-group">
                        <div class="col-md-2">
                            {!! html()->label( 'Règlement','credit') !!}
                        </div>
                        <div class="col-md-5" >
                            {!! html()->text('credit', null)->attributes(['class' => 'form-control','style'=>'text-align:right']) !!} 
                        </div>
                    </div>
                </div>


                <div class='row form-group'>

                    

                    {!! html()->button('Enregistrer')->value('Enregistrer')->type('submit')->attributes(['class' => 'btn btn-primary']) !!}
                </div>
            {{ html()->form()->close() }}
        </div>
    </div>
@stop

@section('scripts0')
    <script type="text/javascript">
        $(function () {
            $('#datepicker_encais_date').datepicker({
                format: "dd/mm/yyyy",
                language: "fr",
                autoclose: true
            });
        });
    </script>
@stop