@extends('layouts.dash')
@section('title') Cotisations @stop
@section('title_card',"")
@section('subtitle_card',"")

@section('content')
<style>
    .zone_filtre {
        background-color:lightgrey;
        padding:4px;        
    }

</style>

    @if (Session::has('message'))
        <div class="alert alert-warning">{!! Session::get('message') !!}</div>
    @endif
    @if ($errors)
        @foreach ($errors->all() as $error)
            <div class='bg-danger alert'>{!! $error !!}</div>
        @endforeach
    @endif
    @if (Session::has('success'))
        <div class="alert alert-success">{!! \Session::get('success') !!}</div>
    @endif


    <div class="card">
        <div class="card-header bg-warning">
            <h3>Cotisations - Saisie</h3>
        </div>
        <div class="card-body">
            {{ html()->form('POST', url('cotisation_saisie_filtre'))->open() }}
                <div class="row">
                    <div class="col-md-4 ">
                        {!! html()->hidden('employeur_id2', $employeur_id)->attributes(['id'  => 'employeur_id2']) !!}
                        {!! html()->label( 'Employeur','employeur_nom') !!}
                        {!! html()->text('employeur_nom', $employeur_nom)
                            ->attributes(['placeholder' => 'Employeur', 'class' => 'form-control', 'id' => 'employeur_nom','style'=>'background:whitesmoke'])
                        !!}
                    </div>

                        <div class="col-md-1 zone_filtre">
                            {!! html()->label( 'Exercice','annes') !!}
                            {!! html()->select('exercice',$exercices,$exercice)
                                ->placeholder('A définir')
                                ->attributes(['id' => 'exercice_id','class' => 'form-control selectpicker','data-width' => "100%",'style' => 'font-weight:bold;background:whitesmoke'])  !!}
                        </div>

                        <div class="col-md-2 zone_filtre" >
                            {!! html()->label( '&nbsp;ou&nbsp;Encaissements&nbsp;du&nbsp;&nbsp;','mois_debut') !!}
                            <div class="input-group">
                                <div class='input-group date' id='datepicker_mois_debut'>
                                    {!! html()->text('mois_debut',isset($mois_debut)?$mois_debut:$mois_debut)
                                    ->placeholder('Mois Début')->attributes(['size'=>'8', 'class' => 'form-control']) !!}
                                    <span class='input-group-addon'><span class='glyphicon glyphicon-calendar'></span></span>
                                </div>
                            </div>
                        </div>

                        <div class="col-md-2 zone_filtre">
                            {!! html()->label( 'au','mois_fin')->attributes(['style'=>'padding:0px;']) !!}
                            <div class="input-group">
                                <div class='input-group date' id='datepicker_mois_fin'>
                                    {!! html()->text('mois_fin',isset($mois_fin)?$mois_fin:$mois_fin)
                                    ->placeholder('Mois Fin')->attributes(['size'=>'8', 'class' => 'form-control']) !!}
                                    <span class='input-group-addon'><span class='glyphicon glyphicon-calendar'></span></span>
                                </div>
                            </div>
                        </div>

                        <div class="col-md-2 zone_filtre" >
                            {!! html()->label( 'Lettrage','lettrage') !!}
                            {!! html()->select('lettrage',['T'=>'Tout','N'=>'Non lettrées','L'=>'Lettrées'],$lettrage)
                                ->placeholder('A définir')
                                ->attributes(['id' => 'lettrage','class' => 'form-control selectpicker','data-width' => "100%",'style' => 'font-weight:bold;background:whitesmoke'])  !!}
                        </div>
                        <div class="col-md-1 zone_filtre" style="padding-top:34px">
                            {!! html()->button('Filtrer')->value('Filtrer')->type('submit')->attributes(['class' => 'btn btn-primary']) !!}
                        </div>

                </div>
            {{ html()->closeModelForm() }}

            @if($employeur_id)
                <hr/>
                <div class="row col-lg-max" >
                    <div class="col-md-12 bg-default  form-inline">
                        <div style="text-align:left;font-weight:bold;">
                            <span class="text-primary">SOLDE&nbsp;au&nbsp;31/12/{!! (($annee_solde=="*")?date('Y'):$annee_solde)-1 !!}&nbsp;:&nbsp;</span>
                            <input disabled class='text-primary form-control' style='text-align:right' size="9" id='total_SOLDE' value='{!! number_format($t_total["an"], 0, ",", " " ) !!}' />
                            <span class="text-success">&nbsp;&nbsp;SOLDE&nbsp;au&nbsp;{!! date('d/m/Y') !!}&nbsp;:&nbsp;</span>
                            <input disabled class='text-success form-control' style='text-align:right' size="9" id='total_SOLDE' value='{!! number_format($t_total["soldejour"], 0, ",", " ") !!}' />
                        </div>
                        &nbsp;&nbsp;
                        @if($user->can("COT_AJO") || $user->HasRole("ADMINISTRATEUR"))
                           <a href="{!! url('cotisations/create/'.$employeur_id) !!}"
                                    class="btn btn-info" >Nouvelle Cotisation</a>
                        @endif
                        &nbsp;&nbsp;
                        @if($user->can("COT_ENC") || $user->HasRole("ADMINISTRATEUR"))
                            <a href="{!! url('reglement_create/'.$employeur_id.'/'.$exercice) !!}"
                                class="btn btn-success" >Nouveau Règlement</a>
                        @endif
                    </div>
                </div>
            @endif

            <div class='col-lg-12' style="padding-top:15px">
                @if($employeur_id)
                    {{ html()->form('PUT', url('cotisations_lettrage/'.$employeur_id.'/'.$exercice))->open() }}
                        {!! html()->hidden('checkboxes', $checkboxes)->attributes(['id'  => 'checkboxes']) !!}
                        {!! html()->hidden('checklist', '')->attributes(['id'  => 'checklist']) !!}
                        <div class="row">
                            <table id="_table" style="background-color:white;width:100%;" class="table table-striped table-bordered table-hover">
                                <thead class="">
                                    <tr>
                                        <th width='1px'>&nbsp;</th>
                                        <th width='1px'>N°</th>
                                        @if($employeur_id=='TOUS')
                                        <th width='1px'>N°Employeur</th>
                                        @endif
                                        <th width='1px'>Ex</th>
                                        <th width='1px'>Date</th>
                                        <th width='1px'>Type</th>
                                        <th width='1px'>Opé.</th>
                                        <th width='1px'>Pmt</th>
                                        <th width='1px'>CLR</th>
                                        <th width='1px'>CCPF</th>
                                        <th width='1px'>Débit</th>
                                        <th width='1px'>Crédit</th>
                                        <th width='1px'>Mois</th>
                                        <th width='1px'>NbMois</th>
                                        <th width='1px'>NbSal</th>
                                        <th width='1px'>BdPu</th>
                                        <th width='1px'>BdPr</th>
                                        <th width='1px'>DatDépôt</th>
                                        <th width='1px'>DatEncais</th>
                                        @if($lettrage!="N")
                                        <th width='1px'>Lettrage</th>
                                        @endif
                                        <th>Observations</th>
                                        <th width='1%'>&nbsp</th>
                                    </tr>
                                </thead>
                                <tfoot>
                                    <tr class='search_tr' style='background-color:lightgrey'>
                                        <th width='1px'></th>
                                        <th width='1px'></th>
                                    @if($employeur_id=='TOUS')
                                        <th width='1px'></th>
                                    @endif
                                        <th width='1px'></th>
                                        <th width='1px'></th>
                                        <th width='1px'></th>
                                        <th width='1px'></th>
                                        <th width='1px'></th>
                                        <th width='1px'></th>
                                        <th width='1px'></th>
                                        <th width='1px'></th>
                                        <th width='1px'></th>
                                        <th width='1px'></th>
                                        <th width='1px'></th>
                                        <th width='1px'></th>
                                        <th width='1px'></th>
                                        <th width='1px'></th>
                                        <th width='1px'></th>
                                        <th width='1px'></th>
                                        @if($lettrage!="N")
                                        <th></th>
                                        @endif
                                        <th></th>
                                        <th></th>
                                    </tr>
                                </tfoot>
                                <tbody>
                                    <?php $liste_id=''; ?>
                                    @foreach ($cotisations as $cotisation)
                                        <?php
                                            $class_lg='';
                                            if($cotisation->isReglement) $class_lg='success';
                                            $liste_id.=(($liste_id=='')?'':',').$cotisation->id;
                                            $verrou=false;
                                            $num_brd_encours=$user->getParametre('REC_NUM_BORD');
                                            $num_brd_prive_encours=$user->getParametre('REC_NUM_BORD_PRIV');
                                            if(($cotisation->bdx!=0)&&($cotisation->bdx==$num_brd_encours)) $verrou=false;
                                            if(($cotisation->bdx_prive!=0)&&($cotisation->bdx_prive==$num_brd_prive_encours)) $verrou=false;
                                        ?>
                                        <tr>
                                            <td align="center" style="color:grey;padding:0px;margin:0px">
                                                @if($user->can("COT_AJO") || $user->HasRole("ADMINISTRATEUR"))
                                                    @if(($cotisation->credit==0)&&($cotisation->lettrage==''))
                                                    {!! html()->checkbox('box_'.$cotisation->id,false, 1)
                                                        ->attributes(['id'=>'box_'.$cotisation->id,'onclick'=>'check()']); !!}
                                                    @endif
                                                @endif
                                            </td>
                                            <td id='id_{!! $cotisation->id !!}' style="color:grey">
                                                @if($user->can("COT_VISU") || $user->HasRole("ADMINISTRATEUR"))
                                                    <a class="btn btn-sm bg-info" href="{!! url('cotisations/'.$cotisation->id ) !!}">
                                                @endif
                                                    {!! $cotisation->id !!}
                                                @if($user->can("COT_VISU") || $user->HasRole("ADMINISTRATEUR"))
                                                    </a>
                                                @endif
                                            </td>
                                            @if($employeur_id=='TOUS')
                                                <td align="center">{!! $cotisation->sonum !!}</td>
                                            @endif
                                            <td align="center">{!! $cotisation->exercice !!}</td>
                                            <td align="center">{!! $cotisation->date !!}</td>
                                            <td align="center">{!! $cotisation->type_cotis !!}</td>
                                            <td align="center">{!! $cotisation->type_ope !!}</td>
                                            <td align="center">{!! $cotisation->typepmt !!}</td>
                                            <td align="right" nowrap>{!! $cotisation->clr !!}</td>
                                            <td align="right" nowrap>{!! $cotisation->ccpf !!}</td>
                                            <td align="right" style="font-weight:bold;color:darkred" class="" nowrap>{!! $cotisation->debit !!}</td>
                                            <td align="right" style="font-weight:bold;color:darkblue" class="" nowrap>{!! $cotisation->credit !!}</td>
                                            <td>{!! $cotisation->mois !!}</td>
                                            <td align="center">{!! $cotisation->nbmois !!}</td>
                                            <td align="center">{!! $cotisation->nbsal !!}</td>
                                            <td align="right">{!! $cotisation->bdx !!}</td>
                                            <td align="right">{!! $cotisation->bdx_prive !!}</td>
                                            <td align="center">{!! $cotisation->DateDepot !!}</td>
                                            <td align="center">{!! $cotisation->EncaisDate !!}</td>
                                            @if($lettrage!="N")
                                            <td align="center">{!! $cotisation->lettrage2 !!}</td>
                                            @endif
                                            <!--
                                            <td><a href='#' onclick="visu_lettrage('{!! $cotisation->lettrage !!}','{!! $cotisation->id !!}')">
                                                    {!! str_replace(",",", ",$cotisation->lettrage) !!}</a></td>
                                            -->
                                            <td>{!! $cotisation->observation !!}</td>
                                            <td nowrap>
                                                @if((!$verrou) && (1==0))   //SUPRESSION 03/12/20
                                                    @if( ($user->can("COT_MAJ") || $user->HasRole("ADMINISTRATEUR"))

                                                        )
                                                        <a href="{!! url('cotisations/'.$cotisation->id .'/edit') !!}"
                                                            class="btn btn-info pull-left" style="margin-right: 3px;">Modifier</a>
                                                    @endif
                                                    @if(
                                                    ( $user->can("COT_SUP") || $user->HasRole("ADMINISTRATEUR")) &&
                                                    ($cotisation->statut=="") )


                                                        <a href="{!! url('cotisations/delete/'.$cotisation->id.'/'.$exercice) !!}"
                                                            class="btn btn-danger pull-left" style="margin-right: 3px;">Supprimer</a>
                                                    @endif
                                                @endif
                                            </td>
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>

                        <div class="row form-group" style='font-weight:bold;margin-top:20px;margin-bottom:20px'>
                            <div class="col-md-2">
                                <div>TOTAL&nbsp;CLR&nbsp;:&nbsp;</div>
                                <div class='form-control' align='right' id='total_CLR'></div>
                            </div>

                            <div class="col-md-2">TOTAL&nbsp;CCPF&nbsp;:&nbsp;
                            <div class='form-control' align='right' id='total_CCPF'></div>
                            </div>

                            <div class="col-md-2">TOTAL&nbsp;DEBIT&nbsp;:&nbsp;
                            <div class='form-control' style='color:red' align='right' id='total_DEBIT'></div>
                            </div>

                            <div class="col-md-2">TOTAL&nbsp;CREDIT&nbsp;:&nbsp;
                            <div class='form-control' style='color:blue' align='right' id='total_CREDIT'></div>
                            </div>
                        </div>

                        @if($checkboxes!="")
                            <div class="col-md-3" >
                                {!! html()->button('Saisir le règlement')->type('submit')->attributes(['id'=>'bt_reglement','class' => 'btn btn-primary']) !!}
                            </div>
                        @endif
                    {{ html()->form()->close() }}
                @endif
            </div>
        </div>
    </div>

@endsection

@section('scripts0')
    <script>
        $(function () {
            $('#datepicker_mois_debut').datepicker({
                format: "dd/mm/yyyy",
                language: "fr",
                autoclose: true
            });

            $('#datepicker_mois_fin').datepicker({
                format: "dd/mm/yyyy",
                language: "fr",
                autoclose: true
            });
            $("#exercice_id").change(function () {
                    $("#mois_fin").val("");
                    $("#mois_debut").val("");

            })
            $("#employeur_nom").autocomplete({
                source: "{!! route('autocomplete_employeur') !!}",
                minLength: 1,
                select: function(event, ui) {
                    $('#employeur_nom').val(ui.item.id+" "+(ui.item.value.trim()));
                    $('#employeur_id2').val(ui.item.id);
                    if(ui.item.value=="TOUS") $('#employeur_id2').val('TOUS');
                    location.href="{!! url('/cotisation_annee/') !!}/"
                        +$('#employeur_id2').val()+"/"+$('#exercice_id').val();
                },
                close: function(event, ui) {

                }
            });
        } );
    </script>
@endsection

@section('scripts')
    @if($employeur_id)
        <script>
            @if($checkboxes!="")
                    $("#bt_reglement").hide();
                    //Complete la liste des boites cochées
                    function check() {
                        var listbox='<?php echo $checkboxes ?>';
                        var t_listbox=listbox.split(',');
                        var listcheck="";
                        for(i=0;i<t_listbox.length;i++) {
                            if($("#box_"+t_listbox[i]).prop('checked')) {
                                listcheck+=((listcheck=="")?"":",")+t_listbox[i];
                            }
                        }
                        $("#checklist").val(listcheck);
                        if(listcheck=="") $("#bt_reglement").hide();
                        else $("#bt_reglement").show();
                    }
                    check();

            @endif

            @if($employeur_id=='TOUS')
                //var col_visible=[13,14,15,16];
                var col_visible=[15,16,17,18];
                //var col_sortable=[18,19];
                var col_sortable=[20,21];
                var col_numeric=[4];
                var coldep_footer=8;
            @else
                var col_visible=[14,15,16,17];
                //var col_visible=[12,13,14,15];
                //var col_sortable=[17,18];
                var col_sortable=[19,20];
                var col_numeric=[3];
                var coldep_footer=7;
            @endif


            function format(n, sep) {
                sep = sep || "."; // Default to period as decimal separator
                return n.toLocaleString().split(sep)[0]
                    + sep;
            }

            $.fn.dataTable.moment('D/M/YYYY');
            // Setup - add a text input to each footer cell
            $('#_table tfoot th:lt(20)').filter(':gt(0)').each( function (i) {
                var title = $('#_table thead th').eq( $(this).index() ).text();
                size=5;
                if (title === "N°") size=2;
                if (title === "Ex") size=2;
                if (title === "Employeur") size=12;
                if (title === "Observations") size=18;
                $(this).html( '<input size='+size+' type="text" placeholder="'+title+'" data-index="'+i+'" />' );

            } );

            var table =$('#_table').DataTable( {
                bAutoWidth: false,
                bPaginate: false,
                bInfo: true,
                bFilter: true,
                //deferRender:    true,
                scrollY:        "400px",
                scrollX:        true,
                scrollCollapse: true,
                oLanguage: {
                    "sZeroRecords": "Aucune ligne",
                    "sInfo": "Affichage de _START_ &agrave; _END_ sur _TOTAL_ lignes",
                    "sInfoEmpty": "Showing 0 to 0 of 0 records",
                    "decimal": ",",
                    "thousands": " ",
                    "sSearch":"Chercher",

                    buttons: {
                        colvis: 'Colonnes à afficher',
                        copy: 'Copier',
                        print: 'Imprimer',
                        copyTitle: 'Ajouté au presse-papiers',
                        copyKeys: 'Appuyez sur <i>ctrl</i> ou <i>\u2318</i> + <i>C</i> pour copier les données du tableau à votre presse-papiers. <br><br>Pour annuler, cliquez sur ce message ou appuyez sur Echap.',
                        copySuccess: {
                            _: '%d lignes copiées',
                            1: '1 ligne copiée'
                            }
                        }
                    },

                    "aaSorting": [
                        [1,'desc']
                    ],

                    "aoColumnDefs": [
                        { "sTypes": "numeric", "aTargets": col_numeric },
                        { "bSortable": false, "aTargets": col_sortable },
                        { "visible": false, "targets": col_visible },
                    ],


                    dom: "<'row'<'col-sm-1 text-left'f><'col-sm-4'><'col-sm-7 text-right'B>>" +
                    "<'row'<'col-sm-12'tr>>" +
                    "<'row'<'col-sm-12 text-right'>>",

                    buttons: [
                        {extend: 'copy',exportOptions: {columns: ':visible'} },
                        {extend: 'excel',exportOptions: {columns: ':visible'} },
                        'colvis'
                    ],

                "footerCallback": function(row, data, start, end, display) {
                    var api = this.api(), data;
                    var intVal = function ( i ) {
                        return typeof i === 'string' ?
                            i.replace(/[\$,]/g, '')*1 :
                            typeof i === 'number' ?
                                i : 0;
                    };


                    total = api.column(coldep_footer, { page: 'current'}).data().reduce(function(a, b) {
                            return intVal(a) + intVal(b);}, 0);
                    total=format(total,' ');
                    $('#total_CLR').html(total);

                    total = api.column(coldep_footer+1, { page: 'current'}).data().reduce(function(a, b) {
                            return intVal(a) + intVal(b);}, 0);
                    total=format(total, ' ');
                    $('#total_CCPF').html(total);


                    total = api.column(coldep_footer+2, { page: 'current'}).data().reduce(function(a, b) {
                            return intVal(a) + intVal(b);}, 0);
                    var total_debit=total;
                    total=format(total, ' ');
                    $('#total_DEBIT').html(total);

                    total = api.column(coldep_footer+3, { page: 'current'}).data().reduce(function(a, b) {
                            return intVal(a) + intVal(b);}, 0);
                    var total_credit=total;
                    total=format(total, ' ');
                    $('#total_CREDIT').html(total);
                },

            } );

            // Filter event handler
            $( table.table().container() ).on( 'keyup', 'tfoot input', function () {
                table
                    .column( $(this).data('index')+1 )
                    .search( this.value )
                    .draw();
            } );
            $('#_table').DataTable().draw();

            $(window).resize(function () {
                        $('#_table').DataTable().draw();
            });

        </script>

    @endif
@endsection
