@include('forms.fbncheader_nomenu')
@include('forms.fdatatables')

<div class="col-lg-max">
    <h2><i class="fa fa-employeurs"></i><small>Cotisations de l'Employeur </small>{!! $employeur->nom !!}</h2>
    <br/>
    <div class="table-responsive">
        <table id="_table" class="table table-condensed table-hover table-striped table-bordered">
            <thead>
                <tr>
                    <th width='1%'>N°</th>
                    <th width='1%'>Exercice</th>
                    <th >Date</th>
                    <th width='5%'>CLR</th> 
                    <th width='1%'>CCPF</th>
                    <th width='1%'>Débit</th>
                    <th width='1%'>Crédit</th>
                    <th width='1%'>Mois</th>
                    <th width='1%'>Nb&nbsp;Mois</th>
                    <th width='1%'>Borderau&nbsp;Pub</th>
                    <th width='1%'>Borderau&nbsp;Privé</th>
                    <th width='1%'>Date&nbsp;d'encaissement</th>
                    <th width='120px'></th>
                </tr>
            </thead>
 
            <tbody>
                @foreach ($cotisations as $cotisation)
                <tr>
                    <td>{!! $cotisation->id !!}</td>
                    <td>{!! $cotisation->exercice !!}</td>
                    <td>{!! $cotisation->date !!}</td>
                    <td>{!! $cotisation->clr !!}</td>
                    <td>{!! $cotisation->ccpf !!}</td>
                    <td>{!! $cotisation->debit !!}</td>
                    <td>{!! $cotisation->credit !!}</td>
                    <td>{!! $cotisation->mois !!}</td>
                    <td>{!! $cotisation->nbmois !!}</td>
                    <td>{!! $cotisation->bdx !!}</td>
                    <td>{!! $cotisation->bdx_prive !!}</td>
                    <td>{!! $cotisation->encais_date !!}</td>
                </tr>
                @endforeach
            </tbody>
 
        </table>
    </div>

@if($user->can("COT_AJO") || $user->HasRole("ADMINISTRATEUR"))
     <div>
        <h4><a href="{!! url('recouvrement/cotisation_annee/'.$employeur->id) !!}" 
            class="btn btn-success"
            target="_blank">Gestion des Cotisations</a></h4>
    </div> 
@endif

</div>

</body></html>


<script>
$(document).ready(function() {
    $.fn.dataTable.moment('D/M/YYYY');
    $('#_table').dataTable( {
        "bAutoWidth": false,
        "bPaginate": false,
        "bInfo": true,
        "bFilter": true,
        "oLanguage": {
            "sZeroRecords": "Aucune ligne",
            "sInfo": "Affichage de _START_ &agrave; _END_ sur _TOTAL_ lignes",
            "sInfoEmpty": "Showing 0 to 0 of 0 records",
            "sInfoFiltered": "(sur un total de _MAX_ lignes)",
             "sSearch":"Chercher",
            },

        "order": [[ 1, "desc" ]]

        } );
</script>