@extends('layouts.dash')
@section('title') Cotisations @stop
@section('title_card',"")
@section('subtitle_card',"")

@section('content')
<style>
    .zone_filtre {
        background-color:lightgrey;
        padding:4px;        
    }

</style>

    @if (Session::has('message'))
        <div class="alert alert-warning">{!! Session::get('message') !!}</div>
    @endif
    @if ($errors)
        @foreach ($errors->all() as $error)
            <div class='bg-danger alert'>{!! $error !!}</div>
        @endforeach
    @endif
    @if (Session::has('success'))
        <div class="alert alert-success">{!! \Session::get('success') !!}</div>
    @endif

    <div class="card">
        <div class="card-header bg-primary">
            <h3>Cotisations encaissées</h3>
        </div>
        <div class="card-body">
            {{ html()->form('POST', url('cotisation_encaissees_annee'))->open() }}
                <div class="row">
                    <div class="col-md-1  zone_filtre">
                        {!! html()->label( 'Exercice','annes') !!}
                        {!! html()->select('exercice',$exercices,$exercice)->placeholder('A définir')
                            ->attributes(['id' => 'exercice_id','class' => 'form-control selectpicker','data-width' => "100%",'style' => 'font-weight:bold;background:whitesmoke'])  !!}
                    </div>
                    <div class="col-md-2  zone_filtre">
                        {!! html()->label( '&nbsp;ou&nbsp;Encaissements&nbsp;du&nbsp;&nbsp;','mois_debut') !!}
                        <div class="input-group">
                            <div class='input-group date' id='datepicker_mois_debut'>
                                {!! html()->text('mois_debut',isset($mois_debut)?$mois_debut:null)->placeholder('Mois Début')->attributes(['size'=>'8', 'class' => 'form-control']) !!}
                                <span class='input-group-addon'><span class='glyphicon glyphicon-calendar'></span></span>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-2 zone_filtre">
                        {!! html()->label( 'au','mois_fin')->attributes(['style'=>'padding:0px;']) !!}
                        <div class="input-group">
                            <div class='input-group date' id='datepicker_mois_fin'>
                                {!! html()->text('mois_fin',isset($mois_fin)?$mois_fin:null)->placeholder('Mois Fin')->attributes(['size'=>'8', 'class' => 'form-control']) !!}
                                <span class='input-group-addon'><span class='glyphicon glyphicon-calendar'></span></span>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-3 zone_filtre">
                        {!! html()->label( 'Compte','encais_compte') !!}
                        {!! html()->select('encais_compte',App\Models\MyApp::COMPTES_ENCAISSEMENT,isset($encais_compte)?$encais_compte:'')
                            ->placeholder('A définir')
                            ->attributes(['id' => 'encais_compte','class' => 'form-control selectpicker','data-width' => "100%",'style' => 'font-weight:bold;background:whitesmoke'])  !!}
                    </div>
                    <div class="col-md-1 zone_filtre" style="text-align:center;padding-top:34px">
                        {!! html()->button('Filtrer')->value('Filtrer')->type('submit')->attributes(['class' => 'btn btn-primary']) !!}
                    </div>
                    <div class='col-md-3 zone_filtre' style='padding-top:34px'>
                        <span class="h5 text-success"><i>{!! $libelle_filtrage !!}</i></span>
                    </div>
                </div>
            {{ html()->closeModelForm() }}

            <div class='col-lg-12' style="padding-top:15px">
                <div class="row  ">   
                    <table id="_table" style="background-color:white" class="col-lg-12 table table-striped table-bordered table-hover"  >
                        <thead>
                            <tr>
                                <th width='1%'>N°</th>
                                <th width='1%'>Ex</th>
                                <th>Employeur</th>
                                <th width='1%'>Date</th>
                                <th width='1%'>Pmt</th> 
                                <th width='1%'>CLR</th> 
                                <th width='1%'>CCPF</th>
                                <th width='1%'>Débit</th>
                                <th width='1%'>Crédit</th>
                                <th width='1%'>Mois</th>
                                <th width='1%'>NbMois</th>
                                <th width='1%'>BdPu</th>
                                <th width='1%'>BdPr</th>
                                <th width='1%'>DateEnc</th>
                                <th width='1%'>Compte</th>
                                <th >Comptabilité</th>
                            </tr>
                        </thead>    
                        <tfoot>
                            <tr style='background-color:lightgrey'>
                                <th></th>
                                <th></th>
                                <th></th>
                                <th></th>
                                <th></th>                            
                                <th></th>
                                <th></th>
                                <th></th>
                                <th></th>
                                <th></th>
                                <th></th>
                                <th></th>
                                <th></th>
                                <th></th>
                                <th></th>
                                <th></th>
                            </tr>
                        </tfoot>
                        <tbody>
                            @foreach ($cotisations as $cotisation)
                            <tr>
                                <td id='id_{!! $cotisation->id !!}' style="color:grey">
                                    @if($user->can("COT_VISU") || $user->HasRole("ADMINISTRATEUR"))
                                        <a class="btn btn-sm bg-info" href="{!! url('cotisations/'.$cotisation->id ) !!}">
                                    @endif
                                        {!! $cotisation->id !!}
                                    @if($user->can("COT_VISU") || $user->HasRole("ADMINISTRATEUR"))
                                        </a>
                                    @endif
                                </td>
                                <td align="center">{!! $cotisation->exercice !!}</td>
                                <td align="left">{!! $cotisation->NomEmployeur !!}</td>
                                <td align="center">{!! $cotisation->date !!}</td>
                                <td align="center">{!! $cotisation->typepmt !!}</td>
                                <td align="right" nowrap>{!! $cotisation->clr !!}</td>
                                <td align="right" nowrap>{!! $cotisation->ccpf !!}</td>
                                <td align="right" style="font-weight:bold;color:darkred" class="" nowrap>{!! $cotisation->debit !!}</td>
                                <td align="right" style="font-weight:bold;color:darkblue" class="" nowrap>{!! $cotisation->credit !!}</td>
                                <td>{!! $cotisation->mois !!}</td>
                                <td align="center">{!! $cotisation->nbmois !!}</td>
                                <td align="right">{!! $cotisation->bdx !!}</td>
                                <td align="right">{!! $cotisation->bdx_prive !!}</td> 
                                <td align="center">{!! $cotisation->encais_date !!}</td>
                                <td align="center">{!! $cotisation->encais_compte !!}</td>
                                <td align="left">
                                    @if($cotisation->transaction)
                                        <a href="{{ url('grand_livre/'.$cotisation->IdEcriture) }}" target='_blank'>{!! $cotisation->EcritureComptaInfo !!}</a>
                                    @endif
                                </td>
                            </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
                 <div class="row form-group" style='font-weight:bold;margin-top:20px;margin-bottom:20px'>
                    <div class="col-md-2">
                        <div>TOTAL&nbsp;CLR&nbsp;:&nbsp;</div>
                        <div class='form-control' align='right' id='total_CLR'></div>
                    </div>

                    <div class="col-md-2">TOTAL&nbsp;CCPF&nbsp;:&nbsp;
                        <div class='form-control' align='right' id='total_CCPF'></div>
                    </div>

                    <div class="col-md-2">TOTAL&nbsp;DEBIT&nbsp;:&nbsp;
                        <div class='form-control' style='color:red' align='right' id='total_DEBIT'></div>
                    </div>

                    <div class="col-md-2">TOTAL&nbsp;CREDIT&nbsp;:&nbsp;
                        <div class='form-control' style='color:blue' align='right' id='total_CREDIT'></div>
                    </div>

                    <div class="col-md-2">SOLDE&nbsp;:&nbsp;
                        <div class='form-control' style='color:green' align='right' id='total_SOLDE'></div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection


@section('scripts0')
    <script>
        $(function () {
            $('#datepicker_mois_debut').datepicker({
                format: "dd/mm/yyyy",
                language: "fr",
                autoclose: true
            });

            $('#datepicker_mois_fin').datepicker({
                format: "dd/mm/yyyy",
                language: "fr",
                autoclose: true
            });
            $("#exercice_id").change(function () {
                    $("#mois_fin").val("");
                    $("#mois_debut").val("");

            })
        } );
    </script>
@endsection

@section('scripts')
<script>
    $(document).ready(function() {
        $.fn.dataTable.moment('D/M/YYYY');
    
        function format(n, sep) {
            sep = sep || "."; // Default to period as decimal separator
            return n.toLocaleString().split(sep)[0]
                + sep;
        }

        // Setup - add a text input to each footer cell
        $('#_table tfoot th:lt(15)').each( function (i) {
            var title = $('#_table thead th').eq( $(this).index() ).text();
                size=4;
                if (title === "N°") size=2;
                if (title === "Ex") size=2;
                if (title === "Employeur") size=12;
                if (title === "Observations") size=18;
                if (title === "Encaissement") size=18;
                if (title === "Comptabilité") size=18;
                $(this).html( '<input size='+size+' type="text" placeholder="'+title+'" data-index="'+i+'" />' );
        } );



        var table =$('#_table').DataTable( {
            bAutoWidth: false,
            bPaginate: false,
            bInfo: true,
            bFilter: true,
            //deferRender:    true,
            scrollY:        "400px",
            scrollX:        false,
            scrollCollapse: false,
            oLanguage: {
                "sZeroRecords": "Aucune ligne",
                "sInfo": "Affichage de _START_ &agrave; _END_ sur _TOTAL_ lignes",
                "sInfoEmpty": "Showing 0 to 0 of 0 records",
                "decimal": ",",
                "thousands": " ",
                "sSearch":"Chercher",

                buttons: {
                    colvis: 'Colonnes à afficher',
                    copy: 'Copier',
                    print: 'Imprimer',
                    copyTitle: 'Ajouté au presse-papiers',
                    copyKeys: 'Appuyez sur <i>ctrl</i> ou <i>\u2318</i> + <i>C</i> pour copier les données du tableau à votre presse-papiers. <br><br>Pour annuler, cliquez sur ce message ou appuyez sur Echap.',
                    copySuccess: {
                        _: '%d lignes copiées',
                        1: '1 ligne copiée'
                        }
                    }
            },
            "footerCallback": function(row, data, start, end, display) {
                var api = this.api(), data;
                var intVal = function ( i ) {
                    return typeof i === 'string' ?
                        i.replace(/[\$,]/g, '')*1 :
                        typeof i === 'number' ?
                            i : 0;
                };
                total = api.column(5, { page: 'current'}).data().reduce(function(a, b) {
                        return intVal(a) + intVal(b);}, 0);
                total=format(total,' ');
                $('#total_CLR').html(total);
                total = api.column(6, { page: 'current'}).data().reduce(function(a, b) {
                        return intVal(a) + intVal(b);}, 0);
                total=format(total, ' ');
                $('#total_CCPF').html(total);
                total = api.column(7, { page: 'current'}).data().reduce(function(a, b) {
                        return intVal(a) + intVal(b);}, 0);
                var total_debit=total;
                total=format(total, ' ');
                $('#total_DEBIT').html(total);
                total = api.column(8, { page: 'current'}).data().reduce(function(a, b) {
                        return intVal(a) + intVal(b);}, 0);
                var total_credit=total;
                total=format(total, ' ');
                $('#total_CREDIT').html(total);
                total=total_credit-total_debit;
                total=format(total, ' ');
                $('#total_SOLDE').html(total);
            },
            "aaSorting": [
                [0,'desc']
            ],
            "aoColumnDefs": [
                { "sTypes": "numeric", "aTargets": [ 3 ] },
                { bSortable: false, aTargets: [11] },
                { visible: false, targets: [10,11,12,14] },
            ],
            dom: "<'row'<'col-sm-1 text-left'f><'col-sm-4'><'col-sm-7 text-right'B>>" +
            "<'row'<'col-sm-12'tr>>" + "<'row'<'col-sm-12 text-right'>>",
            buttons: [ 
                {extend: 'copy',exportOptions: {columns: ':visible'} },
                {extend: 'excel',exportOptions: {columns: ':visible'} },
                'colvis'
            ],
        } );

        // Filter event handler
        $( table.table().container() ).on( 'keyup', 'tfoot input', function () {
            table
                .column( $(this).data('index') )
                .search( this.value )
                .draw();
        } );

        $('#_table').DataTable().draw();

        $(window).resize(function () {
            $('#_table').DataTable().draw();
        });

    } );
</script>
@endsection


