@include('forms.fbncheader')
@include('forms.fdatatables')

<style type="text/css">
tfoot input {
  width: 100%;
}

</style>

<div style="background-color:rgba(127,255,212,.2);"  class="col-lg-max container-fluid">

    <div style="padding-left:0px" class="col-lg-max">
         <div class="row" style="">   
            <div class="col-md-1" style="padding-left:0px;">
               {!! Html::image("img/entreprise_cotisations.png", 
                    "Cotisations", 
                    array( 'width'=>'120px','maxwidth'=>'10%',
                        "style"=>"padding:4px" ))
                     
                !!} 
            </div>
            <div class="col-md-8" style="padding-left:0px;">
                <h2 style="margin-top:2px;">Cotisations</h2>
            </div>
            <div class="col-md-4" style="padding-left:0px;">
                {!! Form::hidden('employeur_id2', $employeur_id, ['id'  => 'employeur_id2']) !!}
                {!! Form::label('employeur_nom', 'Employeur :' ) !!}
                {!! Form::text('employeur_nom', $employeur_nom, 
                    ['placeholder' => 'Employeur', 'class' => 'form-control'
                        , 'id' => 'employeur_nom','style'=>'background:whitesmoke']) !!}
                 <!-- source: "../autocomplete_employeur", -->
                <script>
                    $(function() { 

                       $("#employeur_nom").autocomplete({
                            source: "{!! route('autocomplete_employeur') !!}",
                            minLength: 1,
                            select: function(event, ui) {
                                $('#employeur_nom').val(ui.item.id+" "+(ui.item.value.trim()));
                                $('#employeur_id2').val(ui.item.id);
                                if(ui.item.value=="TOUS") $('#employeur_id2').val('TOUS');
                                location.href="{!! url('/recouvrement/cotisation_annee/') !!}/"
                                    +$('#employeur_id2').val()+"/"+$('#exercice_id').val();
                            },
                            close: function(event, ui) {
                                
                            }
                        }); 

                    });
                </script>
            </div>
            <div class="col-md-2">
                {!! Form::label('annes', 'Années :' ) !!}
                {!! Form::select('exercice',$exercices,$exercice,
                    [
                        'id' => 'exercice_id','class' => 'form-control selectpicker',
                        'data-width' => "100%",'style' => 'font-weight:bold;background:whitesmoke'
                    ]
                ) 
                !!}
                <script>
                    $(document).ready(function() {
                        $('#exercice_id').on('change', function() {
                            location.href="{!! url('/recouvrement/cotisation_annee/') !!}/"
                                +$('#employeur_id2').val()+"/"+$('#exercice_id').val();
                        });
                    });
                </script>
            </div>



        </div>
    </div>

@if($employeur_id)
    <div style="padding-left:0px" class="col-lg-max col-md-offset-1">
        
            <div class="row" style=''> 
                <div class="col-md-6 bg-warning alert" style='font-weight:bold;'>
                    <div class="col-md-3">
                        SOLDE&nbsp;au&nbsp;31/12/{!! (($exercice=="*")?date('Y'):$exercice)-1 !!}&nbsp;:&nbsp;
                        <div class='form-control' style='color:green' align='right' id='total_SOLDE_AN'>{!! number_format($t_total["an"], 0, ',', ' ') !!}
                        </div>
                    </div>
                    <div class="col-md-1"></div>
                    <div class="col-md-3">
                        SOLDE&nbsp;exercice&nbsp;{!! (($exercice=="*")?date('Y'):$exercice) !!}&nbsp;:&nbsp;
                        <div class='form-control' style='color:green' align='right' id='total_SOLDE'>
                            {!! number_format($t_total["solde"], 0, ',', ' ') !!}
                        </div>
                    </div>
                    <div class="col-md-1"></div>
                    
                    <div class="col-md-3">
                        SOLDE&nbsp;au&nbsp;{!! "31/12/".(($exercice=="*")?date('Y'):$exercice) !!}&nbsp;:&nbsp;
                        <div class='form-control' style='color:green' align='right' id='total_SOLDE'>
                            {!! number_format($t_total["solde"]+$t_total["an"], 0, ',', ' ') !!}
                        </div>
                    </div>
                   
                    <div class="col-md-1"></div>
                </div>
                
                <div class="col-md-2 bg-danger alert" style='font-weight:bold;'>
                    SOLDE&nbsp;au&nbsp;{!! date('d/m/Y') !!}&nbsp;:&nbsp;
                    <div class='form-control' style='color:green' align='right' id='total_SOLDE'>
                        {!! number_format($t_total["soldejour"], 0, ',', ' ') !!}
                    </div>
                </div>
                
            
        </div>
    </div>
@endif



    <div class='col-lg-max' style="padding-top:15px">
        @if($employeur_id)
            {!! Form::open(['url' => 'recouvrement/cotisations_lettrage/'.$employeur_id.'/'.$exercice, 'method' => 'PUT']) !!}
            {!! form::hidden('checkboxes',$checkboxes,['id'=>'checkboxes']) !!}
            {!! form::hidden('checklist','',['id'=>'checklist']) !!}
            <div class="">
                <table id="_table" style="background-color:white"
                    class="table table-striped table-bordered table-hover" width="100%" 
                    >
                    <thead class="">
                        <tr>
                            <th width='1px'>&nbsp;</th>
                            <th width='1%'>N°</th>
                            @if($employeur_id=='TOUS') 
                            <th width='1%'>N°Employeur</th>
                            @endif
                            <th width='1%'>Ex</th>
                            <th width='1%'>Date</th>
                            <th width='1%'>TypeCotis</th>
                            <th width='1%'>Opé.</th>
                            <th width='1%'>Pmt</th> 
                            <th width='1%'>CLR</th> 
                            <th width='1%'>CCPF</th>
                            <th width='1%'>Débit</th>
                            <th width='1%'>Crédit</th>
                            <th width='1%'>Mois</th>
                            <th width='1%'>NbMois</th>
                            <th width='1%'>BdPu</th>
                            <th width='1%'>BdPr</th>
                            <th width='1%'>DatDépôt</th>
                            <th width='1%'>DatEncais</th>
                            <th width='1%'>Lettrage</th>
                            <th>Observations</th>
                            <th width='1%'>&nbsp
                                <div class="col-md-3">
                                    @if($user->can("COT_AJO") || $user->HasRole("ADMINISTRATEUR"))
                                    
                                        <a href="{!! url('recouvrement/cotisations/create/'.$employeur_id) !!}" 
                                                class="btn btn-success" >Nouveau </span></a>
                                    @endif
                                </div>
                            </th>
                        </tr>
                    </thead>  

                    <tfoot>
                        <tr class='search_tr' style='background-color:lightgrey'>
                            <th></th>
                            <th></th>
                            <th></th>
                           @if($employeur_id=='TOUS') 
                            <th></th>
                           @endif
                           <th></th>
                            <th></th>
                            <th></th>
                            <th></th>
                            <th></th>
                            <th></th>
                            <th></th>
                            <th></th>
                            <th></th>
                            <th></th>
                            <th></th>
                            <th></th>
                            <th></th>
                            <th></th>
                            <th></th>
                            <th></th>
                            <th></th>
                        </tr>
                    </tfoot>
 

                    <tbody>
                        <?php $liste_id=''; ?>
                        @foreach ($cotisations as $cotisation)
                        <?php
                            $class_lg=''; 
                            if($cotisation->isReglement) $class_lg='success';
                            $liste_id.=(($liste_id=='')?'':',').$cotisation->id;
                            $verrou=false;
                            $num_brd_encours=$user->getParametre('REC_NUM_BORD');
                            $num_brd_prive_encours=$user->getParametre('REC_NUM_BORD_PRIV');
                            if(($cotisation->bdx!=0)&&($cotisation->bdx==$num_brd_encours)) $verrou=false;
                            if(($cotisation->bdx_prive!=0)&&($cotisation->bdx_prive==$num_brd_prive_encours)) $verrou=false;
                        ?>
                        <tr>
                            <td align="center" style="color:grey;padding:0px;margin:0px">
                             @if($user->can("COT_AJO") || $user->HasRole("ADMINISTRATEUR"))
                                @if(($cotisation->credit==0)&&($cotisation->lettrage==''))
                                {!! Form::checkbox('box_'.$cotisation->id, '1',false
                                , ['id'=>'box_'.$cotisation->id,'onclick'=>'check()']); !!}
                                @endif
                            @endif
                            </td>
                            <td id='id_{!! $cotisation->id !!}' style="color:grey">
                                @if($user->can("COT_VISU") || $user->HasRole("ADMINISTRATEUR"))
                                    <a href="{!! url('recouvrement/cotisations/'.$cotisation->id ) !!}">
                                @endif
                                    {!! $cotisation->id !!}
                                @if($user->can("COT_VISU") || $user->HasRole("ADMINISTRATEUR"))
                                    </a>
                                @endif
                            </td>
                            @if($employeur_id=='TOUS') 
                                <td align="center">{!! $cotisation->sonum !!}</td>
                            @endif
                            <td align="center">{!! $cotisation->exercice !!}</td>
                            <td align="center">{!! $cotisation->date !!}</td>
                            <td align="center">{!! $cotisation->type_cotis !!}</td>
                            <td align="center">{!! $cotisation->type_ope !!}</td>
                            <td align="center">{!! $cotisation->typepmt !!}</td>
                            <td align="right" nowrap>{!! $cotisation->clr !!}</td>
                            <td align="right" nowrap>{!! $cotisation->ccpf !!}</td>
                            <td align="right" style="font-weight:bold;color:darkred" class="" nowrap>{!! $cotisation->debit !!}</td>
                            <td align="right" style="font-weight:bold;color:darkblue" class="" nowrap>{!! $cotisation->credit !!}</td>
                            <td>{!! $cotisation->mois !!}</td>
                            <td align="center">{!! $cotisation->nbmois !!}</td>
                            <td align="right">{!! $cotisation->bdx !!}</td>
                            <td align="right">{!! $cotisation->bdx_prive !!}</td>
                            <td align="center">{!! $cotisation->date_depot !!}</td>
                            <td align="center">{!! $cotisation->encais_date !!}</td>
                            <td><a href='#' onclick="visu_lettrage('{!! $cotisation->lettrage !!}','{!! $cotisation->id !!}')">
                                    {!! str_replace(",",", ",$cotisation->lettrage) !!}</a></td>
                            <td>{!! $cotisation->observation !!}</td>
                            <td nowrap> 
                                @if((!$verrou) && (1==0))   //SUPRESSION 03/12/20                          
                                    @if( ($user->can("COT_MAJ") || $user->HasRole("ADMINISTRATEUR"))

                                        )
                                        <a href="{!! url('recouvrement/cotisations/'.$cotisation->id .'/edit') !!}"
                                             class="btn btn-info pull-left" style="margin-right: 3px;">Modifier</a>
                                    @endif 
                                    @if( 
                                    ( $user->can("COT_SUP") || $user->HasRole("ADMINISTRATEUR")) &&
                                    ($cotisation->statut=="") ) 


                                        <a href="{!! url('recouvrement/cotisations/delete/'.$cotisation->id.'/'.$exercice) !!}"
                                             class="btn btn-danger pull-left" style="margin-right: 3px;">Supprimer</a>
                                    @endif
                                @endif
                            </td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
 

         <div class="col-lg-12 form-group" style='font-weight:bold;padding-top:-30px;margin-bottom:50px'>
            <div class="col-md-2">
                <div>TOTAL&nbsp;CLR&nbsp;:&nbsp;</div>
                <div class='form-control' align='right' id='total_CLR'></div>
            </div>

            <div class="col-md-2">TOTAL&nbsp;CCPF&nbsp;:&nbsp;
            <div class='form-control' align='right' id='total_CCPF'></div>
            </div>

            <div class="col-md-2">TOTAL&nbsp;DEBIT&nbsp;:&nbsp;
            <div class='form-control' style='color:red' align='right' id='total_DEBIT'></div>
            </div>

            <div class="col-md-2">TOTAL&nbsp;CREDIT&nbsp;:&nbsp;
            <div class='form-control' style='color:blue' align='right' id='total_CREDIT'></div>
            </div>


        </div>

            
            @if($checkboxes!="")  
                <div class="col-md-3" >     
                        {!! Form::submit('Saisir le règlement', ['id'=>'bt_reglement','class' => 'btn btn-primary']) !!} 
                </div> 
            @endif
            {!! Form::close() !!}
        @endif
    </div>

    
</div>

</body></html>




@if($employeur_id)
    @if($checkboxes!="")  
        <script>
            $("#bt_reglement").hide();
            //Complete la liste des boites cochées
            function check() {
                var listbox='<?php echo $checkboxes ?>';
                var t_listbox=listbox.split(',');
                var listcheck="";
                for(i=0;i<t_listbox.length;i++) {
                    if($("#box_"+t_listbox[i]).prop('checked')) {
                        listcheck+=((listcheck=="")?"":",")+t_listbox[i];
                    }
                }
                $("#checklist").val(listcheck);
                if(listcheck=="") $("#bt_reglement").hide();
                else $("#bt_reglement").show();
            }
            check();
        </script>
    @endif 

<script>
    function visu_lettrage(let,sel) {
        var liste_cotis='<?php echo $liste_id ?>';
        var t_cotis=liste_cotis.split(',');
        var t_let=let.split(',');
        for(i=0;i<t_cotis.length;i++) {
            $("#id_"+t_cotis[i]).css({"background-color": ''});
            for(j=0;j<t_let.length;j++) {
                if(t_let[j]==t_cotis[i]) $("#id_"+t_cotis[i]).css({"background-color": 'lightblue'});
            }
        }
        $("#id_"+sel).css({"background-color": 'lightblue'}); 
    }




    $(document).ready(function() {

        $.fn.dataTable.moment('D/M/YYYY');

        @if($employeur_id=='TOUS') 
            var col_visible=[13,14,15,16];
            var col_sortable=[18,19];
            var col_numeric=[4];
            var coldep_footer=6;
        @else
            var col_visible=[12,13,14,15];
            var col_sortable=[17,18];
            var col_numeric=[3];
            var coldep_footer=5;
        @endif

        function format(n, sep) {
            sep = sep || "."; // Default to period as decimal separator
            return n.toLocaleString().split(sep)[0]
                + sep;
        }

        // Setup - add a text input to each footer cell
        $('#_table tfoot th:lt(17)').filter(':gt(0)').each( function (i) {
            var title = $('#_table thead th').eq( $(this).index() ).text();
            $(this).html( '<input id="input_'+i+'" type="text" placeholder="'+title+'" data-index="'+i+'" />');
        } );

        var table =$('#_table').DataTable( {
                bAutoWidth: false,
                bPaginate: false,
                bInfo: true,
                bFilter: true,
                deferRender:    true,
                scrollY:        400,
                scrollX:        '100%',
                scrollCollapse: true,
                scroller:       true,

                oLanguage: {
                    "sZeroRecords": "Aucune ligne",
                    "sInfo": "Affichage de _START_ &agrave; _END_ sur _TOTAL_ lignes",
                    "sInfoEmpty": "Showing 0 to 0 of 0 records",
                    "decimal": ",",
                    "thousands": " ",
                    "sSearch":"Chercher",

                    buttons: {
                        colvis: 'Colonnes à afficher',
                        copy: 'Copier',
                        print: 'Imprimer',
                        copyTitle: 'Ajouté au presse-papiers',
                        copyKeys: 'Appuyez sur <i>ctrl</i> ou <i>\u2318</i> + <i>C</i> pour copier les données du tableau à votre presse-papiers. <br><br>Pour annuler, cliquez sur ce message ou appuyez sur Echap.',
                        copySuccess: {
                            _: '%d lignes copiées',
                            1: '1 ligne copiée'
                            }
                        }
                    },

                    "aaSorting": [
                        [1,'desc']
                    ],

                    "aoColumnDefs": [
                        { "sTypes": "numeric", "aTargets": col_numeric },
                        { "bSortable": false, "aTargets": col_sortable },
                        { "visible": false, "targets": col_visible },
                    ],


                    dom: "<'row'<'col-sm-1 text-left'f><'col-sm-4'><'col-sm-6 text-right'B>>" +
                    "<'row'<'col-sm-12'tr>>" +
                    "<'row'<'col-sm-12 text-right'i><'col-sm-7'p>>",

                    buttons: [ 
                        {extend: 'copy',exportOptions: {columns: ':visible'} },
                        {extend: 'excel',exportOptions: {columns: ':visible'} },
                        {extend: 'pdf',exportOptions: {columns: ':visible'} },
                        {extend: 'print',exportOptions: {columns: ':visible'} },
                        'colvis'
                    ],

            "footerCallback": function(row, data, start, end, display) {
                var api = this.api(), data;
                var intVal = function ( i ) {
                    return typeof i === 'string' ?
                        i.replace(/[\$,]/g, '')*1 :
                        typeof i === 'number' ?
                            i : 0;
                };

                
                total = api.column(coldep_footer, { page: 'current'}).data().reduce(function(a, b) {
                        return intVal(a) + intVal(b);}, 0);
                total=format(total,' ');
                $('#total_CLR').html(total);

                total = api.column(coldep_footer+1, { page: 'current'}).data().reduce(function(a, b) {
                        return intVal(a) + intVal(b);}, 0);
                total=format(total, ' ');
                $('#total_CCPF').html(total);


                total = api.column(coldep_footer+2, { page: 'current'}).data().reduce(function(a, b) {
                        return intVal(a) + intVal(b);}, 0);
                var total_debit=total;
                total=format(total, ' ');
                $('#total_DEBIT').html(total);

                total = api.column(coldep_footer+3, { page: 'current'}).data().reduce(function(a, b) {
                        return intVal(a) + intVal(b);}, 0);
                var total_credit=total;
                total=format(total, ' ');
                $('#total_CREDIT').html(total);  


                //total=total_credit-total_debit;
                //total=format(total, ' ');
                //$('#total_SOLDE').html(total);              
            },

        } );


        // Filter event handler
        $( table.table().container() ).on( 'keyup', 'tfoot input', function () {
            table
                .column( $(this).data('index')+1 )
                .search( this.value )
                .draw();
        } );



        $('#_table').DataTable().draw();

        $(window).resize(function () {
                    $('#_table').DataTable().draw();
        });





} );


</script>

@endif 
