@extends('layouts.dash')
@section('title') Consultation @stop
@section('title_card') @stop
@section('subtitle_card',"")

@section('content')
    @if ($errors)
        @foreach ($errors->all() as $error)
            <div class='bg-danger alert'>{!! $error !!}</div>
        @endforeach
    @endif
    
     <div class="card card-primary">
        <div class="card-header">
            @if($cotisation->isReglement)
                Consultation du règlement 
            @else
                Consultation de la cotisation 
            @endif
            N°{!! $cotisation->id !!}
        </div>
        <div class="card-body">
            <div class="form-horizontal">
                <div class="tab-content">
                    @if($cotisation->isReglement)
                        @include('recouvrement.cotisations.show_reglement_field')
                    @else
                        @include('recouvrement.cotisations.show_cotisation_field')
                    @endif
                    
                </div>
            </div>

            <div class="row form-group">

                <a href="{!! url('/cotisation_annee').'/'.$cotisation->sonum !!}"   class="btn btn-warning pull-left"style="margin-right: 3px;">Retour</a>
                
                @if($user->can("COT_MAJ")||($user->hasRole('ADMINISTRATEUR')))
                    <a class="btn btn-primary" href="{!! url('/cotisations/'.$cotisation->id.'/edit') !!}">Modifier</a>
                @endif
            </div>
        </div>
    </div>
@endsection

