

    <div class="form-group row">
        <div class="col-md-10">
            {!! html()->label( 'Employeur','sonum') !!}
            <div class="input-group">
                <div class="input-group-prepend">
                    <span class="input-group-text" id="ref_employeur">{!! $cotisation->sonum !!}</span>
                </div>
                {!! html()->text('sonum', $cotisation->nom_employeur)->placeholder("")->attributes(['disabled' => 'true', 'class' => 'form-control']) !!}
            </div>
        </div>

        <div class="col-md-2">
            {!! html()->label( 'Date d\'entrée','date') !!}
            <div class='input-group date' id='datepicker_date_med'>
                {!! html()->text('date_med', $cotisation->date)->placeholder("")->attributes(['disabled' => 'true', 'class' => 'form-control']) !!}
            </div>
        </div>
    </div>


    <div class="form-group row">
        <div class="col-md-2">
            {!! html()->label( 'Exercice','exercice') !!}
            {!! html()->text('exercice', $cotisation->exercice)->placeholder("")->attributes(['disabled' => 'true', 'class' => 'form-control']) !!}
        </div>

        <div class="col-md-4">
            {!! html()->label( 'Type','type_cotis') !!}
            {!! html()->select('type_cotis',$types_cotisation,$cotisation->type_cotis)
                    ->placeholder('A définir')
                    ->attributes(['disabled' => 'true','class' => 'form-control'])  !!}
        </div>
    </div>

    <div class="form-group row">
        <div class="col-md-2">
            {!! html()->label( 'Nb mois','nbmois') !!}
            {!! html()->text('nbmois', $cotisation->nbmois)->placeholder("")->attributes(['disabled' => 'true', 'class' => 'form-control']) !!}
        </div>
        <div class="col-md-3">
            {!! html()->label( 'Mois de départ','mois') !!}
            <div class='input-group date' id='datepicker_date_med'>
                {!! html()->text('mois', $cotisation->mois)->placeholder("")->attributes(['disabled' => 'true', 'class' => 'form-control']) !!}
            </div>
        </div>

        <div class="col-md-3">
            {!! html()->label( 'Nb salariés','nbsal') !!}
            {!! html()->text('nbsal', $cotisation->nbsal)->placeholder("")->attributes(['disabled' => 'true', 'class' => 'form-control']) !!}
        </div>
    </div>


    <div class="form-group row">
        <div class="col-md-3">
            {!! html()->label( 'N°Bordereau','bdx') !!}
            {!! html()->text('bdx', $cotisation->bdx)->placeholder("")->attributes(['disabled' => 'true', 'class' => 'form-control']) !!}
        </div>

        <div class="col-md-3">
            {!! html()->label( 'N° Bordereau privé','bdx_prive') !!}
            {!! html()->text('bdx_prive', $cotisation->bdx_prive)->placeholder("")->attributes(['disabled' => 'true', 'class' => 'form-control']) !!}
        </div>
    </div>

    <div class='form-group row'>
        <div class="col-md-12">
            {!! html()->label( 'Observations','observation') !!}
            {!! html()->text('observation', $cotisation->observation)->placeholder("")->attributes(['disabled' => 'true', 'class' => 'form-control', 'rows'=>'2']) !!}
        </div>
    </div>


    <div class='form-group col-md-8'>
        <div class="">
            <fieldset class="">
                <legend class="h4">Règlement</legend>
                <div class="form-group"  style="padding:5px">
                    <div class="col-md-3">
                        {!! html()->label('Compte','compte',) !!}
                        {!! html()->text('compte', null)->attributes(['disabled' => 'true','class' => 'form-control']) !!}
                    </div>
                    <div class="col-md-3">
                        {!! html()->label( 'Type de paiement','typepmt') !!}
                        {!! html()->select('typepmt',$types_paiement,$cotisation->typepmt)
                                ->placeholder('A définir')
                                ->attributes(['disabled' => 'true','class' => 'form-control'])  !!}
                   </div>
                    <div class="col-md-3">
                        {!! html()->label( 'Date de dépôt','date_depot') !!}
                        {!! html()->text('date_depot', ($cotisation->date_depot=="0000-00-00")?"":$cotisation->date_depot)
                            ->attributes(['disabled' => 'true','class' => 'form-control']) !!}
                    </div>
                </div>


               <div class="form-group bg-info" style="padding:5px">
                    <div class="col-md-3">
                        {!! html()->label('Règlement','credit') !!}
                    </div>
                    <div class="col-md-3" >
                        {!! html()->text('credit', number_format($cotisation->credit,0,","," "))
                            ->attributes(['disabled' => 'true','class' => 'form-control','style'=>'font-weight:bold;text-align:right']) !!} 
                    </div>
                    @if ($cotisation->credit>0)
                    <div class="col-sm-2">
                        <a href="{!! url('cotisations_recu/'.$cotisation->id) !!}" 
                        id='btn_ajout_enfant'  class="box_versement fancybox.iframe btn btn-warning" 
                        target="_blank">Imprimer le reçu</a>
                    </div>
                    @endif

                </div>


               <div class="form-group bg-warning" style="padding:5px;">
                    <?php
                        $nb_reglements=count(explode(',',$cotisation->ListeReglements));
                        $nb_cotisations=count(explode(',',$cotisation->ListeCotisations));
                        //Mise en forme des listes
                        $liste_reglement=str_replace($cotisation->id,"",$cotisation->ListeReglements);
                        $liste_reglement=str_replace(",,",",",$liste_reglement);
                        if(substr($liste_reglement,-1)==",") $liste_reglement=substr($liste_reglement,0,strlen($liste_reglement)-1);
                    ?>
                    @if($nb_reglements>1)
                    <div class="col-md-12" >
                        {!! html()->label( ($nb_reglements-1)."  autres règlements associés : ".$liste_reglement,'credit')
                            ->attributes(['style'=>'text-align:right;font-weight:normal']) !!} 

                        {!! html()->label(" pour un montant total de : ".number_format($cotisation->TotalReglements,0,","," ")." CFP",'credit')
                            ->attributes(['style'=>'white-space: nowrap;text-align:right;font-weight:normal']) !!} 
                    </div>
                    @endif

                    <div class="form-group col-md-10"></div>


                    
                    <div class="col-md-12" >
                        @if($nb_cotisations>1)
                            {!! html()->label("Cotisations associées au".(($nb_reglements>1)?"x":"")." règlement".(($nb_reglements>1)?"s":"")." ".$cotisation->ListeCotisations,'credit')
                                ->attributes(['style'=>'font-weight:normal']) 
                            !!} 

                            {!! Form::label(" pour un montant total de : ".number_format($cotisation->TotalCotisations,0,","," ")." CFP",'credit') 
                                ->attributes(['style'=>'font-weight:normal']) 
                            !!} 
                        @else
                            {!! Form::label( "Cotisation associée à ce règlement : ".$cotisation->ListeCotisations." pour un montant total de : ".number_format($cotisation->TotalCotisations,0,","," ")." CFP",'credit') 
                                ->attributes(['style'=>'white-space: nowrap;text-align:right;font-weight:normal']) 
                            !!} 
                        @endif
                    </div>


                </div>
            </fieldset>
        </div>
    </div>







