@extends('layouts.master')


@section('title') Nouvelle fiche Mise en demeure @stop
 
@section('content')
 
<div class="col-lg-max col-lg-offset-1">
 
    @if ($errors)
        @foreach ($errors->all() as $error)
            <div class='bg-danger alert'>{!! $error !!}</div>
        @endforeach
    @endif

    <h1><i class='fa fa-banque'></i> Nouvelle Mise en demeure</h1>

    {!! Form::open(['med' => 'form', 'url' => '/recouvrement/med', 'class' => 'form-horizontal']) !!}

    <div class="tab-content">

        <div class="form-group">
            <div class="col-md-4">
                {!! Form::label('sonum', 'Employeur') !!}
                {!! 
                Form::select('sonum',array(""=>"")+$liste_employeur,
                    $employeur->id,
                    [
                        'class' => 'selectpicker show-tick',
                        'id' => 'sonum',
                        'data-width' => "100%",
                    ]
                    ) 
                !!}
            </div>
        </div>


        <div class="form-group">
            <div class="col-md-4">
                {!! Form::label('date_envoi', 'Date d\'envoi') !!}
                <div class="input-group">
                    <div class='input-group date' id='datepicker_date_envoi'>
                            {!! Form::text('date_envoi', date('j/m/Y'), ['placeholder' => 'Date d\'envoi', 'class' => 'form-control']) !!}
                        <span class='input-group-addon'><span class='glyphicon glyphicon-calendar'></span></span>

                        <script type="text/javascript">
                            $(function () {
                                $('#datepicker_date_envoi').datepicker({
                                    format: "dd/mm/yyyy",
                                    language: "fr",
                                    autoclose: true
                                });
                            });
                        </script>
                    </div>
                </div>
            </div>
        </div>

        <div class="form-group">
            <div class='col-md-4'>
                {!! Form::label('motif', 'Motif') !!}
                <br/>
                {!! 
                Form::select(
                    'motif',
                    [   ''=>' ',
                        'TAR' => 'Production tardive', 
                        'ABS' => 'Absence ou insuffisance de versement', 
                        'BOR' => 'Défaut de production du bordereau de déclaration nomminative',
                        'RET' => 'Retard dans le versement', 
                        'RED' => 'Redressement suite au contrôle', 
                        ],
                    '',
                    [
                        'class' => 'selectpicker','data-width' => "100%",
                    ]
                ) 
            !!}
            </div>


            <div class='form-group'>
                <div class="col-md-1">
                {!! Form::label('nbmois', 'Mois&nbsp;manquants') !!}
                {!! Form::text('nbmois', $nbmois, ['id'=>'nbmois','placeholder' => 'Mois manquants', 'class' => 'form-control']) !!}
                </div>
            </div>
        </div>

        <div class='form-group'>
            <div class="col-md-6">
                <fieldset class="">
                    <legend class="h4">Période</legend>
                    <div class="col-md-4">
                        {!! Form::label('periode_deb', 'Début') !!}
                        <div class="input-group">
                            <div class='input-group date' id='datepicker_periode_debut'>
                                    {!! Form::text('periode_deb', '01/01/'.(date('Y')-1), ['placeholder' => 'Début', 'class' => 'form-control']) !!}
                                <span class='input-group-addon'><span class='glyphicon glyphicon-calendar'></span></span>

                                <script type="text/javascript">
                                    $(function () {
                                        $('#datepicker_periode_debut').datepicker({
                                            format: "dd/mm/yyyy",
                                            language: "fr",
                                            autoclose: true
                                        });
                                    });
                                </script>
                            </div>
                        </div>
                    </div>

                    <div class="col-md-4">
                        {!! Form::label('periode_fin', 'Fin') !!}
                        <div class="input-group">
                            <div class='input-group date' id='datepicker_periode_fin'>
                                    {!! Form::text('periode_fin', '31/12/'.(date('Y')-1), ['placeholder' => 'Fin', 'class' => 'form-control']) !!}
                                <span class='input-group-addon'><span class='glyphicon glyphicon-calendar'></span></span>

                                <script type="text/javascript">
                                    $(function () {
                                        $('#datepicker_periode_fin').datepicker({
                                            format: "dd/mm/yyyy",
                                            language: "fr",
                                            autoclose: true
                                        });
                                    });
                                </script>
                            </div>
                        </div>
                    </div>
                </fieldset>
            </div>
        </div>


        <div class='form-group'>
            <div class="col-md-6">
                <fieldset class="">
                    <legend class="h4">Cotisation</legend>

                    <div class="form-group bg-danger" style="padding:5px">
                        <div class="col-md-3">
                            {!! Form::label('cotisations', 'Costisations') !!}
                        </div>
                        <div class="col-md-3" >
                            {!! Form::text('cotisations', $cotisations, ['placeholder' => 'Costisations'
                                , 'class' => 'form-control','style'=>'text-align:right']) !!} 
                        </div>

                        <br/><br/>

                        <div class="col-md-3">
                            {!! Form::label('majorations', 'Majorations') !!}
                        </div>
                        <div class="col-md-3">
                            {!! Form::text('majorations', $majorations, ['placeholder' => 'majorations'
                                ,'class' => 'form-control','style'=>'text-align:right']) !!} 
                        </div>
                    </div>


                   <div class="form-group bg-info" style="padding:5px">
                        <div class="col-md-3">
                            {!! Form::label('total', 'Total de la dette') !!}
                        </div>
                        <div class="col-md-3" >
                            {!! Form::text('total', ($cotisations+$majorations), ['class' => 'form-control'
                                ,'style'=>'text-align:right','disabled'=>'true']) !!} 
                        </div>
                    </div>
                </fieldset>
            </div>
        </div>


        <div class='form-group'>
            <div class="col-md-6">
            {!! Form::label('obs', 'Observations') !!}
            {!! Form::textarea('obs', null, ['placeholder' => 'Observations', 'class' => 'form-control', 'rows'=>'3']) !!}
            </div>
        </div>


</div>

    <div class='form-group'>
        {!! Form::submit('Enregistrer', ['class' => 'btn btn-primary']) !!}
    </div>
 
    {!! Form::close() !!}
 
</div>

@stop