@extends('layouts.master')
 
@section('title') Mise à jour Mise en demeure  @stop
 
@section('content')
 
<div class='col-lg-8 col-lg-offset-2'>
 
    @if ($errors)
        @foreach ($errors->all() as $error)
            <div class='bg-danger alert'>{!! $error !!}</div>
        @endforeach
    @endif
 
    <h1><i class='fa fa-user'></i> Mise à jour d'une Mise en demeure</h1>
 
    {!! Form::model($med, ['med' => 'form', 'url' => '/recouvrement/med' . $med->id, 'method' => 'PUT']) !!}
  
         <div class="form-group">
            <div class="col-md-1">
                    {!! Form::label('numero', 'Numéro') !!}
                    {!! Form::text('numero', '', ['placeholder' => 'Numéro','disabled','class' => 'form-control']) !!}
            </div>
        </div>

        <div class="form-group">
            <div class="col-md-4">
                {!! Form::label('sonum', 'Employeur') !!}
                {!! 
                Form::select('sonum',array(""=>"")+$liste_employeur,
                    $employeur->id,
                    [
                        'class' => 'selectpicker show-tick',
                        'id' => 'sonum',
                        'data-width' => "100%",
                    ]
                    ) 
                !!}
            </div>
        </div>


        <div class="form-group">
            <div class="col-md-4">
                {!! Form::label('date_envoi', 'Date d\'envoi') !!}
                <div class="input-group">
                    <div class='input-group date' id='datepicker_date_envoi'>
                            {!! Form::text('date_envoi', date('j/m/Y'), ['placeholder' => 'Date d\'envoi', 'class' => 'form-control']) !!}
                        <span class='input-group-addon'><span class='glyphicon glyphicon-calendar'></span></span>

                        <script type="text/javascript">
                            $(function () {
                                $('#datepicker_date_envoi').datepicker({
                                    format: "dd/mm/yyyy",
                                    language: "fr",
                                    autoclose: true
                                });
                            });
                        </script>
                    </div>
                </div>
            </div>
        </div>

        <div class="form-group">
            <div class='col-md-4'>
                {!! Form::label('motif', 'Motif') !!}
                <br/>
                {!! 
                Form::select(
                    'motif',
                    [   ''=>' ',
                        'TAR' => 'Production tardive', 
                        'ABS' => 'Absence ou insuffisance de versement', 
                        'BOR' => 'Défaut de production du bordereau de déclaration nomminative',
                        'RET' => 'Retard dans le versement', 
                        'RED' => 'Redressement suite au contrôle', 
                        ],
                    '',
                    [
                        'class' => 'selectpicker','data-width' => "100%",
                    ]
                ) 
            !!}
            </div>

            <div class='form-group'>
                <div class="col-md-1">
                {!! Form::label('nbmois', 'Mois manquants') !!}
                {!! Form::text('nbmois', null, ['id' =>'nbmois','placeholder' => 'Mois manquants', 'class' => 'form-control']) !!}
                </div>
            </div>

        </div>

        <div class='form-group'>
            <div class="col-md-6">
                <fieldset class="">
                    <legend class="h4">Période</legend>
                    <div class="col-md-4">
                        {!! Form::label('periode_deb', 'Début') !!}
                        <div class="input-group">
                            <div class='input-group date' id='datepicker_periode_debut'>
                                    {!! Form::text('periode_deb', '', ['placeholder' => 'Début', 'class' => 'form-control']) !!}
                                <span class='input-group-addon'><span class='glyphicon glyphicon-calendar'></span></span>

                                <script type="text/javascript">
                                    $(function () {
                                        $('#datepicker_periode_debut').datepicker({
                                            format: "dd/mm/yyyy",
                                            language: "fr",
                                            autoclose: true
                                        });
                                    });
                                </script>
                            </div>
                        </div>
                    </div>

                    <div class="col-md-4">
                        {!! Form::label('periode_fin', 'Fin') !!}
                        <div class="input-group">
                            <div class='input-group date' id='datepicker_periode_fin'>
                                    {!! Form::text('periode_fin', '', ['placeholder' => 'Fin', 'class' => 'form-control']) !!}
                                <span class='input-group-addon'><span class='glyphicon glyphicon-calendar'></span></span>

                                <script type="text/javascript">
                                    $(function () {
                                        $('#datepicker_periode_fin').datepicker({
                                            format: "dd/mm/yyyy",
                                            language: "fr",
                                            autoclose: true
                                        });
                                    });
                                </script>
                            </div>
                        </div>
                    </div>
                </fieldset>
            </div>
        </div>


        <div class='form-group'>
            <div class="col-md-6">
                <fieldset class="">
                    <legend class="h4">Cotisation</legend>

                    <div class="form-group bg-danger" style="padding:5px">
                        <div class="col-md-3">
                            {!! Form::label('cotisations', 'Costisations') !!}
                        </div>
                        <div class="col-md-3" >
                            {!! Form::text('cotisations', null, ['placeholder' => 'Costisations'
                                , 'class' => 'form-control','style'=>'text-align:right']) !!} 
                        </div>

                        <br/><br/>

                        <div class="col-md-3">
                            {!! Form::label('majorations', 'Majorations') !!}
                        </div>
                        <div class="col-md-3">
                            {!! Form::text('majorations', null, ['placeholder' => 'majorations'
                                ,'class' => 'form-control','style'=>'text-align:right']) !!} 
                        </div>
                    </div>


                   <div class="form-group bg-info" style="padding:5px">
                        <div class="col-md-3">
                            {!! Form::label('total', 'Total de la dette') !!}
                        </div>
                        <div class="col-md-3" >
                            {!! Form::text('total', null, ['class' => 'form-control'
                                ,'style'=>'text-align:right','disabled'=>'true']) !!} 
                        </div>
                    </div>
                </fieldset>
            </div>
        </div>


        <div class='form-group'>
            <div class="col-md-6">
            {!! Form::label('obs', 'Observations') !!}
            {!! Form::textarea('obs', null, ['placeholder' => 'Observations', 'class' => 'form-control', 'rows'=>'3']) !!}
            </div>
        </div>


<div class="col-sm-9">
    <div class='form-group'>
        {!! Form::submit('Enregistrer', ['class' => 'btn btn-primary']) !!}
    </div>
 </div>

    {!! Form::close() !!}
 
</div>
 
@stop

<script>
    $("#nbmois").change(function() { set_Taux(); });

//Positionne les taux en fonction de l'année
    function set_Taux() {
        var taux_CLR = <?php echo json_encode($taux_CLR) ?>;
        var taux_CPF = <?php echo json_encode($taux_CPF) ?>;
        var statut = <?php echo json_encode($employeur->statut) ?>;
        
        var exercice=$("#mois").val();
        if(exercice.length<10) return;
        var year=parseInt(exercice.substr(6,4));

        $("#PrcCLR").val("");
        $("#PrcCCPF").val("");
        $("#PrcTot").val("");

        if(taux_CLR[year]) $("#PrcCLR").val(taux_CLR[year]);
        if(statut=="ASV") {
            $("#PrcCCPF").val("Non concerné");
        } else {
            if(taux_CPF[year]) $("#PrcCCPF").val(taux_CPF[year]);
        }

        var t1=parseFloat($("#PrcCLR").val());
        var t2=0;
        if(statut!="ASV") {
            t2=parseFloat($("#PrcCCPF").val());
        }

        if($("#box_clr").is(':checked')) {t1=0;$("#PrcCLR").val(0);}
        if($("#box_ccpf").is(':checked')) {t2=0;$("#PrcCCPF").val(0);}

        $("#PrcTot").val(t1+t2);
        $("#PrcTot").val(t1+t2);

        taux_CLR[year];

        calcul();
        return;
    }
</script>