@extends('layouts.master')


@section('title') Nouvelle fiche cotisation @stop
 
@section('content')
 
<div class="col-lg-max col-lg-offset-1">
 
    @if ($errors)
        @foreach ($errors->all() as $error)
            <div class='bg-danger alert'>{!! $error !!}</div>
        @endforeach
    @endif

    <h1><i class='fa fa-banque'></i>Nouvelle cotisation</h1>

    {!! Form::open(['cotisation' => 'form', 'url' => '/recouvrement/cotisations', 'class' => 'form-horizontal']) !!}

    <div class="tab-content">   
        <div class="form-group">
            <div class="col-md-4">
                {!! Form::label('sonum', 'Employeur') !!}
                {!! 
                Form::select('sonum',array(""=>"")+$liste_employeur,$employeur_id,
                    [
                        'class' => 'selectpicker show-tick',
                        'id' => 'sonum',
                        'data-width' => "100%",
                        'disabled' => ($employeur_id!="")?'true':'false',
                    ]
                    ) 
                !!}
            </div>

            <div class="col-md-4">
                {!! Form::label('date', 'Date d\'entrée') !!}
                <div class="input-group">
                    <div class='input-group date' id='datepicker_date'>
                            {!! Form::text('date', '', ['placeholder' => 'Date', 'class' => 'form-control']) !!}
                        <span class='input-group-addon'><span class='glyphicon glyphicon-calendar'></span></span>
                        <script type="text/javascript">
                            $(function () {
                                $('#datepicker_date').datepicker({
                                    format: "dd/mm/yyyy",
                                    language: "fr",
                                    autoclose: true
                                });
                            });
                        </script>
                    </div>
                </div>
            </div>
        </div>



        <div class="form-group">
            <div class="col-md-1">
                    {!! Form::label('exercice', 'Exercice') !!}
                    {!! Form::select('exercice',$exercices,date('Y'),
                        [
                            'id' => 'exercice_id','class' => 'form-control selectpicker',
                            'data-width' => "100%",'style' => 'font-weight:bold;'
                        ]
                    ) 
                    !!}
            </div>

            <div class="col-xs-2">
                {!! Form::label('type_cotis', 'Type de cotisation') !!}
                {!! 
                Form::select(
                    'type_cotis',$types_cotisation,
                    '',
                    [
                        'class' => 'selectpicker'
                        ,'data-width' => "100%"
                        ,'placeholder' => 'Type'
                    ]
                ) 
                    
                !!}
            </div>
        </div>


        <div class="form-group">
            <div class="col-md-1">
                    {!! Form::label('nbmois', 'Nombre de mois') !!}
                    {!! Form::text('nbmois', null, ['placeholder' => 'Nombre de mois','class' => 'form-control']) !!}
            </div>

            <div class="col-md-3">
                {!! Form::label('mois', 'Mois de départ') !!}
                <div class="input-group">
                    <div class='input-group date' id='datepicker_mois'>
                            {!! Form::text('mois', '', ['placeholder' => 'Mois de départ', 'class' => 'form-control']) !!}
                        <span class='input-group-addon'><span class='glyphicon glyphicon-calendar'></span></span>

                        <script type="text/javascript">
                            $(function () {
                                $('#datepicker_mois').datepicker({
                                    format: "dd/mm/yyyy",
                                    language: "fr",
                                    autoclose: true
                                });
                            });
                        </script>
                    </div>
                </div>
            </div>
        </div>


        <div class="form-group">
            <div class="col-md-1">
                    {!! Form::label('bdx', 'N°Bordereau') !!}
                    {!! Form::text('bdx', null, ['placeholder' => 'Numéro de bordereau','class' => 'form-control']) !!}
            </div>
            <div class="col-md-2">
                    {!! Form::label('nbsal', 'Nombre de salariés') !!}
                    {!! Form::text('nbsal', null, ['placeholder' => 'Nombre de salariés','class' => 'form-control']) !!}
            </div>
            <div class="col-md-1">
                    {!! Form::label('bdx_prive', 'N°Bord.privé') !!}
                    {!! Form::text('bdx_prive', null, ['placeholder' => 'Numéro de bordereau privé','class' => 'form-control']) !!}
            </div>
        </div>


        <div class="form-group">
            <div class="col-md-2">
                    {!! Form::label('compte', 'Compte') !!}
                    {!! Form::text('compte', null, ['placeholder' => 'Compte','class' => 'form-control']) !!}
            </div>
            <div class="col-md-2">
                    {!! Form::label('typepmt', 'Type de paiement') !!}
                    {!! 
                    Form::select(
                        'typepmt',
                        [
                            'A'=>'Autre'
                            ,'B' => 'Banque'
                            ,'E' => 'Espèce'
                            ,'T' => 'Trésor'
                            ,'V' => 'Virement'
                            ,'P' => 'Prélèvement automatique'
                            ,'€' => 'Euro'
                            ,'N' => 'Nul'
                            ],
                        '',
                        [
                            'class' => 'selectpicker'
                            ,'data-width' => "100%"
                        ]
                    ) 
                        
                    !!}
           </div>
        </div>


        <div class='form-group'>
            <div class="col-md-4">
            {!! Form::label('obs', 'Observations') !!}
            {!! Form::textarea('obs', null, ['placeholder' => 'Observations', 'class' => 'form-control', 'rows'=>'3']) !!}
            </div>
        </div>



    <div class='form-group'>
        <div class='col-md-4'>
            <fieldset >
                <legend class="h4">Cotisation</legend>

                <div class="form-group bg-danger" style="padding:5px">
                    <div class="col-md-2">
                        {!! Form::label('assiette', 'Assiette') !!}
                    </div>
                    <div class="col-md-5" >
                        {!! Form::text('assiette', null, ['placeholder' => 'Assiette'
                            , 'class' => 'form-control','style'=>'text-align:right']) !!} 
                    </div>
                    <div class="col-md-3">
                        {!! Form::text('PrcTot', null, ['class' => 'form-control'
                            ,'disabled'=>'true','style'=>'text-align:center']) !!} 
                    </div>
                    <br/><br/>
                    <div class="col-md-2">
                        {!! Form::label('clr', 'CLR') !!}
                    </div>
                    <div class="col-md-5">
                        {!! Form::text('clr', null, ['placeholder' => 'CLR'
                            ,'disabled'=>'true', 'class' => 'form-control','style'=>'text-align:right']) !!} 
                    </div>
                    <div class="col-md-3">
                        {!! Form::text('PrcCLR', null, ['class' => 'form-control','id'=>'PrcCLR'
                            ,'disabled'=>'true','style'=>'text-align:center']) !!} 
                    </div>
                    <br/><br/>
                    <div class="col-md-2">
                        {!! Form::label('ccpf', 'CCPF') !!}
                    </div>
                    <div class="col-md-5">
                        {!! Form::text('ccpf', null, ['placeholder' => 'CLR'
                            ,'disabled'=>'true', 'class' => 'form-control','style'=>'text-align:right']) !!} 
                    </div>
                    <div class="col-md-3">
                        {!! Form::text('PrcCCPF', null, ['class' => 'form-control'
                            ,'disabled'=>'true','style'=>'text-align:center']) !!} 
                    </div>
                </div>


               <div class="form-group bg-info" style="padding:5px">
                    <div class="col-md-2">
                        {!! Form::label('debit', 'Total') !!}
                    </div>
                    <div class="col-md-5" >
                        {!! Form::text('debit', null, ['class' => 'form-control'
                            ,'style'=>'text-align:right','disabled'=>'true']) !!} 
                    </div>
                    <br/><br/>
                    <div class="col-md-2">
                        {!! Form::label('credit', 'Règlement') !!}
                    </div>
                    <div class="col-md-5" >
                        {!! Form::text('credit', null, ['class' => 'form-control','style'=>'text-align:right']) !!} 
                    </div>
                </div>
            </fieldset>
        </div>
    </div>

    <div class='form-group'>
        {!! Form::submit('Enregistrer', ['class' => 'btn btn-primary']) !!}

    </div>
 
    {!! Form::close() !!}
 
</div>


<?php
$ar = array('apple'=>'AA', 'orange', 1, false, null, true, 3 + 5);
?>

 <script>
function set_Taux() {
    var ar = <?php echo json_encode($ar) ?>;
alert( ar );

return;
    var l_taux_CLR="2016;10;2013;14";
    var l_taux_CCPF="2016;13;2013;24";
    var t_CLR=l_taux_CLR.split(";");
    var t_CCPF=l_taux_CCPF.split(";");
    alert(t_CLR[0]);

    $("#PrcCLR").val("666%");
    $("#PrcCCPF").val("666%");
    alert('teto');
}
set_Taux();
 </script>
@stop