@include('forms.fbncheader')
@include('forms.fdatatables')

<div class="col-lg-max col-lg-offset-1">
    <h1><i class="fa fa-employeurs"></i>Règlements</h1>

    <div class='form-group ' style="padding-bottom:20px">
        <div class="col-xs-4">
            {!! Form::select('employeur_id',["0"=>""]+$liste_employeur,$employeur_id,
                [
                    'id' => 'employeur_id2','class' => 'form-control selectpicker',
                    'data-width' => "100%",'style' => 'font-weight:bold;'
                ]
            ) 
            !!}
            <script>
                $(document).ready(function() {
                    $('#employeur_id2').on('change', function() {
                        location.href="{!! url('/recouvrement/reglement_annee/') !!}/"
                            +$('#employeur_id2').val()+"/"+$('#exercice_id').val();
                    });
                });
            </script>
        </div>

        <div class="col-md-1">
            {!! Form::select('exercice',$exercices,$exercice,
                [
                    'id' => 'exercice_id','class' => 'form-control selectpicker',
                    'data-width' => "100%",'style' => 'font-weight:bold;'
                ]
            ) 
            !!}
            <script>
                $(document).ready(function() {
                    $('#exercice_id').on('change', function() {
                        location.href="{!! url('/recouvrement/reglement_annee/') !!}/"
                            +$('#employeur_id2').val()+"/"+$('#exercice_id').val();
                    });
                });
            </script>
        </div>
    </div>

 

@if($employeur_id)

        <div class="table-responsive">
            <table id="_table" class="table table-condensed table-striped table-bordered">
                <thead>
                    <tr>
                        <th width='1%'>N°</th>
                        <!-- <th width='1%'>Exercice</th> -->
                        <th width='1%'>Date</th>
                        <!--
                        <th width='1%'>CLR</th> 
                        <th width='1%'>CCPF</th>
                        <th width='10%'>Débit</th>
                    -->
                        <th width='10%'>Réf.Cotisations</th>
                        <th width='10%'>Crédit</th>
                        <th width='10%'>Mois</th>
                        <th width='1%'>Nb&nbsp;Mois</th>
                        <th width='1%'>Bord.&nbsp;Pub</th>
                        <th width='1%'>Bord.&nbsp;Pri</th>
                        <th width='10%'>Date&nbsp;encais.</th>
                        <th width='30%'>&nbsp</th>
                    </tr>
                </thead>
     
                <tbody>
                @foreach ($reglements as $reglement)
                <tr>
                    <td style="color:grey">{!! $reglement->id !!}</td>
                    <!-- <td align="center">{!! $reglement->exercice !!}</td> -->
                    <td align="center">{!! $reglement->date !!}</td>
                    <!--
                    <td align="right">{!! $reglement->clr !!}</td>
                    <td align="right">{!! $reglement->ccpf !!}</td>
                    <td align="right">{!! $reglement->debit !!}</td>
                -->
                    <td align="right">{!! $reglement->cotisations !!}</td>
                    <td align="right">{!! $reglement->credit !!}</td>
                    <td>{!! $reglement->mois !!}</td>
                    <td align="center">{!! $reglement->nbmois !!}</td>
                    <td align="right">{!! $reglement->bdx !!}</td>
                    <td align="right">{!! $reglement->bdx_prive !!}</td>
                    <td>{!! $reglement->encais_date !!}</td>
                    <td nowrap>
                        @if($user->can("COT_VISU") || $user->HasRole("ADMINISTRATEUR"))
                            <a href="{!! url('recouvrement/reglements/'.$reglement->id ) !!}"
                                 class="btn btn-warning pull-left" style="margin-right: 3px;">Consulter</a>
                        @endif 
                        @if($user->can("COT_MAJ") || $user->HasRole("ADMINISTRATEUR"))
                            <a href="{!! url('recouvrement/reglements/'.$reglement->id .'/edit') !!}"
                                 class="btn btn-info pull-left" style="margin-right: 3px;">Modifier</a>
                        @endif 
                        @if($user->can("COT_SUP") || $user->HasRole("ADMINISTRATEUR"))   
                            {!! Form::open(['url' => 'recouvrement/reglements/' . $reglement->id, 'method' => 'DELETE']) !!}
                            {!! Form::submit('Supprimer', ['class' => 'btn btn-danger'])!!}
                            {!! Form::close() !!}
                        @endif
                    </td>
                </tr>
                @endforeach
                </tbody>
     
            </table>
        </div>

        @if($user->can("COT_AJO") || $user->HasRole("ADMINISTRATEUR"))
             <div>
                <h4><a href="{!! url('recouvrement/reglements/create/'.$employeur_id) !!}" 
                    class="btn btn-success">Ajouter un règlement</a></h4>
            </div> 
        @endif

@endif
</div>

</body></html>


<script>
$(document).ready(function() {
    $('#_table').dataTable( {
        "bAutoWidth": false,
        "bPaginate": false,
        "bInfo": true,
        "bFilter": true,
        "oLanguage": {
            "sZeroRecords": "Aucune ligne",
            "sInfo": "Affichage de _START_ &agrave; _END_ sur _TOTAL_ lignes",
            "sInfoEmpty": "Showing 0 to 0 of 0 records",
            "sInfoFiltered": "(sur un total de _MAX_ lignes)",
             "sSearch":"Chercher",
            },

        "order": [[ 1, "desc" ]]

        } );
 } );
</script>
