
<div class="row form-group">
    <div class="col-md-4">
            {!! html()->label( 'Bénéficiaire','benum') !!}
            <div class="input-group mb-5 ">
                <div class="input-group-prepend " >
                    <span class="input-group-text bg-info" id="ref_beneficiaire">{!! $beneficiaire->id !!}</span>
                </div>
                {!! html()->text('benom', $beneficiaire->NomComplet)->attributes(['disabled', 'class' => 'text-left form-control']) !!}
            </div>
    </div>
    <div class="col-md-8">
            {!! html()->label( 'Employeur','sonum') !!}
            <div class="input-group mb-5 ">
                <div class="input-group-prepend " >
                    <span class="input-group-text bg-info" name="ref_employeur" id='ref_employeur'>{!! $employeur->id !!}</span>
                </div>
                {!! html()->text('employeur_nom', $employeur->nom)->attributes([($mode=="show"?'disabled':''),'name'=>"employeur_nom",'id'=>"employeur_nom",'class' => 'form-control']) !!}
            </div>
    </div>
</div>

<div class="row form-group">
    <div class="col-md-1">
            {!! html()->label( 'Année','annee') !!}
            {!! html()->text('annee', null)->attributes(['class' => 'form-control',($mode=="show"?'disabled':'')]) !!}
    </div>

    <div class="col-md-3">
        {!! html()->label( 'Date d\'entrée','dat_ent') !!}
        <div class="input-group">
            <div class='input-group date' id='datepicker_dat_ent'>
                {!! html()->text('dat_ent', null)->placeholder('Date d\'entrée')->attributes([($mode=="show"?'disabled':''),'class' => 'form-control']) !!}
                <span class='input-group-addon'><span class='glyphicon glyphicon-calendar'></span></span>
            </div>
        </div>
    </div>

    <div class="col-md-3">
        {!! html()->label( 'Date de sortie','date_sor') !!}
        <div class="input-group">
            <div class='input-group date' id='datepicker_date_sor'>
                {!! html()->text('date_sor', null)->placeholder('Date de sortie')->attributes([($mode=="show"?'disabled':''),'class' => 'form-control']) !!}
                <span class='input-group-addon'><span class='glyphicon glyphicon-calendar'></span></span>
            </div>
        </div>
    </div>
</div>


<hr/>
<div class="form-group">
    @if($mode=="edit")
        <button type="button" id="btn_ventiler" class="btn bt-sm btn-success">Ventiler un salaire</button>
        <input type='hidden' id='ventil_active' value="0" />
    @endif
    @if($mode=="show")
        <a href="{!! url('log_salaires/'.$salaire->id) !!} "
            class="btn bt-sm btn-warning box_log fancybox.iframe">Historique
        </a>
    @endif
    @if($mode!="show")
        {!! html()->button('Enregistrer')->value('Enregistrer')->type('submit')->attributes(['class' => 'btn btn-primary']) !!}
    @else
        @if($user->hasRole("ADMINISTRATEUR") || $user->can("SAL_MAJ"))
            <a class="btn btn-primary" href="{{ url('salaires/'.$salaire->id.'/edit') }}" id="btn_modifier">Modifier</a>
        @endif
    @endif
</div>


    <div class="col-md-12">
        <table class="table table-condensed table-striped table-bordered">
            <thead>
                <tr>
                    <th ></th>
                    <?php $tmois=App\Models\MyApp::MOIS_COURT_LONG; ?>
                    @foreach($tmois as $mois=>$libelle)
                        <td width='8%' >
                            {!! html()->label( $libelle,$mois) !!}
                        </td>
                    @endforeach
                </tr>
            </thead>
            <tbody>
                @if($mode=="edit")
                <tr>
                    <th>{{ ($mode!="show")?'Montant Origine':'Montant' }}</th>
                    @foreach($tmois as $mois=>$libelle)
                        <td style='vertical-align:middle;padding:3px'>
                            {!! html()->text('origine', isset($salaire)?$salaire->{$mois}:null)
                                ->attributes(['class' => 'form-control', 'style'=>'text-align:right;padding:2px','disabled']) !!}
                        </td>
                    @endforeach
                </tr>
                @endif
                
                    <tr>
                        <th>Montant</th>
                        @foreach($tmois as $mois=>$libelle)
                            <td style='vertical-align:middle;padding:3px'>
                                {!! html()->text($mois, null)
                                    ->attributes([($mode=="show"?'disabled':''),'class' => 'form-control', 'style'=>'text-align:right;padding:2px']) !!}
                            </td>
                        @endforeach
                    </tr>
                    <tr>
                        <th>Suspendu</th>
                        @foreach($tmois as $mois=>$libelle)
                            <td align='center'>
                                {!! html()->checkbox('box_'.$mois, (isset($salaire)&&($salaire->getSuspendu($mois))?1:0),1)
                                    ->attributes([($mode=="show"?'disabled':''),'id'=>'box_'.$mois]); !!}
                            </td>
                        @endforeach
                    </tr>
                
            </tbody>
        </table>
    </div>

@if($mode=="edit")
    <div class="col-md-12" id='div_ventil' style='visibility:hidden'>
        <div class="form-group">
            <div class="col-md-2">
                    {!! html()->label( 'Montant à ventiler','total_vent') !!}
                    {!! html()->text('total_vent', null)->placeholder('Total à ventiler')->attributes(['id'=>'total_vent',
                                'class' => 'form-control',
                                'onchange'=>'set_vent()']) !!}

                    {!! html()->text('total_a_vent', null)->attributes(['id'=>'total_a_vent',
                                'class' => 'form-control',
                                'readonly', 'style'=>'color:grey;font-style:italic;']) !!}
            </div>
        </div>
        <table class="table table-striped table-condensed table-bordered">
            <theader>
                <tr>
                    <th ></th>
                    @foreach($tmois as $mois=>$libelle)
                        <td width='8%' >{!! html()->label( substr($libelle.".",0,4),$mois) !!}</td>
                    @endforeach
                </tr>
            </theader>
            <tbody>
                <tr>
                    <th nowrap>Ventilation<small style='font-weight:normal'><br>Ajouté au salaire</small></th>
                    @foreach($tmois as $mois=>$libelle)
                        <td  style='vertical-align:middle;padding:3px'>

                        <input class='ventil checkbox' type='checkbox'
                            value='0'
                            id='{!! $mois !!}_check'
                            onchange='set_vent()'
                            style='visibility:hidden'/>

                            {!! html()->text($mois.'_vent', null)
                                ->attributes(['id'=>$mois.'_vent','class' => 'form-control input_vent_mois', 'style'=>'text-align:right;padding:2px'])
                            !!}
                        </td>

                    @endforeach
                </tr>
            </tbody>
        </table>
    </div>
@endif
@if($mode=="show")
    {{ html()->form('DELETE', url('/salaires/'. $salaire->id))->open() }}
    &nbsp;{!! html()->button('Supprimer')->value('Supprimer')->type('submit')
    ->attributes(['onclick'=>'if(!confirm("Voulez-vous vraiment supprimer ce Salaire ?")) return false;','class' => 'btn btn-danger']) !!}
    {{ html()->form()->close() }}
@endif