@extends('layouts.dash')
@section('title') Salaire @stop
@section('title_card')  @stop
@section('subtitle_card',"Employeur")


@section('content')
<div class="card">
        @if ($errors)
            @foreach ($errors->all() as $error)
                <div class='bg-danger alert'>{!! $error !!}</div>
            @endforeach
        @endif
        <div class="card-header">
            <h2>Nouvelle fiche salaire</h2>
        </div>
        <div class="card-body">
        {{ html()->form('POST', url('salaires'))->open() }}
            <input type="hidden" name="sonum" value="{!! $employeur->id !!}">
            <input type="hidden" name="benum" value="{!! $beneficiaire->id !!}">
            @include("recouvrement.salaires.content")
        {{ html()->form()->close() }}
        </div>
</div>
@stop

@section('styles')
    <!-- FancyBox -->
    <link media="all" type="text/css" rel="stylesheet" href="{{ url('css/jquery.fancybox.css') }}">
    <link media="all" type="text/css" rel="stylesheet" href="{{ url('css/jquery.fancybox-buttons.css') }}">
@stop



@section('scripts0')
    <script src="{{ url('js/jquery.fancybox.js') }}"></script>

    <script type="text/javascript">
        $(function() {
            $("#employeur_nom").autocomplete({
                source: "{!! route('autocomplete_employeur') !!}",
                minLength: 2,
                select: function(event, ui) {
                    $('#sonum').val(ui.item.id);
                    $('#ref_employeur').html(ui.item.id);
                },
                change: function( event, ui ) {
                    var id_nom=ui.item.value.trim();
                    var nom;
                    var t= id_nom.split(/ (.*)/s);;

                    //if(id_nom.length>5) nom=(id_nom.substring(4)).trim();
                    $('#employeur_nom').val(t[1]);
                    $('#ref_employeur').html(ui.item.id);
                    $('#sonum').val(ui.item.id);
                }
            });
            return;
        });
    </script>
@stop


@section('scripts')
    @include("recouvrement.salaires.scripts_salaires")
@stop
