@extends('layouts.dash')
@section('title') Salaires @stop
@section('title_card',"Emplois/Salaires")
@section('subtitle_card',"Liste")

@section('content')
    @if (Session::has('message'))
        <div class="alert alert-warning">{!! Session::get('message') !!}</div>
    @endif

    @if ($errors)
        @foreach ($errors->all() as $error)
            <div class='bg-danger alert'>{!! $error !!}</div>
        @endforeach
    @endif

    @if (Session::has('success'))
        <div class="alert alert-success">{!! \Session::get('success') !!}</div>
    @endif


    <div class="card">
        <div class="card-header">
            <h3 style="margin-top:0px;">Salaires<small>{!! substr($employeur_nom,strpos($employeur_nom,' ')) !!}</small><h3>
        </div>
        
            <div class="card-body">
                <div class='row form-group '>
                    <div class="col-md-4">
                        {!! html()->hidden('employeur_id2', $employeur_id)->attributes(['id'  => 'employeur_id2']) !!}
                        {!! html()->label('Employeur :','employeur_nom' ) !!}
                        {!! html()->text('employeur_nom', $employeur_nom)->placeholder('Employeur')->attributes(['class' => 'form-control', 'id' => 'employeur_nom']) !!}

                    </div>

                    <div class="col-md-2">
                        {!! html()->label('Année :','annes' ) !!}
                        {!! html()->select('exercice')->options($exercices)
                            ->value($exercice)
                            ->placeholder('Choisir une Année')
                            ->attributes(['id' => 'exercice_id','class' => 'form-control selectpicker','data-width' => "100%",'style' => 'font-weight:bold;'])  !!}
                    </div>

                    @if($employeur_id!="")
                        <div class="col-md-6">
                            {!! html()->label('Employé :','employe_nom' ) !!}
                            {!! html()->select('beneficiaire_id')->options($liste_employes,$beneficiaire_id)
                                ->placeholder('Choisir un employé')
                                ->attributes(['id' => 'beneficiaire_id2','class' => 'form-control selectpicker','data-width' => "100%",'style' => 'font-weight:bold;'])  !!}
                        </div>
                    @endif
                </div>

                <div class='row form-group '>
                    <a title="Historique des modifications"  href="{!! url('log_salaires/'.$exercice.'/'.$employeur_id) !!} "
                    class="btn btn-info box_log fancybox.iframe">Journal des modifications</a>
                    @if($beneficiaire_id>0)
                        &nbsp;<a href="{!! url('/attestation_edition/'.$beneficiaire_id.'/E/att_revenu') !!}"
                            class="btn btn-warning" target="_blank">Attestation de déclaration</a>

                        @if($user->can("SAL_EDIT") || $user->HasRole("ADMINISTRATEUR"))
                            &nbsp;<a href="{!! url('salaire_liquidation/'.$beneficiaire_id) !!}"
                                class="btn btn-warning" target="_blank">Edition des liquidations</a>
                            <!--
                            <a href="{!! url('/salaire/liquidation_simulation/'.$beneficiaire_id) !!}"
                                class="btn btn-warning" target="_blank">Edition d'une Simulation de liquidation</a>
                            -->
                        @endif

                        @if($user->can("SAL_AJO") || $user->HasRole("ADMINISTRATEUR"))
                            &nbsp;<a href="{!! url('salaires/create/'.$beneficiaire_id.'/'.$employeur_id) !!}"
                                title="Ajouter un salaire" class="btn btn-success">
                                    Ajouter un Salaire pour {{ $beneficiaire->NomComplet }}
                            </a>
                        @endif
                    @endif
                </div>
                @if($employeur_id)
                <div class="table-responsive">
                    <table id="_table" style="" class="table table-condensed table-striped table-bordered">
                        <thead>
                            <tr>
                                <th width='1px'>N°</th>
                                <th >Employé</th>
                                <th width='1px'>DateNais.</th>
                                <th width='1px'>Année</th>
                                <th width='1px'>DateEnt.</th>
                                <th width='1px'>DateSor</th>
                                @if($employeur_nom=="TOUS")
                                    <th >N°Emp.</th>
                                    <th >Employeur</th>
                                @endif

                                @foreach($t_mois as $mois)
                                <th class="sum" width='1px'>{!! $mois !!}</th>
                                @endforeach
                                <th width='1px'>Total</th>
                                <th width='1px'>Der.Modif.</th>
                            </tr>
                        </thead>

                        <tfoot>
                            <tr class='' style='background-color:#E6E6FA;font-weight:bold'>
                                <th colspan="{!! ($employeur_nom=='TOUS')?'8':'6' !!}">TOTAL</th>
                                <th class="sum"></th>
                                <th class="sum"></th>
                                <th class="sum"></th>
                                <th class="sum"></th>
                                <th class="sum"></th>
                                <th class="sum"></th>
                                <th class="sum"></th>
                                <th class="sum"></th>
                                <th class="sum"></th>
                                <th class="sum"></th>
                                <th class="sum"></th>
                                <th class="sum"></th>
                                <th class="sum"></th>
                                <th class="sum"></th>
                            </tr>
                        </tfoot>
                        <tfoot>
                            <tr class='' style='background-color:#F0FFF0;font-weight:bold'>
                                <td colspan="{!! ($employeur_nom=='TOUS')?'8':'6' !!}"></td>
                                @foreach($nb_salaire as $mois=>$nb)
                                    <td align="center" style="{!! ($mois=='total')?'font-weight:bold':'' !!}">{!! $nb !!}</td>
                                @endforeach
                                <td class=""></td>
                            </tr>
                        </tfoot>
                        <tbody>
                            @foreach ($salaires as $salaire)
                                @php
                                    $color_histo="default";$lib_update="Modifié il y a plus de 3 mois";
                                    $diff=App\Models\MyApp::getNbjDate($salaire->updated_at,date('Y-m-d'));
                                    if($diff<90) {$color_histo="info";$lib_update='Modifié dans les 3 mois';}
                                    if($diff<60) {$color_histo="warning";$lib_update='Modifié dans les 2 mois';}
                                    if($diff<30) {$color_histo="danger";$lib_update='Modifié dans le mois';}
                                @endphp
                                <tr>
                                    <td>
                                        @if($user->can("SAL_MAJ") || $user->HasRole("ADMINISTRATEUR"))
                                            <a href="{!! url('salaires/'.$salaire->id ) !!}" class="btn btn-info">
                                                {!! $salaire->benum !!}
                                            </a>
                                        @else
                                            {!! $salaire->benum !!}
                                        @endif
                                    </td>
                                    <td>
                                        <a href="{!! url('beneficiaires_filtre/'.$salaire->benum.'/V') !!}" target='_blank'>
                                            {!! $salaire->beneficiaire_Nom !!}
                                        </a>
                                    </td>
                                    <td nowrap>{!! $salaire->BeneficiaireDateNaissance !!}</td>
                                    <td nowrap align='center'>{!! $salaire->annee !!}</td>
                                    <td nowrap>{!! $salaire->dat_ent !!}</td>
                                    <td nowrap>{!! $salaire->date_sor !!}</td>
                                    @if($employeur_nom=="TOUS")
                                        <td nowrap>{!! str_pad($salaire->sonum, 6, "0", STR_PAD_LEFT) !!}</td>
                                        <td>{!! $salaire->employeur_nom !!}</td>
                                    @endif

                                    @foreach($t_mois as $mois)
                                        @php
                                            $horsplafond=$salaire->getIsHorsPlafond($mois);
                                            $montant_salaire=$salaire->{$mois};
                                            $style="";
                                            if($horsplafond) $style.="color:red;";
                                            if($salaire->getSuspendu($mois)) {
                                                $style.="background-color:darkgrey;font-size:.9em";
                                                $montant_salaire="SUSPENDU";
                                            }
                                        @endphp
                                        <td nowrap align='right' style='{!! $style !!}'>
                                            {!! $montant_salaire !!}
                                        </td>
                                    @endforeach
                                    <td nowrap align='right'>{!! $salaire->TotalAnnee !!}</td>
                                    <td nowrap align='right'>
                                        <a title="{!! $lib_update !!}" href="{!! url('log_salaires/'.$salaire->id) !!} "
                                            class="btn bt-sm btn-{!! $color_histo !!} box_log fancybox.iframe">
                                        {!! $salaire->updated_at !!}</a>
                                    </td>

                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
                @endif
            </div>
        
    </div>
@endsection

@section('styles')
    <!-- FancyBox -->
    <link media="all" type="text/css" rel="stylesheet" href="{{ url('css/jquery.fancybox.css') }}">
    <link media="all" type="text/css" rel="stylesheet" href="{{ url('css/jquery.fancybox-buttons.css') }}">
@stop

@section('scripts')
    <script src="{{ url('js/jquery.fancybox.js') }}"></script>
    <!-- source: "../autocomplete_employeur", -->
    <script>
        $(document).ready(function() {
            $("#employeur_nom").autocomplete({
                source: "{!! route('autocomplete_employeur') !!}",
                minLength: 1,
                select: function(event, ui) {
                    var uid_=ui.item.id;
                    var value_=ui.item.value
                    if(value_=='TOUS') uid_="999999";
                    $('#employeur_nom').val(uid_+" "+(value_.trim()));
                    $('#employeur_id2').val(uid_);
                    location.href="{!! url('/salaire_annee/') !!}/"+$('#employeur_id2').val()+"/0"+"/0";
                },
                close: function(event, ui) {

                }
            });

            $('#exercice_id').on('change', function() {
                var id_benef=$('#beneficiaire_id2').val();
                if(id_benef=="") id_benef=0;
                location.href="{!! url('/salaire_annee/') !!}/"
                    +$('#employeur_id2').val()+"/"+id_benef+"/"+$('#exercice_id').val();
            });

            $('#beneficiaire_id2').on('change', function() {
                var id_benef=$('#beneficiaire_id2').val();
                if(id_benef=="") id_benef=0;
                location.href="{!! url('/salaire_annee/') !!}/"
                    +$('#employeur_id2').val()+"/"+id_benef+"/"+$('#exercice_id').val();;
            });
        });

        $(document).ready(function() {
            $(".box_log").fancybox({
                width:'80%',
                autoDimensions:false,
                fitToView   : false,
                autoSize    : false,
                closeClick  : true,
                openEffect  : 'fade',
                closeEffect : 'fade',
                afterLoad: function () {

                },
                afterClose: function () {
                    return;
                }
            })
            /*
            $(".box_liquidation").fancybox({
                //width:'80%',
                autoDimensions:true,
                fitToView   : false,
                autoSize    : true,
                closeClick  : true,
                openEffect  : 'fade',
                closeEffect : 'fade',
                afterLoad: function () {

                },
                afterClose: function () {
                    return;
                }
            })
            */
            $.fn.dataTable.moment('D/M/YYYY');

            var table =$('#_table').dataTable( {
                bAutoWidth: false,
                bPaginate: false,
                bInfo: true,
                bFilter: true,
                        scrollY:        400,
                        scrollX:        '100%',
                        scrollCollapse: true,
                        scroller:       true,

                oLanguage: {
                    "sZeroRecords": "Aucune ligne",
                    "sInfo": "Affichage de _START_ &agrave; _END_ sur _TOTAL_ lignes",
                    "sInfoEmpty": "Showing 0 to 0 of 0 records",
                    "sInfoFiltered": "(sur un total de _MAX_ lignes)",
                    "oPaginate": {"sPrevious": "Pr&eacute;c&eacute;dente","sNext": "Suivante"
                        ,"sFirst": "Premi&egrave;re","sLast": "Derni&egrave;re"},
                        "sSearch":"Chercher ",
                    buttons: {
                        colvis: 'Colonnes à afficher',
                        copy: 'Copier',print: 'Imprimer',
                        copyTitle: 'Ajouté au presse-papiers',
                        copyKeys: 'Appuyez sur <i>ctrl</i> ou <i>\u2318</i> + <i>C</i> pour copier les données du tableau à votre presse-papiers. <br><br>Pour annuler, cliquez sur ce message ou appuyez sur Echap.',
                        copySuccess: {
                            _: '%d lignes copiées',
                            1: '1 ligne copiée'
                            }
                        }

                    },

                    //"dom": '<"top"fBl>rt<"bottom"ip><"clear">',
                    dom: "<'row'<'col-sm-3 text-left'><'col-sm-4'><'col-sm-5 text-center'f>>" +
                    "<'row'<'col-sm-12'tr>>" +"<'row'<'col-sm-5'i><'col-sm-7'B>>",

                    "aaSorting": [
                        [1,'asc']
                    ],

                    buttons: [
                        {extend: 'copy',exportOptions: {columns: ':visible'} },
                        {extend: 'excel',exportOptions: {columns: ':visible'} },
                        'colvis'
                    ],


                    "footerCallback": function(row, data, start, end, display) {
                    var api = this.api();
                        @if($employeur_nom=="TOUS")
                            api.columns([8,9,10,11,12,13,14,15,16,17,18,19,20], { //
                        @else
                            api.columns([6,7,8,9,10,11,12,13,14,15,16,17,18], { //
                        @endif
                        page: 'current'
                    }).every(function() {
                        var sum = this
                        .data()
                        .reduce(function(a, b) {
                            var x = parseFloat(a) || 0;
                            var y = parseFloat(b) || 0;
                            return x + y;
                        }, 0);
                        $(this.footer()).html(sum);
                    });
                    },



                } );

                $('#_table').DataTable().draw();

                $(window).resize(function () {
                            $('#_table').DataTable().draw();
                });
        } );
    </script>
@endsection

