@include('forms.fbncheader_nomenu')
@include('forms.fdatatables')

<div class="col-lg-max col-lg-offset-1">
    <h2><i class="fa fa-employeurs"></i><small>Salaires de </small>{!! $beneficiaire->nom_complet !!}</h2>
    <h2><i class="fa fa-employeurs"></i><small>Employeur </small>{!! $employeur->nom !!}</h2>
    <br/>
    <div class="table-responsive">
        <table id="_table" class="table table-condensed table-striped table-bordered">
            <thead>
                <tr>
                    <th width='1%'>N°</th>
                    <!-- <th width='10%'>Employeur</th> -->
                    <th width='1%'>Année</th>
                    <th width='5%'>Jan</th>
                    <th width='5%'>Fév</th>
                    <th width='5%'>Mar</th>
                    <th width='5%'>Avr</th>
                    <th width='5%'>Mai</th>
                    <th width='5%'>Jui</th>
                    <th width='5%'>Jui</th>
                    <th width='5%'>Aou</th>
                    <th width='5%'>Sep</th>
                    <th width='5%'>Oct</th>
                    <th width='5%'>Nov</th>
                    <th width='5%'>Déc</th>
                </tr>
            </thead>
 
            <tbody>
                @foreach ($salaires as $salaire)
                <tr>
                    <td>{!! $salaire->benum !!}</td>
                    <!-- <td nowrap>{!! $salaire->employeur_nom !!}</td> -->
                    <td nowrap>{!! $salaire->annee !!}</td>
                    <td nowrap align='right'>{!! $salaire->jan !!}</td>
                    <td nowrap align='right'>{!! $salaire->fev !!}</td>
                    <td nowrap align='right'>{!! $salaire->mar !!}</td>
                    <td nowrap align='right'>{!! $salaire->avr !!}</td>
                    <td nowrap align='right'>{!! $salaire->mai !!}</td>
                    <td nowrap align='right'>{!! $salaire->jun !!}</td>
                    <td nowrap align='right'>{!! $salaire->jui !!}</td>
                    <td nowrap align='right'>{!! $salaire->aou !!}</td>
                    <td nowrap align='right'>{!! $salaire->sep !!}</td>
                    <td nowrap align='right'>{!! $salaire->oct !!}</td>
                    <td nowrap align='right'>{!! $salaire->nov !!}</td>
                    <td nowrap align='right'>{!! $salaire->dec !!}</td>
                </tr>
                @endforeach
            </tbody>
 
        </table>
    </div>

@if($user->can("SAL_AJO") || $user->HasRole("ADMINISTRATEUR"))
     <div>
        <h4><a href="{!! url('recouvrement/salaire_annee/'.$employeur->id.'/'.$beneficiaire->id) !!}" 
            class="btn btn-success"
            target="_blank">Gestion des Salaires</a></h4>
    </div> 
@endif

</div>

</body></html>


<script>

    $('#_table').dataTable( {
        "bAutoWidth": false,
        "bPaginate": false,
        "bInfo": true,
        "bFilter": true,
        "oLanguage": {
            "sZeroRecords": "Aucune ligne",
            "sInfo": "Affichage de _START_ &agrave; _END_ sur _TOTAL_ lignes",
            "sInfoEmpty": "Showing 0 to 0 of 0 records",
            "sInfoFiltered": "(sur un total de _MAX_ lignes)",
             "sSearch":"Chercher",
            },

        "order": [[ 1, "desc" ]]

        } );
 } );
</script>