@extends('layouts.dash')
@section('title') Bordereaux @stop
@section('title_card',"")
@section('subtitle_card',"")

@section('content')
    @if (Session::has('message'))
        <div class="alert alert-warning">{!! Session::get('message') !!}</div>
    @endif
    @if ($errors)
        @foreach ($errors->all() as $error)
            <div class='bg-danger alert'>{!! $error !!}</div>
        @endforeach
    @endif
    @if (Session::has('success'))
        <div class="alert alert-success">{!! \Session::get('success') !!}</div>
    @endif

    <div class="card">
        <div class="card-header bg-info">
            <h3>
                Etats des Bordereaux de cotisation
                <small>
                {!! ($bdx_prive_id!="")?"Privé N°".$bdx_prive_id." - ".$exercice:"" !!}
                {!! ($bdx_id!="")?"Public N°".$bdx_id." - ".$exercice:"" !!}
                </small>
            </h3>
        </div>
        <div class="card-body">
            <div class="row">
                <div class="col-md-2">
                    {!! html()->label( 'Bdx Publics','select_bdx') !!}
                    {!! html()->select('select_bdx',$lst_bdx_publics,$bdx_id)
                        ->placeholder('A définir')
                        ->attributes(['id' => 'select_bdx','class' => 'form-control selectpicker','data-width' => "100%"])  !!}
                </div>
                <div class="col-md-2">
                    {!! html()->label( 'Bdx Privés','select_bdx_prive') !!}
                    {!! html()->select('select_bdx_prive',$lst_bdx_prives,$bdx_prive_id)
                        ->placeholder('A définir')
                        ->attributes(['id' => 'select_bdx_prive','class' => 'form-control selectpicker','data-width' => "100%"])  !!}
                </div>
                <div class="col-md-2">
                    {!! html()->label( 'Exercice','exercice') !!}
                    {!! html()->select('exercices',$exercices,$exercice)
                        ->placeholder('A définir')
                        ->attributes(['id' => 'exercice','class' => 'form-control selectpicker','data-width' => "100%"])  !!}
                </div>
                <div class="col-md-6 " style="text-align:right;padding-top:28px;">
                    @if($user->can("COT_VAL") || $user->HasRole("ADMINISTRATEUR"))
                        @if( (count($cotisations)>0 )  && ( ($bdx_prive_id!="")||($bdx_id!="")) && (($bdx_id!="9999")&&($bdx_prive_id!="9999")))
                            @if( ($typeval=="C") || ($typeval=="") )
                                <a href="{!! url('bordereaux_val/D/'.$bdx_prive_id.$bdx_id.'/'.($bdx_id?'PU':'PR').'/'.$exercice) !!}" 
                                    class="btn btn-warning" >
                                    Valider les débits
                                </a>
                            @endif
                            @if( ($typeval=="D") || ($typeval=="") )
                                <a href="{!! url('bordereaux_val/C/'.$bdx_prive_id.$bdx_id.'/'.($bdx_id?'PU':'PR').'/'.$exercice) !!}" 
                                    class="btn btn-success " >
                                    Valider les crédits
                                </a>
                            @endif
                            @if( ($typeval=="Z") && $user->HasRole("ADMINISTRATEUR") )
                                <a href="{!! url('bordereaux_val/Z/'.$bdx_prive_id.$bdx_id.'/'.($bdx_id?'PU':'PR').'/'.$exercice) !!}" 
                                    class="btn btn-danger " >
                                    Annuler les validations
                                </a>
                            @endif
                        @endif
                    @endif

                    @if((count($cotisations)>0)&&($bdx_id!="9999")&&($bdx_prive_id!="9999"))
                        <a href="{!! url('/bordereaux_etat/'.$bdx_prive_id.$bdx_id.'/'.($bdx_id?'PU':'PR').'/'.$exercice) !!}" 
                            class="btn btn-primary" 
                            target="_blank" style="margin-right: 3px;">
                            Etat récapitulatif
                        </a>
                    @endif
                </div>
            </div>

            <div class="col-lg-max" style="padding-top:25px">
                @if(count($cotisations)>0)
                <div class="table-responsive">
                    <table id="_table"  style="background-color:white"  
                        class="table table-condensed table-striped table-hover table-bordered">
                        <thead>
                            <tr>
                                <th nowrap>Id</th>
                                <th nowrap>N°Emp</th>
                                <th>Employeur</th>
                                <th>NbSalariés</th> 
                                <th>Bdx</th>
                                <th>NbMois</th> 
                                <th>Mois</th>
                                <th>Exercice</th> 
                                <th title='Année de rattachement'>Année<br/>Rattach.</th>  
                                <th>Type<br/>PMT</th> 
                                <th>Type<br/>Ope.</th> 
                                <th>CLR</th> 
                                <th>CCPF</th>
                                <th style="color:{!! ( ($typeval=='D') || ($typeval=='Z') )?'green':''; !!}">Débit</th>
                                <th style="color:{!! ( ($typeval=='C') || ($typeval=='Z') )?'green':''; !!}">Crédit</th>
                            </tr>
                        </thead>

                        <tbody>
                        <?php
                            $total["nbsal"]=0;
                            $total["nbmois"]=0;
                            $total["clr"]=0;
                            $total["ccpf"]=0;
                            $total["debit"]=0;
                            $total["credit"]=0;
                        ?>
                        @foreach ($cotisations as $cotisation)
                            <?php
                                $total["nbsal"]+=$cotisation->nbsal;
                                $total["nbmois"]+=$cotisation->nbmois;
                                $total["clr"]+=$cotisation->clr;
                                $total["ccpf"]+=$cotisation->ccpf;
                                $total["debit"]+=$cotisation->debit;
                                $total["credit"]+=$cotisation->credit;
                            ?>
                            <tr>
                                <td align="center" >
                                    <a class="btn btn-sm bg-info" href="{!! url('cotisations/'.$cotisation->id) !!}" 
                                    style="color:grey;" target="blank">{!! $cotisation->id !!}</a>
                                </td>
                                <td align="center">{!! $cotisation->sonum !!}</td>
                                <td >{!! $cotisation->employeur !!}</td>
                                <td align="center">{!! $cotisation->nbsal !!}</td>
                                <td align="center">{!! 
                                    (($cotisation->bdx==0)?"":str_pad($cotisation->bdx, 2, "0", STR_PAD_LEFT)).
                                    (($cotisation->bdx_prive==0)?"":str_pad($cotisation->bdx_prive, 2, "0", STR_PAD_LEFT))
                                    !!}
                                </td>
                                <td align="center">{!! $cotisation->nbmois !!}</td>
                                <td align="center">{!! $cotisation->MoisLettre !!}</td>
                                <td align="center">{!! $cotisation->exercice !!}</td>
                                <td align="center" 
                                    class="{!! ($cotisation->AnneeRatachement!=$cotisation->exercice)?'danger':'' !!}">
                                    {!! $cotisation->AnneeRatachement !!}</td>
                                <td align="center">{!! $cotisation->typepmt !!}</td>
                                <td align="center">{!! $cotisation->type_ope !!}</td>
                                <td align="right" nowrap>{!! number_format($cotisation->clr,0,","," ") !!}</td>
                                <td align="right" nowrap>{!! number_format($cotisation->ccpf,0,","," ") !!}</td>
                                <td align="right" class="{!! ($cotisation->debit>0)?'text-danger':'' !!}" nowrap style="font-weight:bold">{!! number_format($cotisation->debit,0,","," ") !!}</td>
                                <td align="right" class="{!! ($cotisation->credit>0)?'text-success':'' !!}" nowrap style="font-weight:bold">{!! number_format($cotisation->credit,0,","," ") !!}</td>
                            </tr>
                        @endforeach
                        </tbody>


                        <tfoot>
                            <tr class=''>
                                <th class="sum"></th>
                                <th class="sum"></th>
                                <th class="sum"></th>
                                <th class="sum"></th>
                                <th class="sum" align="center" nowrap>{!! $total["nbsal"] !!}</th>
                                <th class="sum" align="center" nowrap>{!! $total["nbmois"] !!}</th>
                                <th class="sum"></th>
                                <th class="sum"></th>
                                <th class="sum"></th>
                                <th class="sum"></th>
                                <th class="sum"></th>
                                <th class="sum" align="right" nowrap>{!! number_format($total["clr"],0,","," ") !!}</th>
                                <th class="sum" align="right" nowrap>{!! number_format($total["ccpf"],0,","," ") !!}</th>
                                <th class="bg-danger sum" align="right" nowrap>{!! number_format($total["debit"],0,","," ") !!}</th>
                                <th class="bg-success sum" align="right" nowrap>{!! number_format($total["credit"],0,","," ") !!}</th>
                            </tr>
                        </tfoot>
                    </table>
                </div>
                @endif
            </div>
        </div>
    </div>
@endsection


@section('scripts0')
    <script>
        $(document).ready(function() {
            $('#select_bdx').change(function() {
                $('#select_bdx_prive').val("");
                get_bordereaux();
            });

            $('#select_bdx_prive').change(function() {
               $('#select_bdx').val("");
                get_bordereaux(); 
            });

            $('#exercice').change(function() {
                get_bordereaux(); 
            });

            function get_bordereaux() {
                var url="{!! url('bordereaux/') !!}";
                var select_bdx_id = $('#select_bdx').val();
                var select_bdx_prive_id = $('#select_bdx_prive').val();
                var exercice = $('#exercice').val();
                var pupri="";
                var bdx_id="";
                if((select_bdx_id=="")&&(select_bdx_prive_id=="")) {
                    url=url+"/"+exercice;
                    location.href=url;
                    return;
                }

                if(select_bdx_id!="") {pupri="PU";bdx_id=select_bdx_id;}
                if(select_bdx_prive_id!="") {pupri="PR";bdx_id=select_bdx_prive_id;}


                url=url+"/"+exercice+"/"+bdx_id+"/"+pupri;

                location.href=url;
            }
        })
    </script>
@endsection

@section('scripts')
    <script>
    $(document).ready(function() {
       $.fn.dataTable.moment('D/M/YYYY');

        var table =$('#_table').dataTable( {
            bAutoWidth: false,
            bPaginate: false,
            bInfo: true,
            bFilter: true,
            deferRender:    true,
            //scrollY:        400,
            scrollCollapse: false,
            scroller:       false,
            //iDisplayLength:10,
            oLanguage: {
                "sZeroRecords": "Aucune ligne",
                "sInfo": "Affichage de _START_ &agrave; _END_ sur _TOTAL_ lignes",
                "sInfoEmpty": "Showing 0 to 0 of 0 records",
                "sInfoFiltered": "(sur un total de _MAX_ lignes)",
                "oPaginate": {"sPrevious": "Pr&eacute;c&eacute;dente","sNext": "Suivante"
                    ,"sFirst": "Premi&egrave;re","sLast": "Derni&egrave;re"},
                    "sSearch":"Chercher ",
                buttons: {
                    colvis: 'Colonnes à afficher',
                    copy: 'Copier',
                    print: 'Imprimer',
                    copyTitle: 'Ajouté au presse-papiers',
                    copyKeys: 'Appuyez sur <i>ctrl</i> ou <i>\u2318</i> + <i>C</i> pour copier les données du tableau à votre presse-papiers. <br><br>Pour annuler, cliquez sur ce message ou appuyez sur Echap.',
                    copySuccess: {
                        _: '%d lignes copiées',
                        1: '1 ligne copiée'
                    }
                }

            },

            dom: "<'row'<'col-sm-2 text-left'f><'col-sm-4'><'col-sm-6 text-right'B>>" +
            "<'row'<'col-sm-12'tr>>" +
            "<'row'<'col-sm-5'i><'col-sm-7'p>>",

            "aaSorting": [
                [1,'asc']
            ],

            buttons: [ 
                {extend: 'copy',exportOptions: {columns: ':visible'} },
                {extend: 'excel',exportOptions: {columns: ':visible'} },
                //{extend: 'print',exportOptions: {columns: ':visible'} },
                'colvis'
            ],


        });



    } );
    </script>
@endsection
