@extends('layouts.dash_pop')
@section('title') Cotisations @stop
@section('title_card',"")
@section('subtitle_card',"")


@section('content')
    <div class="card">
        <div class="col-lg-max col-lg-offset-1 container-fluid">
            <div class="card-header bg-info">
                Détail des cotisations
            </div>
            <div class="card-body">
                <table id="_table" style="background-color:white"  
                    class="table table-condensed table-striped table-hover table-bordered">
                    <thead>
                        <tr>
                            <th width='1%'>N°</th>
                            <th width='1%'>Exercice</th>
                            <th width='1%'>Date</th>
                            <th width='1%'>Type</th>
                            <th width='1%'>Mois</th>
                            <th width='1%'>Date&nbsp;Encaiss.</th>
                            <th width='1%'>Débit</th>
                            <th width='1%'>Crédit</th>
                        </tr>
                    </thead>
         
                    <tbody>
                        <?php 
                            $total_debit=0;
                            $total_credit=0; 
                        ?>
                        @foreach ($cotisations as $cotisation) 
                            <?php
                            $total_debit+=$cotisation->debit;
                            $total_credit+=$cotisation->credit;
                            ?>
                            <tr>
                                <td>{!! $cotisation->id !!}</td>
                                <td>{!! $cotisation->exercice !!}</td>
                                <td>{!! $cotisation->date !!}</td>
                                <td>{!! $cotisation->type_cotis !!}</td>
                                <td>{!! $cotisation->mois !!}</td>
                                <td>{!! $cotisation->encais_date !!}</td>
                                <td>{!! $cotisation->debit !!}</td>
                                <td>{!! $cotisation->credit !!}</td>
                            </tr>
                        @endforeach
                    </tbody>

                    <tfoot>
                        <tr>
                            <th colspan="6" >TOTAL</th>
                            <th style="color:red">{!! $total_debit !!}</th>
                            <th  style="color:blue">{!! $total_credit !!}</th>
                        </tr>

                        <tr>
                            <th colspan="7" >SOLDE</th>
                            <th style="color:{!! ($total_credit-$total_debit>0)?'blue':'red' !!}">{!! $total_credit-$total_debit  !!}</th>
                        </tr>
                    </tfoot>
                </table>
            </div>
        </div>
    </div>
@endsection



