@extends('layouts.dash_pop')
@section('title') Email appel @stop
@section('title_card',"")
@section('subtitle_card',"")


@section('content')
    <div class="card">
        <div class="col-lg-max col-lg-offset-1 container-fluid">
            <div class="card-header bg-info">
                Envoi d'un email à {!! $employeur->nom !!}
            </div>
            <div class="card-body">
	            {{ html()->form('POST', url('/recouvrement_sendmail/'.$employeur->id))->open() }}
				<div class="col-lg-max col-lg-offset-1">
					<div class='form-group callout callout-danger '>
						<h3>{!! html()->label( 'Période de cotisation','lib_periode') !!}</h3>
						<div class="row">
							<div class="col-md-3">
								{!! html()->label( 'Joindre le bordereau','pj') !!}
								{!! html()->checkbox('pj',true,'')->attributes(['checked']) !!}
							</div>	
						</div>	

						<div class="row">
							<div class="col-md-3">
								{!! html()->label( 'Trimestre','tri_cotis') !!}
		                        {!! html()->select('tri_cotis',["T1"=>"1er trimestre","T2"=>"2e trimestre","T3"=>"3e trimestre","T4"=>"4e trimestre"],"")
		                            ->placeholder('Choisissez un trimestre')
		                            ->attributes(['id' => 'tri_cotis','class' => 'form-control selectpicker','data-width' => "100%"])  !!}	
							 </div>	
							<div class="col-md-5">
								{!! html()->label( 'Désignation','libelle') !!}
								{!! html()->text('libelle_periode',$periode)->placeholder('Libellé de la période')->attributes(['id'=>'libelle_periode', 'class' => 'form-control']) !!}
							</div>
							<div class="col-md-2">
								{!! html()->label( 'Année','annee') !!}
								{!! html()->text('annee',$annee)->placeholder('Année')->attributes(['id'=>'annee', 'class' => 'form-control']) !!}								
							</div>

							<div class="col-md-2 mt-4">
				                <a href="javascript:" onclick="show_bordereau();"  
				                	class="btn btn-warning pull-left" >Aperçu</a>
				                <script>
				                    function show_bordereau() {
				                    	var lib=$('#libelle_periode').val();
				                    	var selected_trim = [...tri_cotis.selectedOptions].map(option => option.value);
				                    	var trim=$('#tri_cotis').val();
				                    	if(lib=="") lib="-";

				                    	var annee=$('#annee').val();
				                    	var url="{!! url('/cotisations_bordereau_cotisation/'.$employeur->id) !!}/"+annee+"/"+trim+"/"+lib;
				                    	window.open(url);
				                        return false;
				                    };
				                </script>
							</div>
						</div>
					</div>
				</div>


				<div class="col-lg-max col-lg-offset-1">
					<div class='form-group callout callout-success '>
						<h3>{!! html()->label( 'Email','lib_email') !!}</h3>

						<div class='form-group'>
							<div class="col-md-6 col-md-offset-1">
								{!! html()->label( 'Destinataire','destinataire') !!}
								{!! html()->text('destinataire',$employeur->email)->placeholder('Email du destinataire')->attributes(['class' => 'form-control']) !!}	
							</div>
						</div>
						<div class='form-group'>
							<div class="col-md-8 col-md-offset-1">
								{!! html()->label( 'Objet','objet') !!}
								{!! html()->text('objet',$objet)->placeholder('Objet')->attributes(['class' => 'form-control']) !!}	
							</div>
						</div>
						<div class='form-group'>
						    <div class="col-md-8 col-md-offset-1">
						    	{!! html()->label( 'Message','message') !!}
						    	{!! html()->textarea('message',$message)->placeholder('Message')->attributes(['rows'=>'6','class' => 'form-control']) !!}	
						    </div>
						</div>
						<div class="col-sm-9">
							{!! html()->button('Envoyer')->value('Envoyer')->type('submit')->attributes(['class' => 'btn btn-primary']) !!}
						</div>
					</div>
				</div>
	            {{ html()->form()->close() }}
            </div>
        </div>
    </div>
@endsection


