@extends('layouts.dash')
@section('title') Emails @stop
@section('title_card',"")
@section('subtitle_card',"")


@section('content')
    <div class="card">
        <div class="col-lg-max col-lg-offset-1 container-fluid">
            <div class="card-header bg-info">
                Employeurs Actifs<small> - Email envoyés</small>
            </div>
            <div class="card-body">
                <table id="_table" style="background-color:white"  
                    class="table table-condensed table-striped table-hover table-bordered">
                    <thead>
                        <tr>
                            <th width='1%'>N°</th>
                            <th>Nom</th>
                            <th width='1px'>ile</th>
                            <th width='30%'>Responsable</th>
                            <th width='1px'>DernierEmail</th>
                            <th width='1px'>Trimestre&nbsp;du dernier&nbsp;envoi</th>
                            <th width='1px'>Nb Emails</th>
                            <th width='1px'>Statut</th>
                            <th width='1px'></th>
                        </tr>
                    </thead>
         
                    <tbody>

                        @foreach ($employeurs as $employeur)
                        <?php
                            $date=$employeur->getSendEmailLastDate("REC_BRD_RELEVE");
                        ?>
                        <tr class="clickable-row" data-href="./employeurs/{!! $employeur->id !!}">
                            <td>
                                {!! str_pad($employeur->id,4,'0',STR_PAD_LEFT) !!}
                            </td>
                            <td nowrap>{!! $employeur->NomReduit !!}<br/>{!! $employeur->email !!}</td>
                            <td align='center'>{!! $employeur->ile !!}</td>
                            <td>{!! (strlen($employeur->responsable)>20)?substr($employeur->responsable,0,20):$employeur->responsable !!}</td>
                            <td nowrap>{!! $date !!}</td>
                            <td nowrap align='center'>{!! $employeur->getEmailTrim('REC_BRD_RELEVE') !!}</td>
                            <td nowrap align='center'>{!! $employeur->NbSendEmail !!}</td>
                            <td align='center'>{!! $employeur->statut !!}</td>
                            <td nowrap>
                                <a href="{!! url('recouvrement_showmails').'/'.$employeur->id !!}" 
                                    class="box_emails fancybox.iframe btn btn-info" 
                                    style="margin-right: 3px;">Voir les Emails</a>
                            </td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>
    </div>
@endsection


@section('styles')
    <!-- FancyBox -->
    <link media="all" type="text/css" rel="stylesheet" href="{{ url('css/jquery.fancybox.css') }}">
    <link media="all" type="text/css" rel="stylesheet" href="{{ url('css/jquery.fancybox-buttons.css') }}">

    <link media="all" type="text/css" rel="stylesheet" href="{{ url('css/jquery-ui.structure.min.css') }}">
    <link media="all" type="text/css" rel="stylesheet" href="{{ url('css/jquery-ui.theme.min.css') }}">
@stop


@section('scripts0')
    <script src="{{ url('js/jquery.fancybox.js') }}"></script>
    <script src="{{ url('js/magicsuggest.js') }}"></script>
    <script>

        $(".box_emails").fancybox({
            fitToView   : true,
            width       : '95%',
            height      : '60%',
            closeClick  : true,
            openEffect  : 'fade',
            closeEffect : 'fade',
        });
    </script>     
@stop

@section('scripts')
    <script>
        $(document).ready(function() {
            var table =$('#_table').DataTable( {
                bAutoWidth: false,
                bPaginate: true,
                bInfo: true,
                bFilter: true,
                //scrollY:        400,
                //scrollX:        true,
                //scrollCollapse: true,
                oLanguage: {
                    "sZeroRecords": "Aucune ligne",
                    "sInfo": "Affichage de _START_ &agrave; _END_ sur _TOTAL_ lignes",
                    "sInfoEmpty": "Showing 0 to 0 of 0 records",
                    "decimal": ",",
                    "thousands": " ",
                    "sSearch":"Chercher",

                    buttons: {
                        colvis: 'Colonnes à afficher',
                        copy: 'Copier',
                        print: 'Imprimer',
                        copyTitle: 'Ajouté au presse-papiers',
                        copyKeys: 'Appuyez sur <i>ctrl</i> ou <i>\u2318</i> + <i>C</i> pour copier les données du tableau à votre presse-papiers. <br><br>Pour annuler, cliquez sur ce message ou appuyez sur Echap.',
                        copySuccess: {
                            _: '%d lignes copiées',
                            1: '1 ligne copiée'
                        }
                    }

                    },
                    "aaSorting": [
                        [0,'desc']
                    ],

                    "aoColumnDefs": [
                        { "sTypes": "numeric", "aTargets": [ 3,4 ] },
                        { bSortable: false, aTargets: [] },
                        { visible: false, targets: [] },
                    ],

                    dom: "<'row'<'col-sm-2 text-left'f><'col-sm-4'><'col-sm-6 text-right'B>>" +
                    "<'row'<'col-sm-12'tr>>" +
                    "<'row'<'col-sm-5'i><'col-sm-7'p>>",

                    buttons: [ 
                        {extend: 'copy',exportOptions: {columns: ':visible'} },
                        {extend: 'excel',exportOptions: {columns: ':visible'} },
                        {extend: 'print',exportOptions: {columns: ':visible'} },
                        'colvis'
                    ],

                } );
        } );

    </script>
@endsection





