@extends('layouts.dash')
@section('title') MED @stop
@section('title_card',"")
@section('subtitle_card',"")


@section('content')
    <div class="card">
        <div class="col-lg-max col-lg-offset-1 container-fluid">
            <div class="card-header bg-info">
                Mises en demeure<small> - Employeurs Actifs</small>
            </div>
            <div class="card-body">
                <div class="row form-group col-md-10 form-inline">
                    {!! html()->label( 'Année :&nbsp;','annee') !!}
                    {!! html()->select('exercice',$exercices,$exercice)
                        ->placeholder('A définir')
                        ->attributes(['id' => 'exercice_id','class' => 'form-control'])  !!}
                </div>
                <div class="row ">
                    <div class="col-lg-max">
                        <table id="_table" style="background-color:white" class="table table-condensed table-striped table-hover table-bordered">
                            <thead>
                                <tr>
                                    <th >N°</th>
                                    <th>Nom</th>
                                    <th >Adresse</th>
                                    <th >Ile</th>
                                    <th >NbSal</th>
                                    <th >Date<br>1er Immat.</th>
                                    <th >Masse<br>Derniers Salaires</th>
                                    <th >Dernier<br/>mois</th>
                                    <th >Mois<br>Manquants</th>
                                    <th >Cotis.<br>Manquante</th>
                                    <th >Maj</th>
                                    <th >Total</th>
                                    <th >Mise en<br>demeure</th>
                                    <th ></th>
                                </tr>
                            </thead>

                            <tbody>
                                @foreach ($employeurs as $employeur)
                                    <?php
                                        $masse_dernier=0;
                                        $mois_manquants=0;
                                        $dernier_mois="";
                                        $taux_total=0;
                                        $cotis=0;
                                        $masse_dernier=$employeur->getMasseDerniersSalaires($exercice);
                                        $mois_manquants=$employeur->getNbMoisManquantsSalaires($exercice);
                                        if(!$masse_dernier) $masse_dernier=0;
                                        if(!$mois_manquants) $mois_manquants=0;
                                        $dernier_mois=$employeur->DateDernierSalaire;
                                        $taux_total=$taux;
                                        $cotis=round($masse_dernier*$taux_total/100,0);
                                        $cotis=round($cotis*$mois_manquants);
                                        if(!is_numeric($exercice)) $exercice=0;
                                        $maj=$employeur->getMajoration($exercice);//round($prc_maj*$cotis/100);

                                        $numero="";
                                    ?>
                                    <tr>
                                        <td>{!! str_pad($employeur->id,4,'0',STR_PAD_LEFT) !!}</td>
                                        <td><a href="{!! url('employeurs/').'/'.$employeur->id !!}" target="_blank">{!! $employeur->NomReduit !!}</a></td>
                                        <td>{!! $employeur->adresse !!}</td>
                                        <td>{!! $employeur->ile !!}</td>
                                        <td>{!! $employeur->getNbEmployes($exercice) !!}</td>
                                        <td >{!! $employeur->date_deb !!}</td>
                                        <td align="right">{!! $masse_dernier !!}</td>
                                        <td >{!! $dernier_mois !!}</td>
                                        <td >{!! $mois_manquants !!}</td>
                                        <td align="right">{!! $cotis !!}</td>
                                        <td align="right">{!! $maj !!}</td>
                                        <td align="right">{!! $cotis+$maj !!}</td>
                                        <td align="center">{!! $employeur->ListeMedHTML !!}</td>
                                        <td >
                                            @if($cotis+$maj>0)
                                            <a href="{!! url('med_create/').'/'.$employeur->id !!}"
                                                class="btn btn-success pull-left"
                                                style="margin-right: 3px;" target="_blank"> <span class="glyphicon glyphicon-plus">MED</span>
                                            </a>
                                            @endif
                                        </td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@section('styles')
    <!-- FancyBox -->
    <link media="all" type="text/css" rel="stylesheet" href="{{ url('css/jquery.fancybox.css') }}">
    <link media="all" type="text/css" rel="stylesheet" href="{{ url('css/jquery.fancybox-buttons.css') }}">

    <link media="all" type="text/css" rel="stylesheet" href="{{ url('css/jquery-ui.structure.min.css') }}">
    <link media="all" type="text/css" rel="stylesheet" href="{{ url('css/jquery-ui.theme.min.css') }}">
@stop


@section('scripts0')
    <script src="{{ url('js/jquery.fancybox.js') }}"></script>
    <script src="{{ url('js/magicsuggest.js') }}"></script>
    <script>
        $(document).ready(function() {
            $('#exercice_id').on('change', function() {
                location.href="{!! url('med_prepa/') !!}/"+$('#exercice_id').val();
            });
        $(".various").fancybox({
                //maxWidth    : 800,
                //maxHeight   : 600,
                fitToView   : false,
                width       : '50%',
                height      : '20%',
                autoSize    : true,
                autoScale   : true,
                closeClick  : false,
                openEffect  : 'none',
                closeEffect : 'none',
            });

        });
    </script>
@stop                  


@section('scripts')
    <script>
        $(document).ready(function() {
            var table =$('#_table').DataTable( {
                bAutoWidth: false,
                bPaginate: true,
                bInfo: true,
                bFilter: true,
                //scrollY:        500,
                //scrollX:        true,
                //scrollCollapse: true,
                oLanguage: {
                    "sZeroRecords": "Aucune ligne",
                    "sInfo": "Affichage de _START_ &agrave; _END_ sur _TOTAL_ lignes",
                    "sInfoEmpty": "Showing 0 to 0 of 0 records",
                    "decimal": ",",
                    "thousands": " ",
                    "sSearch":"Chercher",

                    buttons: {
                        colvis: 'Colonnes à afficher',
                        copy: 'Copier',
                        print: 'Imprimer',
                        copyTitle: 'Ajouté au presse-papiers',
                        copyKeys: 'Appuyez sur <i>ctrl</i> ou <i>\u2318</i> + <i>C</i> pour copier les données du tableau à votre presse-papiers. <br><br>Pour annuler, cliquez sur ce message ou appuyez sur Echap.',
                        copySuccess: {
                            _: '%d lignes copiées',
                            1: '1 ligne copiée'
                        }
                    }

                    },
                    "aaSorting": [[0,'desc']],

                    "aoColumnDefs": [
                        { "sTypes": "numeric", "aTargets": [ 5,6,7 ] },
                        { bSortable: false, aTargets: [] },
                        { visible: false, targets: [] },
                    ],
                    dom: "<'row'<'col-sm-2 text-left'f><'col-sm-4'><'col-sm-6 text-right'B>>" +
                    "<'row'<'col-sm-12'tr>>" +
                    "<'row'<'col-sm-5'i><'col-sm-7'p>>",

                    buttons: [
                        {extend: 'copy',exportOptions: {columns: ':visible'} },
                        {extend: 'excel',exportOptions: {columns: ':visible'} },
                        'colvis'
                    ],
                } );

        } );
    </script>
@stop 



