@extends('layouts.dash')
@section('title') Rappels @stop
@section('title_card',"")
@section('subtitle_card',"")


@section('content')
    <div class="card">
        <div class="col-lg-max col-lg-offset-1 container-fluid">
            <div class="card-header bg-info">
                Employeurs Actifs<small> - Envoi des appels de cotisations</small>
            </div>
            <div class="card-body">
                <table id="_table" style="background-color:white"  
                    class="table table-condensed table-striped table-hover table-bordered">
                    <thead>
                        <tr>
                            <th >N°</th>
                            <th>Nom</th>
                            <th >NbSal</th>
                            <th >Email</th>
                            <th >ile</th>
                            <th width='30%'>Responsable</th>
                            <th >DernierEmail</th>
                            <th >PJ</th>
                            <th width='5%'>Statut</th>
                            <th ></th>
                        </tr>
                    </thead>
         
                    <tbody>
                        @foreach ($employeurs as $employeur)
                        <?php
                            $date=$employeur->getSendEmailLastDate("REC_BRD_RELEVE");
                            $nom_fichier=$employeur->getSendEmailLastPJ("REC_BRD_RELEVE");
                            $pj="";
                            if($nom_fichier!="") $pj=url("/upload/recouvrement/bordereau/".$nom_fichier);
                        ?>
                        <tr>
                            <td>{!! str_pad($employeur->id,4,'0',STR_PAD_LEFT) !!}</td>
                            <td>{!! $employeur->NomReduit !!}</td>
                            <td align="center"> {!! $employeur->Nbemployes !!}</td>
                            <td>{!! $employeur->email !!}</td>
                            <td align="center">{!! $employeur->ile !!}</td>
                            <td>{!! (strlen($employeur->responsable)>20)?substr($employeur->responsable,0,20):$employeur->responsable !!}</td>
                            <td>{!! $date !!}</td>
                            <td nowrap><a href="{!! $pj !!}" target="_blank">{!! ($pj=="")?'':'<i class="fas fa-file"></i>.pdf' !!}</a></td>
                            <td align="center">{!! $employeur->statut !!}</td>
                            <td nowrap>
                                <span>
                                    @if($user->can("COT_EMAIL") || $user->HasRole("ADMINISTRATEUR"))
                                        @if(trim($employeur->email)!="")
                                       <a href="{!! url('recouvrement_sendmail').'/'.$employeur->id !!}" 
                                                class="box_email fancybox.iframe btn btn-info" 
                                                style="margin-right: 3px;">Email</a> 
                                        @endif
                                    @endif
                                    <a href="javascript:"  
                                    onclick="$('#employeur_id').val({!! $employeur->id !!});$('#dialog-percotis').dialog( 'open' );return false;" 
                                    class="box_versement fancybox.iframe btn btn-warning pull-left" 
                                    target="_blank">Bordereau</a>
                                </span>
                            </td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>
    </div>


    <div id="dialog-percotis" title="Période">
        {!! html()->label( 'Veuillez saisir la période de cotisation','per_cotis') !!}
        {!! html()->select('annee_cotis',$exercices,date('Y')-1)
            ->placeholder('A définir')
            ->attributes(['id' => 'annee_cotis','class' => 'form-control selectpicker','data-width' => "100%",'style' => 'font-weight:bold;background:whitesmoke'])  !!}
        <br/>
        {!! html()->select('tri_cotis',["T1"=>"1er trimestre","T2"=>"2e trimestre","T3"=>"3e trimestre","T4"=>"4e trimestre"],"")
            ->placeholder('Choisissez un trimestre')
            ->attributes(['id' => 'tri_cotis','class' => 'form-control selectpicker','data-width' => "100%"])  !!}
        <br/>
        {!! html()->text('per_cotis',null)->placeholder('Libellé de la période')->attributes(['class' => 'form-control','id'=>'per_cotis']) !!}
    </div>

    <div id="dialog-email" title="Email">
        {!! html()->hidden('employeur_id', '')->attributes(['id' => 'employeur_id']) !!}
        {!! html()->text('email',$employeur->email)->placeholder('email')->attributes(['class' => 'form-control','id'=>'email']) !!}

            <br/>
        {!! html()->label( "Veuillez saisir l'objet et le texte :",'email_sujet') !!}
        {!! html()->text('email_objet',null)->placeholder('Objet')->attributes(['class' => 'form-control','id'=>'email_objet']) !!}

        {!! html()->textarea('email_texte',null)->placeholder('Texte')->attributes(['class' => 'form-control','id'=>'email_texte','row'=>'4']) !!}
    </div>

@endsection


@section('styles')
    <!-- FancyBox -->
    <link media="all" type="text/css" rel="stylesheet" href="{{ url('css/jquery.fancybox.css') }}">
    <link media="all" type="text/css" rel="stylesheet" href="{{ url('css/jquery.fancybox-buttons.css') }}">

    <link media="all" type="text/css" rel="stylesheet" href="{{ url('css/jquery-ui.structure.min.css') }}">
    <link media="all" type="text/css" rel="stylesheet" href="{{ url('css/jquery-ui.theme.min.css') }}">
@stop


@section('scripts0')
    <script src="{{ url('js/jquery.fancybox.js') }}"></script>
    <script src="{{ url('js/magicsuggest.js') }}"></script>

    <script>
        $(".box_email").fancybox({
            fitToView   : false,
            width       : '85%',
            height      : '70%',
            closeClick  : true,
            openEffect  : 'fade',
            closeEffect : 'fade',
        });


        $( "#dialog-percotis" ).dialog({
            closeOnEscape: false,
            open: function(event, ui) { $(".ui-dialog-titlebar-close").hide(); },
            resizable: false,
            height: "auto",
            width: 400,
            modal: true,
            autoOpen: false,
            buttons: {
            "OK": function() {
                var tri_cotis=$('#tri_cotis').val();
                var per_cotis=$('#per_cotis').val();
                var annee_cotis=$('#annee_cotis').val();
                var employeur_id=$('#employeur_id').val();
                if(tri_cotis=="") {alert("Vous devez choisir un trimestre");return;}
                if(annee_cotis=="") return;
                var url='{!! url('cotisations_bordereau_cotisation') !!}'+"/"+employeur_id; 
                url+="/"+annee_cotis;
                url+="/"+tri_cotis; 
                if(per_cotis!="") url+="/"+per_cotis.replace(/\//g,"_"); 
                window.open(url,'_blank');
                $( this ).dialog( "close" );
            },
            Annuler: function() {
              $( this ).dialog( "close" );
            }
            }
        });


      $( "#dialog-email" ).dialog({
        closeOnEscape: false,
        open: function(event, ui) { $(".ui-dialog-titlebar-close").hide(); },
        resizable: false,
        height: 400,
        width: 600,
        modal: true,
        autoOpen: false,
        buttons: {
        "Envoyer": function() {
            var email=$('#email').val();
            var email_objet=$('#email_objet').val();
            var email_texte=$('#email_texte').val();
            if(email_objet=="") return;
            if(email_texte=="") return;
            var param=email_objet+"@@"+email_texte;
            var url="{!! url('recouvrement_sendmail/') !!}"+"/"+email+"/"+email_objet+"/"+email_texte; 
            window.open(url,'_blank');
            $( this ).dialog( "close" );
        },
        Annuler: function() {
          $( this ).dialog( "close" );
        }
        }
    });

</script>
@endsection

@section('scripts')
    <script>
        $(document).ready(function() {
            var table =$('#_table').DataTable( {
                bAutoWidth: false,
                bPaginate: true,
                bInfo: true,
                bFilter: true,
                //scrollY:        400,
                //scrollX:        false,
                //scrollCollapse: true,
                oLanguage: {
                    "sZeroRecords": "Aucune ligne",
                    "sInfo": "Affichage de _START_ &agrave; _END_ sur _TOTAL_ lignes",
                    "sInfoEmpty": "Showing 0 to 0 of 0 records",
                    "decimal": ",",
                    "thousands": " ",
                    "sSearch":"Chercher",

                    buttons: {
                        colvis: 'Colonnes à afficher',
                        copy: 'Copier',
                        print: 'Imprimer',
                        copyTitle: 'Ajouté au presse-papiers',
                        copyKeys: 'Appuyez sur <i>ctrl</i> ou <i>\u2318</i> + <i>C</i> pour copier les données du tableau à votre presse-papiers. <br><br>Pour annuler, cliquez sur ce message ou appuyez sur Echap.',
                        copySuccess: {
                            _: '%d lignes copiées',
                            1: '1 ligne copiée'
                        }
                    }

                    },
                    "aaSorting": [
                        [0,'desc']
                    ],

                    "aoColumnDefs": [
                        { "sTypes": "numeric", "aTargets": [ 3,4 ] },
                        { bSortable: false, aTargets: [] },
                        { visible: false, targets: [] },
                    ],

                    dom: "<'row'<'col-sm-2 text-left'f><'col-sm-4'><'col-sm-6 text-right'B>>" +
                    "<'row'<'col-sm-12'tr>>" +
                    "<'row'<'col-sm-5'i><'col-sm-7'p>>",

                    buttons: [ 
                        {extend: 'copy',exportOptions: {columns: ':visible'} },
                        {extend: 'excel',exportOptions: {columns: ':visible'} },
                        {extend: 'print',exportOptions: {columns: ':visible'} },
                        'colvis'
                    ],

                } );
        } );

    </script>
@endsection

