@extends('layouts.dash')
@section('title') RAP @stop
@section('title_card',"")
@section('subtitle_card',"")


@section('content')
    <div class="card">
        <div class="col-lg-max col-lg-offset-1 container-fluid">
            <div class="card-header bg-info">
                <h3>Reste à payer<small> - Employeurs Actifs et non actifs</small></h3>
            </div>
            <div class="card-body">
                <table id="_table" style="background-color:white" class="table table-condensed table-striped table-hover table-bordered">
                    <thead>
                        <tr>
                            <th rowspan="2">N°</th>
                            <th rowspan="2">Nom</th>
                            <th rowspan="2">Statut</th>
                            <th rowspan="2">Débit</th>
                            <th rowspan="2">Crédit</th>
                            <th rowspan="2">Solde antérieur</th>
                            <th colspan="2" rowspan="1" >Solde {!! (date('Y')-2) !!}</th>
                            <th colspan="2" rowspan="1" >Solde {!! (date('Y')-1) !!}</th>
                            <th colspan="2" rowspan="1" >Solde {!! (date('Y')) !!}</th>
                            <th rowspan="2" rowspan="1" >Solde Total</th>
                        </tr>
                        <tr>
                            <th>Débit {!! (date('Y')-2) !!}</th>
                            <th>Crédit {!! (date('Y')-2) !!}</th>
                            <th>Débit {!! (date('Y')-1) !!}</th>
                            <th>Crédit {!! (date('Y')-1) !!}</th>
                            <th>Débit {!! (date('Y')) !!}</th>
                            <th>Crédit {!! (date('Y')) !!}</th>
                        </tr>
                    </thead>
         
                    <tbody>
                        @foreach ($employeurs as $employeur)
                            <?php
                                $debit=$employeur->Debit;
                                $credit=$employeur->Credit;
                                $delta=$credit-$debit;
                                $annee=date('Y');
                                $annee_prec=date('Y')-1;
                                $annee_prec2=date('Y')-2;

                                $delta_A2=$employeur->getSoldeExercice($annee_prec2,$annee_prec2.'-12-31'); 
                                $credit_A2=$employeur->getCreditExercice($annee_prec2,$annee_prec2.'-12-31');
                                $debit_A2=$employeur->getDebitExercice($annee_prec2,$annee_prec2.'-12-31');

                                $delta_A1=$employeur->getSoldeExercice($annee_prec,$annee_prec.'-12-31');
                                $credit_A1=$employeur->getCreditExercice($annee_prec,$annee_prec.'-12-31');
                                $debit_A1=$employeur->getDebitExercice($annee_prec,$annee_prec.'-12-31');

                                $delta_A=$employeur->getSoldeExercice($annee,$annee.'-12-31');
                                $credit_A=$employeur->getCreditExercice($annee,$annee.'-12-31');
                                $debit_A=$employeur->getDebitExercice($annee,$annee.'-12-31');

                                $delta_prec=$delta-($delta_A+$delta_A1+$delta_A2);

                                $debit_ant=$debit-($debit_A+$debit_A1+$debit_A2);
                                $credit_ant=$credit-($credit_A+$credit_A1+$credit_A2);
                                $delat_ant=$credit_ant-$debit_ant;
                            ?>
                            <tr>
                                <td>{!! str_pad($employeur->id,4,'0',STR_PAD_LEFT) !!}</td>
                                <td ><a href="{!! url('employeurs/')."/".$employeur->id !!}" target="_blank">{!! $employeur->NomReduit !!}</a></td>
                                <td align="right">{!! $employeur->statut !!}</td>
                                <td align="right">{!! $debit_ant !!}</td>
                                <td align="right">{!! $credit_ant !!}</td>
                                <td align="right">{!! $delat_ant !!}</td>
                                <td align="right" style="color:darkblue">{!! $debit_A2 !!}</td>
                                <td align="right" style="color:darkred">{!! $credit_A2 !!}</td>
                                <td align="right" style="color:darkblue">{!! $debit_A1 !!}</td>
                                <td align="right" style="color:darkred">{!! $credit_A1 !!}</td>
                                <td align="right" style="color:darkblue">{!! $debit_A !!}</td>
                                <td align="right" style="color:darkred">{!! $credit_A !!}</td>
                                <td align="right">{!! $delta !!}</td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>
    </div>
@endsection


@section('scripts')
    <script>
        $(document).ready(function() {
            var table =$('#_table').DataTable( {
                bAutoWidth: true,
                bPaginate: false,
                bInfo: true,
                bFilter: true,
                deferRender:    true,
                scrollY:        400,
                scrollX:        true,
                scrollCollapse: true,
                oLanguage: {
                    "sZeroRecords": "Aucune ligne",
                    "sInfo": "Affichage de _START_ &agrave; _END_ sur _TOTAL_ lignes",
                    "sInfoEmpty": "Showing 0 to 0 of 0 records",
                    "decimal": ",",
                    "thousands": " ",
                    "sSearch":"Chercher",

                    buttons: {
                        colvis: 'Colonnes à afficher',
                        copy: 'Copier',
                        print: 'Imprimer',
                        copyTitle: 'Ajouté au presse-papiers',
                        copyKeys: 'Appuyez sur <i>ctrl</i> ou <i>\u2318</i> + <i>C</i> pour copier les données du tableau à votre presse-papiers. <br><br>Pour annuler, cliquez sur ce message ou appuyez sur Echap.',
                        copySuccess: {
                            _: '%d lignes copiées',
                            1: '1 ligne copiée'
                        }
                    }

                    },

                    "aaSorting": [
                        [0,'desc']
                    ],

                    "aoColumnDefs": [
                        { "sTypes": "numeric", "aTargets": [ 3,4,5,6,7,8,9 ] },
                        { bSortable: false, aTargets: [] },
                        { visible: false, targets: [] },
                    ],


            dom: "<'row'<'col-sm-2 text-left'f><'col-sm-4'><'col-sm-6 text-right'B>>" +
            "<'row'<'col-sm-12'tr>>" +
            "<'row'<'col-sm-5'i><'col-sm-7'p>>",

                    buttons: [
                        {extend: 'copy',exportOptions: {columns: ':visible'} },
                        {extend: 'excel',exportOptions: {columns: ':visible'} },
                        {extend: 'print',exportOptions: {columns: ':visible'} },
                        'colvis'
                    ],

                } );






            $('#_table').DataTable().draw();

            $(window).resize(function () {
                $('#_table').DataTable().draw();
            });

        } );
    </script>
@endsection



