@include('forms.fbncheader')
@include('forms.fdatatables')


{!! Html::style('css/jquery-ui.structure.min.css') !!}
{!! Html::style('css/jquery-ui.theme.min.css') !!}



<div style="background-color:rgba(255,132,193,.2);"
    class="col-lg-max col-lg-offset-1 container-fluid">

    <div style="padding-left:0px" class="col-lg-max">
        <div class="row" style="">
            <div class="col-xs-1" style="padding-left:0px;">
               {!! Html::image("img/entreprise_med.png",
                    "Employeurs",
                    array( 'width'=>'100%',
                        "style"=>"padding:4px" ))
                !!}
            </div>
            <div class="col-xs-10" style="padding-left:0px">
                <h1 style="margin-top:2px;">
                     Reste à payer Trimestriel<small> - Employeurs Actifs et non actifs</small>
                </h1>
            </div>
        </div>
    </div>

    <div class='row' style="">
        <div class="col-xs-2 col-xs-offset-1">
            {!! Form::label('annes', 'Année :' ) !!}
            {!! Form::select('exercice',$exercices,$annee,
                [
                    'id' => 'exercice_id','class' => 'form-control selectpicker',
                    'data-width' => "100%",'style' => 'font-weight:bold;'
                ]
            )
            !!}
            <script>
                $(document).ready(function() {
                    $('#exercice_id').on('change', function() {
                        location.href="{!! url('recouvrement/reste_a_payer_trim/') !!}/"
                            +$('#exercice_id').val();
                    });
                });
            </script>
        </div>
    </div>



    <div class='col-lg-max' style="padding-top:5px">
        <div class="table-responsive" >
            <table id="_table" style="background-color:white"
                class="table table-condensed table-striped table-hover table-bordered">
                <thead>
                    <tr>
                        <th rowspan="2" width='1%'>N°</th>
                        <th rowspan="2" width='10%'>Nom</th>
                        <th rowspan="2" width='1%'>Statut</th>
                        <th colspan="3" rowspan="1">Antérieurs</th>
                        @for($j=1;$j<=4;$j++)
                            <th colspan="3" rowspan="1">{!! "Trimestre ".$j !!}</th>
                        @endfor
                    </tr>
                    <tr>
                        <th>Débit</th>
                        <th>Crédit</th>
                        <th>Solde</th>
                        @for($j=1;$j<=4;$j++)
                        <th>Débit</th>
                        <th>Crédit</th>
                        <th >Solde</th>
                        @endfor
                        <th >CreditTotal</th>
                        <th >DebitTotal</th>
                        <th >SoldeTotal</th>
                    </tr>
                </thead>

                <tbody>
                    @foreach ($employeurs as $employeur)
                    <?php
                        $credit_total=0;
                        $debit_total=0;
                        $solde_total=0;
                        $date_ant=$annee."-01-01";
                        for($j=1;$j<=4;$j++) {
                            $debit["T".$j]=$employeur->getDebitTrim($j,$annee);
                            $credit["T".$j]=$employeur->getCreditTrim($j,$annee);
                            $solde["T".$j]=round($credit["T".$j]-$debit["T".$j],0);
                            $credit_total+=$credit["T".$j];
                            $debit_total+=$debit["T".$j];
                            $solde_total+=$solde["T".$j];
                        }
                        $anterieur_debit=$employeur->getDebitAnterieur($date_ant);
                        $anterieur_credit=$employeur->getCreditAnterieur($date_ant);
                        $anterieur_solde=round($anterieur_credit-$anterieur_debit,0);
                        $credit_total+=$anterieur_credit;
                        $debit_total+=$anterieur_debit;
                        $solde_total+=$anterieur_solde;
                    ?>
                        <tr>
                            <td>
                                {!! str_pad($employeur->id,4,'0',STR_PAD_LEFT) !!}
                            </td>
                            <td nowrap>
                                <a href="{!! url('employeurs/')."/".$employeur->id !!}" target="_blank">
                                    {!! $employeur->NomReduit !!}
                                </a>
                            </td>
                            <td align="right" nowrap>{!! $employeur->statut !!}</td>
                                <td align="right">{!! $anterieur_debit !!}</td>
                                <td align="right">{!! $anterieur_credit !!}</td>
                                <td align="right" style='background-color:#FFCCCC'>{!! $anterieur_solde !!}</td>

                            @for($j=1;$j<=4;$j++)
                                <td align="right">{!! $debit["T".$j] !!}</td>
                                <td align="right">{!! $credit["T".$j] !!}</td>
                                <td align="right" style='background-color:#FFCCCC'>{!! $solde["T".$j] !!}</td>
                            @endfor
                            <td align="right" style='background-color:#CCE5FF'>{!! $credit_total !!}</td>
                            <td align="right" style='background-color:#CCE5FF'>{!! $debit_total !!}</td>
                            <td align="right" style='background-color:#CCE5FF'>{!! $solde_total !!}</td>
                        </tr>

                    @endforeach
                </tbody>
            </table>
        </div>
    </div>

</div>

</body></html>

<script>
    $(document).ready(function() {

        var table =$('#_table').DataTable( {
            bAutoWidth: false,
            bPaginate: false,
            bInfo: true,
            bFilter: true,
            //deferRender:    true,
            scrollY:        "400px",
            scrollX:        true,
            scrollCollapse: true,
            oLanguage: {
                "sZeroRecords": "Aucune ligne",
                "sInfo": "Affichage de _START_ &agrave; _END_ sur _TOTAL_ lignes",
                "sInfoEmpty": "Showing 0 to 0 of 0 records",
                "decimal": ",",
                "thousands": " ",
                "sSearch":"Chercher",

                buttons: {
                    colvis: 'Colonnes à afficher',
                    copy: 'Copier',
                    print: 'Imprimer',
                    copyTitle: 'Ajouté au presse-papiers',
                    copyKeys: 'Appuyez sur <i>ctrl</i> ou <i>\u2318</i> + <i>C</i> pour copier les données du tableau à votre presse-papiers. <br><br>Pour annuler, cliquez sur ce message ou appuyez sur Echap.',
                    copySuccess: {
                        _: '%d lignes copiées',
                        1: '1 ligne copiée'
                    }
                }

                },

                "aaSorting": [
                    [0,'desc']
                ],

                "aoColumnDefs": [
                    { "sTypes": "numeric", "aTargets": [ 3,4,5,6,7,8,9 ] },
                    { bSortable: false, aTargets: [] },
                    { visible: false, targets: [] },
                ],


                dom: "<'row'<'col-sm-4 text-left'f><'col-sm-4'><'col-sm-6 text-right'B>>" +
                "<'row'<'col-sm-12'tr>>" +
                "<'row'<'col-sm-5'i><'col-sm-7'p>>",

                buttons: [
                    {extend: 'copy',exportOptions: {columns: ':visible'} },
                    {extend: 'excel',exportOptions: {columns: ':visible'} },
                    {extend: 'print',exportOptions: {columns: ':visible'} },
                    'colvis'
                ],

            } );






        $('#_table').DataTable().draw();

        $(window).resize(function () {
            $('#_table').DataTable().draw();
        });

    } );
</script>



