@extends('layouts.dash')
@section('title') Bordereaux @stop
@section('title_card',"")
@section('subtitle_card',"")

@section('content')
    @if (Session::has('message'))
        <div class="alert alert-warning">{!! Session::get('message') !!}</div>
    @endif
    @if ($errors)
        @foreach ($errors->all() as $error)
            <div class='bg-danger alert'>{!! $error !!}</div>
        @endforeach
    @endif
    @if (Session::has('success'))
        <div class="alert alert-success">{!! \Session::get('success') !!}</div>
    @endif

    <div class="card">
        <div class="card-header bg-info">
            <h3>Liste des Bordereaux {!! $exercice !!}</h3>
        </div>
        <div class="card-body">
            <div class="row form-group col-md-10 form-inline">
                {!! html()->label( 'Année :&nbsp;','annee') !!}
                {!! html()->select('exercice',$exercices,$exercice)
                    ->placeholder('A définir')
                    ->attributes(['id' => 'exercice_id','class' => 'form-control'])  !!}
            </div>
            @if($nb>0)
                <div class="table-responsive">
                    <table id="_table"  style="background-color:white"  
                        class="table table-condensed table-striped table-hover table-bordered">
                        <thead>
                            <tr>
                                <th nowrap width='5%'>N°Bdx</th>
                                <th>Type</th>
                                <th width='10%'>total_clr</th> 
                                <th width='10%'>total_ccpf</th> 
                                <th width='10%'>total_debit</th> 
                                <th width='10%'>total_credit</th>
                                <th width='10%'>nb_societe</th>
                                <th width='10%'>total_assiette</th>
                                <th width='10%'>total_salaries</th>
                                <th width='1%'></th>
                            </tr>
                        </thead>
                        <tbody>

                        @for($i=0;$i<$nb;$i++) 
                            <tr>
                                <td >{!! $t_bdx['bdx_id'][$i] !!}</td>
                                <td >{!! $t_bdx['type'][$i] !!}</td>
                                <td nowrap align="right">{!! number_format($t_bdx['total_clr'][$i],0,","," ") !!}</td>
                                <td nowrap align="right">{!! number_format($t_bdx['total_ccpf'][$i],0,","," ") !!}</td>
                                <td nowrap align="right" class="{!! ($t_bdx['total_debit'][$i]>0)?'text-danger':'' !!}" >{!! number_format($t_bdx['total_debit'][$i],0,","," ") !!}</td>
                                <td nowrap align="right" class="{!! ($t_bdx['total_credit'][$i]>0)?'text-success':'' !!}" >{!! number_format($t_bdx['total_credit'][$i],0,","," ") !!}</td>
                                <td nowrap align="right">{!! $t_bdx['nb_societe'][$i] !!}</td>
                                <td nowrap align="right">{!! number_format($t_bdx['total_assiette'][$i],0,","," ") !!}</td>
                                <td nowrap align="right">{!! $t_bdx['total_salaries'][$i] !!}</td>
                                <td nowrap align="right">
                                    @if($t_bdx['bdx_id'][$i]!="")
                                    <a href="{!! url('bordereaux').'/'.$exercice.'/'.$t_bdx['bdx_id'][$i].'/'.$t_bdx['type'][$i] !!}" 
                                        class="btn btn-info pull-left" 
                                        target="_blank" style="margin-right: 3px;">
                                        Détail
                                    </a>
                                    @endif
                                </td>
                            </tr>
                        @endfor
                        </tbody>
                    </table>
                </div>
            @endif
        </div>
    </div>
@endsection


@section('scripts')
<script>
$(document).ready(function() {


    $('#exercice_id').on('change', function() {
        location.href="{!! url('bordereaux_liste/') !!}/"+$('#exercice_id').val();
    });

   $.fn.dataTable.moment('D/M/YYYY');

    var table =$('#_table').dataTable( {
        bAutoWidth: false,
        bPaginate: false,
        bInfo: true,
        bFilter: true,

        deferRender:    true,
        //scrollY:        400,
        scrollCollapse: false,
        scroller:       false,

        iDisplayLength:10,
        oLanguage: {
            "sZeroRecords": "Aucune ligne",
            "sInfo": "Affichage de _START_ &agrave; _END_ sur _TOTAL_ lignes",
            "sInfoEmpty": "Showing 0 to 0 of 0 records",
            "sInfoFiltered": "(sur un total de _MAX_ lignes)",
            "oPaginate": {"sPrevious": "Pr&eacute;c&eacute;dente","sNext": "Suivante"
                ,"sFirst": "Premi&egrave;re","sLast": "Derni&egrave;re"},
                "sSearch":"Chercher ",
            buttons: {
                colvis: 'Colonnes à afficher',
                copy: 'Copier',
                print: 'Imprimer',
                copyTitle: 'Ajouté au presse-papiers',
                copyKeys: 'Appuyez sur <i>ctrl</i> ou <i>\u2318</i> + <i>C</i> pour copier les données du tableau à votre presse-papiers. <br><br>Pour annuler, cliquez sur ce message ou appuyez sur Echap.',
                copySuccess: {
                    _: '%d lignes copiées',
                    1: '1 ligne copiée'
                }
            }

            },
            dom: "<'row'<'col-sm-2 text-left'f><'col-sm-4'><'col-sm-6 text-right'B>>" +
            "<'row'<'col-sm-12'tr>>" +
            "<'row'<'col-sm-5'i><'col-sm-7'p>>",

            buttons: [ 
                {extend: 'copy',exportOptions: {columns: ':visible'} },
                {extend: 'excel',exportOptions: {columns: ':visible'} },
                'colvis'
            ],

        } );

} );
</script>
@endsection