@extends('layouts.dash')

@section('title',"Analyses")
@section('title_card',$titre)

@section('styles')
    <link media="all" type="text/css" rel="stylesheet" href="{{ url('css/morris.css') }}">
    <style>
        td.right {
          text-align: right;
        }
        td.center {
          text-align: center;
        }
        #overlay{   
          position: fixed;
          top: 0;
          z-index: 100;
          width: 100%;
          height:100%;
          display: none;
          background: rgba(0,0,0,0.2);
        }
        .cv-spinner {
          height: 100%;
          display: flex;
          justify-content: center;
          align-items: center;  
        }
        .spinner {
          width: 40px;
          height: 40px;
          border: 4px #ddd solid;
          border-top: 4px #2e93e6 solid;
          border-radius: 50%;
          animation: sp-anime 0.8s infinite linear;
        }
        @keyframes sp-anime {
          100% { 
            transform: rotate(360deg); 
          }
        }
        .is-hide{
          display:none;
        }
    </style>
@stop

@section('content')
    <div id="overlay">
      <div class="cv-spinner">
        <span class="spinner"></span>
      </div>
    </div>
    <div class="card">
        <div class="card-header bg-info">
            <h1 class='card-title' id="libelle_tab"></h1>
        </div>
        <div class="card-body">
            <div class="row">
                <div class="col-md-10">
                    <div class="card card-primary card-outline card-tabs">
                        <div class="card-header p-0 pt-1 border-bottom-0">
                            <ul class="nav nav-tabs" id="custom-tabs-three-tab" role="tablist">
                              <li class="nav-item">
                                <a class="nav-link active" id="custom-tabs-three-home-tab" data-toggle="pill" href="#custom-tabs-three-home" role="tab" aria-controls="custom-tabs-three-home" aria-selected="true">Graphique</a>
                              </li>
                              <li class="nav-item">
                                <a class="nav-link" id="custom-tabs-three-profile-tab" data-toggle="pill" href="#custom-tabs-three-profile" role="tab" aria-controls="custom-tabs-three-profile" aria-selected="false">Données</a>
                              </li>
                            </ul>
                        </div>
                        <div class="tab-content" id="custom-tabs-three-tabContent">
                            <div class="tab-pane fade active show" id="custom-tabs-three-home" role="tabpanel" aria-labelledby="custom-tabs-three-home-tab">
                                <div id='div_graph' class="">
                                    <div id="graph" style="height: 350px;"></div>  
                                </div>                
                            </div>
                            <div class="tab-pane fade" id="custom-tabs-three-profile" role="tabpanel" aria-labelledby="custom-tabs-three-profile-tab">
                                <table id="_table" name="_table" class="table table-bordered table-striped table-condensed" width="100%">
                                    <thead>
                                        <tr>
                                            <th width="1px">Année</th>
                                            <th>Nombre de bénéficiaires</th>
                                            <th>Total des versements</th>
                                        </tr>
                                    </thead>
                                    <tbody>                                      
                                        @foreach($data as $row)
                                            <tr>
                                                <td>{{ $row[0] }}</td>
                                                <td align="right">{{ $row[1] }}</td>
                                                <td align="right">{{ $row[2] }}</td>
                                            </tr>
                                        @endforeach   
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@stop

@section('scripts')
    <!-- Graph  -->
    <script src="{{ url('js/raphael-min.js') }}"></script>
    <script src="{{ url('js/morris.min.js') }}"></script>
    <script>
        $(function () {
            var numgraph='{!! $numgraph !!}';
            var libelle_tab="{!! $libelle_tab !!}";
            var t_api=new Array();
            t_api[1]="api_nb_aidesocales";
            t_api[2]="api_nb_allocations";
            t_api[3]="api_nb_retraites";
            var url_api="../../{{ $api_data }}";
            // Create a function that will handle AJAX requests
            function requestData(chart) {
                $.ajax({
                    type: "GET", dataType: 'json',
                    url: url_api, 
                    data: {  } //ex : days: days
                })
                .done(function (data) {
                    if(chart!="") chart.setData(data);
                    $('#libelle_tab').html(libelle_tab);
                    $('#overlay').hide();
                })           
                .fail(function () {alert("Erreur");})
            }
            // Graph chargement
            var chart = Morris.Line({
                element: 'graph',
                xkey: 'annee', // Set the key for X-axis
                ykeys: ['nb'], // Set the key for Y-axis
                labels: ['Nombre de bénéficiaires', 'SORN'], // Set the label when bar is rolled over
            });
            requestData(chart);
            //Demarrage pagebdefaut
            $("#div_graph").show();
            $("#div_data").hide();
        });
    </script>

    <script>
      $(function () {
        $("#_table").DataTable({
          "paging": true,
          "lengthChange": false,
          "searching": true,
          "ordering": true,
          "info": true,
          "responsive": false,
          "autoWidth": false,
          "fixedHeader": true,
           oLanguage: {
                "sZeroRecords": "Aucune ligne",
                "sInfo": "Affichage de _START_ &agrave; _END_ sur _TOTAL_ lignes",
                "sInfoEmpty": "Showing 0 to 0 of 0 records",
                "sInfoFiltered": "(sur un total de _MAX_ lignes)",
                "oPaginate": {"sPrevious": "Pr&eacute;c&eacute;dente","sNext": "Suivante"
                    ,"sFirst": "Premi&egrave;re","sLast": "Derni&egrave;re"},
                    "sSearch":"Chercher",
                buttons: {
                    colvis: 'Colonnes à afficher',
                    copy: 'Copier',print: 'Imprimer',
                    copyTitle: 'Ajouté au presse-papiers',
                    copyKeys: 'Appuyez sur <i>ctrl</i> ou <i>\u2318</i> + <i>C</i> pour copier les données du tableau à votre presse-papiers. <br><br>Pour annuler, cliquez sur ce message ou appuyez sur Echap.',
                    copySuccess: {
                        _: '%d lignes copiées',
                        1: '1 ligne copiée'
                        }
                    }

            },
            "aaSorting": [
                [0,'desc']
            ],
            dom: "<'row'<'col-sm-6'l><'col-sm-6'f>>" + "<'row'<'col-sm-12'tr>>" + "<'row'<'col-sm-4'i><'col-sm-4'B><'col-sm-4'p>>",
            "buttons": ["copy", "excel"] 
        })
        .buttons().container().appendTo('#_table_wrapper .col-md-6:eq(0)');

      });
    </script>
@stop

