@extends('layouts.dash')

@section('content')

    <input type="hidden" id="numgraph" name="numgraph" value="{!! (isset($numgraph)?$numgraph:'1') !!}" />

    <!-- ------------------------------------- _table ------------------------------- -->
    <div class="row card">
        <div class="card-header bg-info">
            <h3 class="card-title">Nombre d'employeurs par secteur d'activité au 1er janvier</h3>
            <div class="card-tools">
              <button type="button" class="btn bg-info btn-sm" data-card-widget="collapse"><i class="fas fa-plus"></i></button>
              <button type="button" class="btn bg-info btn-sm" data-card-widget="remove"><i class="fas fa-times"></i></button>
            </div>
        </div>
        <div class="card-body"  style="display: none;">
            <table id="_table" class="table table-striped table-bordered table-hover" width="100%">
                <thead>
                    <tr>
                        <th>Secteur</th>
                        @foreach($t_annees as $an)
                            <th>{!! $an !!}</th>
                        @endforeach
                    </tr>
                </thead>
                <tbody>
                    @foreach($secteurs as $secteur)
                    <tr>
                        <td nowrap>{!! $secteur->nom !!}</td>
                        @foreach($t_annees as $an)
                            <?php
                                if(!isset($t_an_employeur[$an])) $t_an_employeur[$an]=0;
                                $t_an_employeur[$an]+=$t_secteur_employeurs[$secteur->id][$an]
                            ?>
                            <td>{!! $t_secteur_employeurs[$secteur->id][$an] !!}</td>
                        @endforeach
                    </tr>
                    @endforeach
                </tbody>
                <tfoot>
                    <tr>
                        <td class='bg-success' style='font-weight:bold'>TOTAL</td>
                        @foreach($t_annees as $an)
                            <td class='bg-success' style='font-weight:bold'>{!! $t_an_employeur[$an] !!}</td>
                        @endforeach
                    </tr>
                </tfoot>
            </table>
        </div>
    </div>

    <!-- ------------------------------------- _table2 ------------------------------- -->
    <div class="card">
        <div class="card-header bg-primary">
            <h3 class="card-title">Nombre d'employés par secteur d'activité au 1er janvier</h3>
            <div class="card-tools">
              <button type="button" class="btn bg-primary btn-sm" data-card-widget="collapse"><i class="fas fa-plus"></i></button>
              <button type="button" class="btn bg-primary btn-sm" data-card-widget="remove"><i class="fas fa-times"></i></button>
            </div>
        </div>
        <div class="card-body" style="display: none;">
            <table id="_table2" class="table table-striped table-bordered table-hover" width="100%">
                <thead>
                    <tr>
                        <th>Secteur</th>
                        @foreach($t_annees as $an)
                            <th>{!! $an !!}</th>
                        @endforeach
                    </tr>
                </thead>
                <tbody>
                    @foreach($secteurs as $secteur)
                    <tr>
                        <td nowrap>{!! $secteur->nom !!}</td>
                        @foreach($t_annees as $an)
                            <?php
                                if(!isset($t_an_employes[$an])) $t_an_employes[$an]=0;
                                $t_an_employes[$an]+=$t_secteur_employes[$secteur->id][$an]
                            ?>
                            <td>{!! $t_secteur_employes[$secteur->id][$an] !!}</td>
                        @endforeach
                    </tr>
                    @endforeach
                </tbody>
                <tfoot>
                    <tr>
                        <td class='bg-success' style='font-weight:bold'>TOTAL</td>
                        @foreach($t_annees as $an)
                            <td class='bg-success' style='font-weight:bold'>{!! $t_an_employes[$an] !!}</td>
                        @endforeach
                    </tr>
                </tfoot>
            </table>
        </div>
    </div>  

    <!-- ------------------------------------- _table3 ------------------------------- -->
    <div class="card">
        <div class="card-header bg-warning">
            <h3 class="card-title">Masse salariale par secteur d'activité au 1er janvier</h3>
            <div class="card-tools">
              <button type="button" class="btn bg-warning btn-sm" data-card-widget="collapse"><i class="fas fa-plus"></i></button>
              <button type="button" class="btn bg-warning btn-sm" data-card-widget="remove"><i class="fas fa-times"></i></button>
            </div>
        </div>
        <div class="card-body" style="display: none;">
            <table id="_table3" class="table table-striped table-bordered table-hover" width="100%">
                <thead>
                    <tr>
                        <th>Secteur</th>
                        @foreach($t_annees as $an)
                            <th>{!! $an !!}</th>
                        @endforeach
                    </tr>
                </thead>
                <tbody>
                    @foreach($secteurs as $secteur)
                    <tr>
                        <td nowrap>{!! $secteur->nom !!}</td>
                        
                        @foreach($t_annees as $an)
                            <?php
                                if(!isset($t_an_masse[$an])) $t_an_masse[$an]=0;
                                $t_an_masse[$an]+=$t_secteur_masse[$secteur->id][$an]
                            ?>
                            <td>{!! $t_secteur_masse[$secteur->id][$an] !!}</td>
                        @endforeach
                    </tr>
                    @endforeach
                </tbody>
                <tfoot>
                    <tr>
                        <td class='bg-success' style='font-weight:bold'>TOTAL</td>
                        @foreach($t_annees as $an)
                            <td class='bg-success' style='font-weight:bold'>{!! $t_an_masse[$an] !!}</td>
                        @endforeach
                    </tr>
                </tfoot>
            </table>
        </div>
    </div>  
@stop

@section('scripts')
<script>

    var table =$('#_table').dataTable( {
        bAutoWidth: false,
        bPaginate: false,
        bInfo: false,
        bFilter: false,
        deferRender:    true,
        scrollCollapse: false,
        scroller:       false,
        oLanguage: {
            "sZeroRecords": "Aucune ligne",
            "sSearch":"Chercher ",
            buttons: {
                colvis: 'Colonnes à afficher',
                copy: 'Copier',
                copyTitle: 'Ajouté au presse-papiers',
                copySuccess: {
                    _: '%d lignes copiées',
                    1: '1 ligne copiée'
                }
            }
        },
        dom: "<'row'<'col-sm-4 text-left'f><'col-sm-8 text-right'B>>" +"<'row'<'col-sm-12'tr>>" +"<'row'<'col-sm-5'i><'col-sm-7'p>>",
        buttons: [ 
            {extend: 'copy',exportOptions: {columns: ':visible'} },
            {extend: 'excel',exportOptions: {columns: ':visible'} },
            'colvis'
        ],  
    } );


    var table =$('#_table2').dataTable( {
        bAutoWidth: false,
        bPaginate: false,
        bInfo: false,
        bFilter: false,
        deferRender:    true,
        scrollCollapse: false,
        scroller:       false,
        oLanguage: {
            "sZeroRecords": "Aucune ligne",
            "sSearch":"Chercher ",
            buttons: {
                colvis: 'Colonnes à afficher',
                copy: 'Copier',
                copyTitle: 'Ajouté au presse-papiers',
                copySuccess: {
                    _: '%d lignes copiées',
                    1: '1 ligne copiée'
                }
            }
        },
        dom: "<'row'<'col-sm-4 text-left'f><'col-sm-8 text-right'B>>" +"<'row'<'col-sm-12'tr>>" +"<'row'<'col-sm-5'i><'col-sm-7'p>>",
        buttons: [ 
            {extend: 'copy',exportOptions: {columns: ':visible'} },
            {extend: 'excel',exportOptions: {columns: ':visible'} },
            'colvis'
        ],  
    } );

    var table =$('#_table3').dataTable( {
        bAutoWidth: false,
        bPaginate: false,
        bInfo: false,
        bFilter: false,
        deferRender:    true,
        scrollCollapse: false,
        scroller:       false,
        oLanguage: {
            "sZeroRecords": "Aucune ligne",
            "sSearch":"Chercher ",
            buttons: {
                colvis: 'Colonnes à afficher',
                copy: 'Copier',
                copyTitle: 'Ajouté au presse-papiers',
                copySuccess: {
                    _: '%d lignes copiées',
                    1: '1 ligne copiée'
                }
            }
        },
        dom: "<'row'<'col-sm-4 text-left'f><'col-sm-8 text-right'B>>" +"<'row'<'col-sm-12'tr>>" +"<'row'<'col-sm-5'i><'col-sm-7'p>>",
        buttons: [ 
            {extend: 'copy',exportOptions: {columns: ':visible'} },
            {extend: 'excel',exportOptions: {columns: ':visible'} },
            'colvis'
        ],  
    } );
    </script>
@stop

