@extends('layouts.dash')
@section('title') Analyses @stop
@section('title_card',"")
@section('subtitle_card',"")


@section('content')
    <div class="row container-fluid">
        <div class="col-lg-8">
            <div class="card">
                <div class="card-header bg-info">
                    Nombre de bénéficiaires
                    <div class="card-tools">
                        <button type="button" class="btn btn-tool" data-card-widget="collapse">
                            <i class="fas fa-minus"></i>
                        </button>
                        <button type="button" class="btn btn-tool" data-card-widget="remove">
                            <i class="fas fa-times"></i>
                        </button>
                    </div>
                </div>
                <div class="card-body">
                    <h4 class='bg-alert'>Nombre de bénéficiaires
                        @if($benef_type=='A') d'Allocations @endif
                        @if($benef_type=='S') d'Aides sociales @endif
                        @if($benef_type=='R') de Retraite @endif
                    </h4>

                    <table id="_table" class="table table-condensed table-striped table-bordered">
                        <tbody>
                            <th></th>
                            @foreach($t_header as $ref=>$libelle)
                                <th>{!! $libelle !!}</th>
                            @endforeach

                            @foreach($zones as $zone)
                                <tr  class='{!! $t_table[$zone]["classe"] !!}'  style='{!! $t_table[$zone]["style"] !!}'>
                                    <td>{!! $t_table[$zone]['nom'] !!}</td>
                                    <?php foreach($t_header as $ref=>$libelle) { ?>
                                        <td class='{!! $t_table[$zone]["classe_".$ref] !!}'  style='{!! $t_table[$zone]["style_".$ref] !!}'>
                                            {!! html()->text($t_table[$zone]['nom'].'_'.$ref, $t_table[$zone]["value_".$ref])->attributes([ 'class' => 'form-control', 'readonly','style'=>'text-align:center;']) !!}
                                        </td>
                                    <?php } ?>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
                

    @if($benef_type=="S") 
        <div class="row container-fluid">
            <div class="col-lg-8">
                <div class="card">
                    <div class="card-header bg-warning">
                        Nombre de bénéficiaire par nombre d'enfants avec allocations
                        <div class="card-tools">
                            <button type="button" class="btn btn-tool" data-card-widget="collapse">
                                <i class="fas fa-minus"></i>
                            </button>
                            <button type="button" class="btn btn-tool" data-card-widget="remove">
                                <i class="fas fa-times"></i>
                            </button>
                        </div>
                    </div>
                    <div class="card-body">
                        <div class="table-responsive">
                            <table id="_table" class="table table-condensed  table-striped table-bordered">
                                <theader>
                                    <tr>
                                        <th rowspan=2 style='vertical-align:middle'>Zone</th>
                                        <th colspan="{!! $maxenfant !!}" style='text-align:center'>Nb Enfants</th>
                                    </tr>
                                    <tr>
                                        @for($i=1;$i<=$maxenfant;$i++)
                                            <th style='text-align:center'>{!! $i !!}</th>
                                        @endfor
                                    </tr>
                                </theader>    
                                <tbody>
                                    @foreach($zones as $zone)
                                        <tr class='{!! $t_famille[$zone]["classe"] !!}' style='{!! $t_famille[$zone]["style"] !!}'>
                                            <td>{!! $t_famille[$zone]['nom'] !!}</td>
                                            <?php for($i=1;$i<=$maxenfant;$i++) { ?>
                                                <td class='{!! $t_famille[$zone]["classe"] !!}' style='{!! $t_famille[$zone]["style"] !!};text-align:center'>
                                                    {!! html()->text($t_famille[$zone]['nom'].'_'.$i, $t_famille[$zone][$i])->attributes(['class' => 'form-control', 'readonly','style'=>'text-align:center;']) !!}
                                                </td>
                                            <?php } ?>
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    @endif
@endsection


@section('scripts')
    @include("forms.scripts_datatable_btn")
@endsection
