@extends('layouts.dash')
@section('title') Analyses @stop
@section('title_card',"")
@section('subtitle_card',"")


@section('content')
    <div class="col-lg-12">
        <div class="card">
            <div class="card-header bg-info">
                {!! $titre !!}
                <div class="card-tools">
                    <button type="button" class="btn btn-tool" data-card-widget="collapse">
                        <i class="fas fa-minus"></i>
                    </button>
                    <button type="button" class="btn btn-tool" data-card-widget="remove">
                        <i class="fas fa-times"></i>
                    </button>
                </div>
            </div>
            <div class="card-body ">
                <h3>Nombre de bénéficiaires</h3>
                <div class="row  form-group" style="margin-bottom:40px">   
                    <div class="col-md-2">
                        {!! html()->label( 'Année :','annes' ) !!}
                        {!! html()->select('exercice',$exercices,$exercice)->attributes(['id' => 'exercice_id','class' => 'form-control']) !!}

                    </div>
                    <div class="col-xs-2">
                        {!! html()->label( 'Mois :','mois' ) !!}
                        {!! html()->select('mois',$moiss,$mois)->attributes([
                                'id' => 'mois_id','class' => 'form-control']) !!}
                    </div>
                </div>

                <div class="row">  
                    <table id="_table" class="table table-condensed">
                        <tbody>
                            <th></th>
                            @foreach($t_header as $ref=>$libelle)
                            <th>{!! $libelle !!}</th>
                            @endforeach

                            @foreach($zones as $zone)
                            <tr  class='{!! $t_table[$zone]["classe"] !!}'  style='{!! $t_table[$zone]["style"] !!}'>
                                <td>{!! $t_table[$zone]['nom'] !!}</td>
                                <?php foreach($t_header as $ref=>$libelle) { ?>
                                    <td class='{!! $t_table[$zone]["classe_".$ref] !!}'  style='{!! $t_table[$zone]["style_".$ref] !!}'>
                                        {!! html()->text($t_table[$zone]['nom'].'_'.$ref, $t_table[$zone]["value_".$ref])->attributes(['placeholder' => '', 'class' => 'form-control', 'readonly'])!!}
                                    </td>
                                <?php } ?>
                            </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
@endsection




@section('scripts')
    <script>
        $(document).ready(function() {
            $('#exercice_id').on('change', function() {
                location.href="{!! url('/stats/tdb_nbenfant/A/') !!}/"
                    +$('#exercice_id').val()+"/"+$('#mois_id').val();
            });


            $('#mois_id').on('change', function() {
                location.href="{!! url('/stats/tdb_nbenfant/A/') !!}/"
                    +$('#exercice_id').val()+"/"+$('#mois_id').val();
            });
        });
    </script>
@endsection

