@extends('layouts.layout')

@section('styles')
<!-- <link rel="stylesheet" href="http://cdn.oesmith.co.uk/morris-0.4.3.min.css"> -->
{!! Html::style('css/morris.css'); !!}
{!! Html::style('css/dataTables.tableTools.css') !!}
{!! Html::style('css/dataTables.bootstrap.css') !!}
{!! Html::style('css/jquery.dataTables.css') !!}
{!! Html::style('css/dataTables.editor.min.css') !!}


@stop

@section('content')

<div class="col-lg-12">
    <div class="row">
        <div class="col-md-2">
            <h1>Recettes d'importation</h1>
        </div>
    </div>
</div>

<div class="col-lg-12 col-lg-offset-2">
    <div class="row">
        <div class="col-lg-10">
              <ul class="nav nav-tabs">
                <li class='active'><a href="#" data-range='G'><span class="glyphicon glyphicon-stats"></span> Graphiques</a></li>
                <li><a href="#" data-range='D'><span class="glyphicon glyphicon-list"></span> Données</a></li>
              </ul> 
       </div>
    </div>
</div>

<h3>


</h3>    
<div class="col-md-12">
    <div class="row">





        <div class="col-md-2">
            <ul id='nav' class="nav nav-pills nav-stacked">
              <li class='active'><a href="#" data-range='1'>Total Par année</a></li>
              <li><a href="#" data-range='2'>Total Par bureau</a></li>
              <li><a href="#" data-range='3'>Détail des taxes</a></li>

              <li><a href="#" data-range='11'>Total Par année - B</a></li>
              <li><a href="#" data-range='21'>Détail des taxes - B</a></li>
            </ul>
         </div>

        <div class="col-md-10">
            <canvas id="cvs" width="600" height="500" !style="border: 1px solid #ccc">
                [No canvas support]
            </canvas>

            <div id='div_graph' >
                <div id="stats-container" style="height: 650px;"></div>
            </div>


            <div id='div_data'  >
                <h1></h1>
                <div  id="data_table" class="table-responsive">
                    <table id="_table" class="display"  cellspacing="0" width="100%"></table>
                </div>
            </div>
        </div>
</div>

@stop
@section('scripts')



{!! Html::script('js/jquery.dataTables.min.js') !!}
{!! Html::script('js/dataTables.tableTools.min.js') !!}
{!! Html::script('js/raphael-min.js') !!}
{!! Html::script('js/morris.min.js') !!}
{!! Html::script('js/spin.min.js') !!}

{!! Html::script('js/RGraph/libraries/RGraph.common.core.js') !!}
{!! Html::script('js/RGraph/libraries/RGraph.common.dynamic.js') !!}
{!! Html::script('js/RGraph/libraries/RGraph.common.tooltips.js') !!}
{!! Html::script('js/RGraph/libraries/RGraph.drawing.rect.js') !!}
{!! Html::script('js/RGraph/libraries/RGraph.hbar.js') !!}
{!! Html::script('js/RGraph/libraries/RGraph.bar.js') !!}
{!! Html::script('js/RGraph/libraries/RGraph.gantt.js') !!}
{!! Html::script('js/RGraph/libraries/RGraph.common.effects.js') !!}

<script>
    $(function () {

        // Define the area for the spinner
        var spinTarget = document.getElementById('stats-container');
        var rgraphTarget = document.getElementById('csv');

        // Create a function that will handle AJAX requests
        function requestData(numchart,chart) {
            // Activate the spinner
            var spinner = new Spinner().spin(spinTarget);
            var api="";

            //Morris
            if(numchart=="1") api="api_taxes";
            if(numchart=="2") api="api_taxes_bureau";
            if(numchart=="3") api="api_taxes_detail";

            //RGrpah
            if(numchart=="11") api="api_taxes";
            if(numchart=="31") api="api_taxes_detail";

            $.ajax({
                type: "GET",dataType: 'json',url: "../"+api, data: {  } //ex : days: days
            })
            .done(function (data) {
                if( (numchart<10)&&(chart!="") ) {
                    chart.setData(data);
                }
                else {
                    if(numchart=="11") RGraph_1(data);
                    if(numchart=="31") RGraph_2(data);
                }
            })
            .fail(function () { alert("error occured"); })
            .always(function () { spinner.stop(); });
        }

        //Choix d'un type Graph ou Data
        $('ul.nav-tabs a').click(function (e) {
            var el2 = $(this);
            typechart = el2.attr('data-range');
            el2.parent().addClass('active');
            el2.parent().siblings().removeClass('active');
            
            if($('.nav-stacked li.active a')) numchart=$('.nav-stacked li.active a').attr('data-range');

            if(typechart=="G") {
                $("#cvs").show();
                $("#div_graph").show();
                $("#div_data").hide();
            }

            if(typechart=="D") {
                $("#cvs").hide();
                $("#div_graph").hide();
                $("#div_data").show();
            }
        })



        //Choix du menu type de stats
        $('ul.nav-stacked a').click(function (e) {
            e.preventDefault();
            while (spinTarget.hasChildNodes()){ //Erase MORRIS GRAPH
                spinTarget.removeChild(spinTarget.lastChild);
            }
            if(rgraphTarget) {
                while (rgraphTarget.hasChildNodes()){ //Erase RGRAPH
                    rgraphTarget.removeChild(rgraphTarget.lastChild);
                }
            }
            
            var el = $(this);
            el.parent().addClass('active');
            el.parent().siblings().removeClass('active');

            //Si changement de type alors on repositionne sur Graph
             var el2 =  $('.nav-tabs li.active a');
            if(el2) mode=el2.attr('data-range');
            if(mode=='D') {
                el2.parent().siblings().addClass('active');
                el2.parent().removeClass('active');
                $("#div_data").hide();
            }

            var numchart="";
            if($('.nav-stacked li.active a')) numchart=$('.nav-stacked li.active a').attr('data-range');
            if(numchart>10) {
                $("#cvs").show();
                $("#div_graph").hide();
            } else  {
                $("#cvs").hide();
                $("#div_graph").show();
            }
            Graph(numchart);
            Data(numchart);
        })

        // Graph1 : Nb classes par epreuves
        function Graph(numgraph) {
            if(numgraph=="1") {
                var chart = Morris.Bar({
                    element: 'stats-container',
                    data: [0, 0], // Set initial data (ideally you would provide an array of default data)
                    xkey: 'annee', // Set the key for X-axis
                    ykeys: ['mt_taxes'], // Set the key for Y-axis
                    labels: ['Classes', 'SORN'], // Set the label when bar is rolled over
                    xLabelAngle: 60
                });
            }

            if(numgraph=="2") {
                var chart = Morris.Bar({
                    element: 'stats-container',
                    data: [0, 0], // Set initial data (ideally you would provide an array of default data)
                    xkey: 'annee', // Set the key for X-axis
                    ykeys: ['mt_taxes_W','mt_taxes_F'], // Set the key for Y-axis
                    labels: ['Wallis', 'Futuna'], // Set the label when bar is rolled over
                    xLabelAngle: 60
                });
            }

            if(numgraph=="3") {
                var chart = Morris.Bar({
                    element: 'stats-container',
                    data: [0, 0], // Set initial data (ideally you would provide an array of default data)
                    xkey: 'annee', // Set the key for X-axis
                    ykeys: ['mt_dd','mt_dp','mt_rsi','mt_te','mt_tica','mt_tich','mt_tict','mt_tpp','mt_tic','mt_tsa','mt_mill'], // Set the key for Y-axis
                    labels: ['DD','DP','RSI','TE','TICA','TICH','TICT','TPP','TIC','TSA','Mill.'], // Set the label when bar is rolled over
                    stacked: true,
                    xLabelAngle: 60
                });
            }

            if(numgraph=="11") {
                chart="";
            }
            requestData(numgraph,chart);
        }


        // GraphB : RGraph
        /*
        function GraphB(numgraph) {
            if(numgraph=="11") {
                var chart = new RGraph.Bar({
                    id: 'cvs',
                    data: [0, 0],
                    options: {
                        colors: ['Gradient(#4572A7:#66f)','Gradient(#AA4643:white)','Gradient(#89A54E:white)'],
                        shadow: {
                            offsetx: 1,
                            offsety: 1,
                            blur: 5
                        },
                        hmargin: 25,
                        gutter: {left: 45},
                        background: {grid: {vlines: false, border: false}},
                        axis: {color: '#ccc'},
                        noyaxis: true,
                        grouping: 'stacked',
                    }
                }).grow()
            }
            requestData(numgraph,chart);
        }
        */


        // Graph1 : RGraph
        function RGraph_1(data) {
            var data_x=new Array();
            var label_x=new Array();
            for(var i=0;i<data.length;i++) {
                data_x[i]=parseInt(data[i].mt_taxes);  
                label_x[i]=data[i].annee;
            }
            RGraph.Reset(document.getElementById('cvs'));
            var chart = new RGraph.Bar('cvs', data_x)
            .Set('labels', label_x)
            .Set('colors', ['Gradient(#4572A7:#66f)','Gradient(#AA4643:white)','Gradient(#89A54E:white)'])
            .Set('hmargin', 25)
            .Set('gutter', {left: 45})
            .Set('noyaxis', 'true')
            .Set('background', {grid: {vlines: false, border: false}})
            .Set('grouping', 'stacked')
            .Set('axis', {color: '#ccc'})
            .grow();
        }

        // Graph2 : RGraph
        function RGraph_2(data) {
            var data_x=new Array();
            var label_x=new Array();
            
            for(var i=0;i<data.length;i++) {
                //data_x[i]=[data[i].mt_dd,data[i].mt_dp,data[i].mt_rsi,data[i].mt_rsi
                //,data[i].mt_te,data[i].mt_tica,data[i].mt_tich,data[i].mt_tict
                //,data[i].mt_tpp,data[i].mt_tic,data[i].mt_tsa,data[i].mt_mill]; 
                data_x[i]=[
                parseInt(data[i].mt_dd),
                parseInt(data[i].mt_dp),
                parseInt(data[i].mt_rsi),
                parseInt(data[i].mt_rsi),
                parseInt(data[i].mt_te),
                parseInt(data[i].mt_tica),
                parseInt(data[i].mt_tich),
                parseInt(data[i].mt_tict),
                parseInt(data[i].mt_tpp),
                parseInt(data[i].mt_tic),
                parseInt(data[i].mt_tsa),
                parseInt(data[i].mt_mill)]; 
                
                label_x[i]=data[i].annee;
            }

            //data_x=[[5.33,2.33,3.32],[3.42,2.23,4.23],[4.23,3.23,4.99], [7.99,2.98,2.35], [2.75,1.02,5.24]];
            //label_x=['DD','DP','RSI','TE','TICA','TICH','TICT','TPP','TIC','TSA','Mill.'];

            RGraph.Reset(document.getElementById('cvs'));
            var chart = new RGraph.Bar('cvs', data_x)
            .Set('labels', label_x)
            .Set('colors', [
                'Gradient(#4572A7:#66f)',
                'Gradient(#AA4643:white)',
                'Gradient(#88CCFF:white)',
                'Gradient(#FF00AA:white)',
                'Gradient(#CC4422:white)',
                'Gradient(#88FF22:white)',
                'Gradient(#4400CC:white)',
                'Gradient(#448866:white)'

            ])
            .Set('hmargin', 25)
            .Set('gutter', ['left','45'])
            .Set('strokestyle', 'white')
            .Set('noyaxis', 'true')
            .Set('noxaxis', 'true')
            .Set('background',  ['grid', [['vlines','false'], ['border','false']]])
            .Set('axis', ['color','#ccc'])
            .Set('grouping','stacked')

            .draw();
        }

        // Graph
        function Data(numchart) {
            //Initialisation
            $('#_table').remove();    
            $('#data_table').html('<table width="100%" cellspacing="0" id="_table" class="display"></table>');

             if( (numchart=="1") || (numchart=="11") ) {
                $('#_table').dataTable( {
                        "bDestroy": true,
                        "bAutoWidth": false,"lengthChange": false,
                        "ajax": {"url": "../api_taxes_data","dataSrc": ""},
                        "bPaginate": false,"bInfo": true,"bFilter": true,"iDisplayLength":-1,
                        "oLanguage": {
                            "sZeroRecords": "Aucune ligne",
                            "sInfo": "Affichage de _START_ &agrave; _END_",
                            "sInfoEmpty": "0 enregistrements",
                            "sSearch":"Chercher"
                        },
                        "aoColumns": [
                                { "sTitle": "Année","sClass":"align-center" },
                                { "sTitle": "Montant Total des Taxes"  },
                            ],

                        "aoColumnDefs": [
                                { "sWidth": "20%", "aTargets": [ 0 ] },
                                { "aTargets": [ '_all' ], "bSortable": true }
                            ]
                    } );
            }

             if(numchart=="2") {
                $('#_table').dataTable( {
                        "bDestroy": true,
                        "bAutoWidth": false,"lengthChange": false,
                        "ajax": {"url": "../api_taxes_bureau_data","dataSrc": ""},
                        "bPaginate": false,"bInfo": true,"bFilter": true,"iDisplayLength":-1,
                        "oLanguage": {
                            "sZeroRecords": "Aucune ligne",
                            "sInfo": "Affichage de _START_ &agrave; _END_",
                            "sInfoEmpty": "0 enregistrements",
                            "sSearch":"Chercher"
                        },
                        "aoColumns": [
                                { "sTitle": "Année","sClass":"align-center" },
                                { "sTitle": "Wallis","sClass":"align-center" },
                                { "sTitle": "Futuna"  },
                            ],

                        "aoColumnDefs": [
                                { "sWidth": "20%", "aTargets": [ 0 ] },
                                { "sWidth": "40%", "aTargets": [ 1,2 ] },
                                { "aTargets": [ '_all' ], "bSortable": true }
                            ]
                    } );
            }

             if( (numchart=="3") || (numchart=="31") ) {
                $('#_table').dataTable( {
                        "bDestroy": true,
                        "bAutoWidth": false,"lengthChange": false,
                        "ajax": {"url": "../api_taxes_detail_data","dataSrc": ""},
                        "bPaginate": false,"bInfo": true,"bFilter": true,"iDisplayLength":-1,
                        "oLanguage": {
                            "sZeroRecords": "Aucune ligne",
                            "sInfo": "Affichage de _START_ &agrave; _END_",
                            "sInfoEmpty": "0 enregistrements",
                            "sSearch":"Chercher"
                        },
                        "aoColumns": [
                              { "sTitle": "Année","sClass": "active" },
                                { "sTitle": "DD"  },
                                { "sTitle": "DP"  },
                                { "sTitle": "RSI"  },
                                { "sTitle": "TE"  },
                                { "sTitle": "TICA"  },
                                { "sTitle": "TICH"  },
                                { "sTitle": "TICT"  },
                                { "sTitle": "TPP"  },
                                { "sTitle": "TIC"  },
                                { "sTitle": "TSA"  },
                                { "sTitle": "Mill"  },
                            ],
                            
                        "aoColumnDefs": [
                                { "sWidth": "7%", "aTargets": [ 0 ] },
                                { "aTargets": [ '_all' ], "bSortable": true }
                            ],

                        "fnRowCallback": function( nRow, aData, iDisplayIndex, iDisplayIndexFull ) {
                            /* numbers less than or equal to 0 should be in red text */
                            if ( parseFloat(aData[4]) <= 0 ) {
                                jQuery('td:eq(4)', nRow).addClass('redText');
                            }
                            return nRow;
                        },


                    } );
            }

        }

        $("#div_graph").show();
        $("#cvs").hide();
        $("#div_data").hide();
        Graph(1);
        Data(1);

    } );
/*

            .Set('key', [
                    ['self',['DD','DP','RSI','TE','TICA','TICH','TICT','TPP','TIC','TSA','Mill.']],
                    ['position','gutter'],
                    ['interactive','true']
                ])

*/
</script>
@stop