@extends('layouts.layout')

@section('styles')
<!-- <link rel="stylesheet" href="http://cdn.oesmith.co.uk/morris-0.4.3.min.css"> -->
{!! Html::style('css/morris.css'); !!}
{!! Html::style('css/dataTables.tableTools.css') !!}
{!! Html::style('css/dataTables.bootstrap.css') !!}
{!! Html::style('css/jquery.dataTables.css') !!}
{!! Html::style('css/dataTables.editor.min.css') !!}
@stop

@section('content')

<div class="col-lg-12">
    <div class="row">
        <div class="col-md-2">
            <h1>Valeurs importées</h1>
        </div>
    </div>
</div>

<div class="col-lg-12 col-lg-offset-2">
    <div class="row">
        <div class="col-lg-10">
              <ul class="nav nav-tabs">
                <li><a href="#" data-range='G'><span class="glyphicon glyphicon-stats"></span> Graphiques</a></li>
                <li><a href="#" data-range='D'><span class="glyphicon glyphicon-list"></span> Données</a></li>
              </ul> 
       </div>
    </div>
</div>

<h3>


</h3>    
<div class="col-md-12">
    <div class="row">
        <div class="col-md-2">
            <ul id='nav' class="nav nav-pills nav-stacked">
              <li class='active'><a href="#" data-range='1'>Total Par année</a></li>
              <li><a href="#" data-range='2'>Détail par position tarifaire</a></li>
            </ul>
         </div>

        <div id='div_graph' class="col-md-10">
            <div id="stats-container" style="height: 650px;"></div>
        </div>

        <div id='div_data'  class="col-md-10">
            <h1></h1>
            <div  id="data_table" class="table-responsive">
                <table id="_table" class="display"  cellspacing="0" width="100%"></table>
            </div>
        </div>
</div>

@stop
@section('scripts')



{!! Html::script('js/jquery.dataTables.min.js') !!}
{!! Html::script('js/dataTables.tableTools.min.js') !!}
{!! Html::script('js/raphael-min.js') !!}
{!! Html::script('js/morris.min.js') !!}
{!! Html::script('js/spin.min.js') !!}


<script>
    $(function () {

        // Define the area for the spinner
        var spinTarget = document.getElementById('stats-container');

        // Create a function that will handle AJAX requests
        function requestData(numchart,chart) {
            // Activate the spinner
            var spinner = new Spinner().spin(spinTarget);
            var api="";

            if(numchart=="1") api="api_valeur";
            if(numchart=="2") api="api_valeur_detail";

            $.ajax({
                type: "GET",dataType: 'json',url: "../"+api, data: {  } //ex : days: days
            })
                .done(function (data) {
                    if(chart!="") chart.setData(data);
                })
                .fail(function () { alert("error occured"); })
                .always(function () { spinner.stop(); });
        }


        $('ul.nav-tabs a').click(function (e) {
            var el =  $('ul.nav-stacked a');
            var el2 = $(this);
            typechart = el2.attr('data-range');
            el2.parent().addClass('active');
            el2.parent().siblings().removeClass('active');
            
            if($('.nav-stacked li.active a')) numchart=$('.nav-stacked li.active a').attr('data-range');

            if(typechart=="G") {
                $("#div_graph").show();
                $("#div_data").hide();
            }

            if(typechart=="D") {
                $("#div_graph").hide();
                $("#div_data").show();
            }
        })

        $('ul.nav-stacked a').click(function (e) {
            e.preventDefault();
            while (spinTarget.hasChildNodes()){
                spinTarget.removeChild(spinTarget.lastChild);
            }
            var el = $(this);
            el.parent().addClass('active');
            el.parent().siblings().removeClass('active');

            var numchart="";
            if($('.nav-stacked li.active a')) numchart=$('.nav-stacked li.active a').attr('data-range');
            Graph(numchart);
            Data(numchart);
        })

        // Graph1 : Nb classes par epreuves
        function Graph(numgraph) {
            if(numgraph=="1") {
                var chart = Morris.Bar({
                    element: 'stats-container',
                    data: [0, 0], // Set initial data (ideally you would provide an array of default data)
                    xkey: 'annee', // Set the key for X-axis
                    ykeys: ['Montant'], // Set the key for Y-axis
                    labels: ['Montant', 'SORN'], // Set the label when bar is rolled over
                    xLabelAngle: 60
                });
            }

            if(numgraph=="2") {
                var chart = Morris.Bar({
                    element: 'stats-container',
                    data: [0, 0], // Set initial data (ideally you would provide an array of default data)
                    xkey: 'nomenclature', // Set the key for X-axis
                    ykeys: ['Montant'], // Set the key for Y-axis
                    labels: ['Valeur importée'], // Set the label when bar is rolled over
                    stacked: true,
                    xLabelAngle: 60,
                });
            }

            //spinTarget.style.height = "450px";
            requestData(numgraph,chart);
        }


        // Graph
        function Data(numchart) {
            //Initialisation
            $('#_table').remove();    
            $('#data_table').html('<table width="100%" cellspacing="0" id="_table" class="display"></table>');

             if(numchart=="1") {
                $('#_table').dataTable( {
                        "bDestroy": true,
                        "bAutoWidth": false,"lengthChange": false,
                        "ajax": {"url": "../api_valeur_data","dataSrc": ""},
                        "bPaginate": false,"bInfo": true,"bFilter": true,"iDisplayLength":-1,
                        "oLanguage": {
                            "sZeroRecords": "Aucune ligne",
                            "sInfo": "Affichage de _START_ &agrave; _END_",
                            "sInfoEmpty": "0 enregistrements",
                            "sSearch":"Chercher"
                        },
                        "aoColumns": [
                                { "sTitle": "Année","sClass":"align-center" },
                                { "sTitle": "Valeur importée"  },
                            ],

                        "aoColumnDefs": [
                                { "sWidth": "20%", "aTargets": [ 0 ] },
                                { "aTargets": [ '_all' ], "bSortable": true }
                            ]
                    } );
            }

             if(numchart=="2") {
                $('#_table').dataTable( {
                        "bDestroy": true,
                        "bAutoWidth": false,"lengthChange": false,
                        "ajax": {"url": "../api_valeur_detail_data","dataSrc": ""},
                        "bPaginate": false,"bInfo": true,"bFilter": true,"iDisplayLength":-1,
                        "oLanguage": {
                            "sZeroRecords": "Aucune ligne",
                            "sInfo": "Affichage de _START_ &agrave; _END_",
                            "sInfoEmpty": "0 enregistrements",
                            "sSearch":"Chercher"
                        },
                        "aoColumns": [
                              { "sTitle": "Nomenclature","sClass": "active" },
                                { "sTitle": "Montant"  },

                            ],
                            
                        "aoColumnDefs": [
                                { "sWidth": "90%", "aTargets": [ 0 ] },
                                { "aTargets": [ '_all' ], "bSortable": true }
                            ],

                    } );
            }

        }

        $("#div_graph").show();
        $("#div_data").hide();
        Graph(1);
        Data(1);

    } );

</script>
@stop