@extends('layouts.layout')

@section('styles')
<!-- <link rel="stylesheet" href="http://cdn.oesmith.co.uk/morris-0.4.3.min.css"> -->
{{HTML::style('css/morris.css');}}
@stop

@section('content')
{!! Html::script('js/RGraph/libraries/RGraph.common.core.js') !!}
{!! Html::script('js/RGraph/libraries/RGraph.hbar.js') !!}
{!! Html::script('js/RGraph/libraries/RGraph.gantt.js') !!}
{!! Html::script('js/RGraph/libraries/RGraph.common.effects.js') !!}

<div class="col-lg-10">
    <div class="row">
        <div class="col-md-3">
            <h1>Statistiques</h1>
        </div>
        <div class="col-md-6">
            
              <ul class="nav nav-tabs">
                <li class="active"><a href="#"  data-range='G'>Graphique</a></li>
                <li><a href="#"  data-range='D'>Données</a></li>
              </ul> 
       </div>
    </div>
</div>
    
<div class="col-lg-10">
    <div class="row">
        <div class="col-md-3">
            <ul class="nav nav-pills nav-stacked">
                <li><a href="#" data-range='1'>Total par année</a></li>
                <li><a href="#" data-range='2'>Total par taxes</a></li>            
            </ul>
         </div>

        <div class="col-md-9">
            <canvas id="cvs" name="cvs"  width="800" height="1000">[No canvas support]</canvas>
        </div>
    </div>
</div>



@stop


@section('scripts')
    <script>
        var spinTarget = document.getElementById('cvs');

        $('ul.nav-stacked a').click(function (e) {
            e.preventDefault();
            while (spinTarget.hasChildNodes()){
                spinTarget.removeChild(spinTarget.lastChild);
            }
            var el = $(this);
            numchart = el.attr('data-range');

            RGraph.ObjectRegistry.Clear();

            if(numchart=="1") Graph1();
            if(numchart=="2") Graph2();

            // Make things pretty to show which button/tab the user clicked
            el.parent().addClass('active');
            el.parent().siblings().removeClass('active');
        })

        $('ul.nav-tabs a').click(function (e) {
            e.preventDefault();
            while (spinTarget.hasChildNodes()){
                spinTarget.removeChild(spinTarget.lastChild);
            }
            var el =  $('ul.nav-stacked a');
            var el2 = $(this);
            typechart = el2.attr('data-range');
            numchart = el.attr('data-range');
            
            alert(typechart+" , "+numchart);

            // Make things pretty to show which button/tab the user clicked
            el2.parent().addClass('active');
            el2.parent().siblings().removeClass('active');
        })



        // Graph1 : Nb classes par epreuves
        function Graph1() {
            $.ajax({
                type: "GET",
                dataType: 'json',
                url: "../api_epreuves2", 
                data: {  } //days: days
            })

            .done(function (data) {
                var data_x=new Array();
                var label_x=new Array();
                for(var i=0;i<data.length;i++) {
                    data_x[i]=parseInt(data[i].nb_classes);  
                    label_x[i]=data[i].nom;
                }
                var chart = new RGraph.HBar({
                    id: 'cvs',
                    data: data_x,
                    options: {
                        colors: ['Gradient(white:#3366CC:#3366CC)'],
                        labels: label_x,
                        grouping: 'grouped',
                        numyticks: 5,
                        gutter: {left: 200,right: 15},
                        shadow: {self: true,color: '#bbb'},
                        vmargin: 4,
                    }
                }).grow()
            })

            .fail(function () {
                // If there is no communication between the server, show an error
                alert("error occured");
            })

            .always(function () {
                // No matter if request is successful or not, stop the spinner
                //spinner.stop();
            });
        }

   

        // Graph2 : Nb classes par epreuves
        function Graph2() {
            $.ajax({
                type: "GET",
                dataType: 'json',
                url: "../api_protocoles2", 
                data: {  } //days: days
            })

            .done(function (data) {
                var data_x=new Array();
                var max_classe=0;
                for(var i=0;i<data.length;i++) {
                    var reste=parseInt(data[i].reste);
                    var total=parseInt(data[i].total);
                    var prc=Math.round(100/total*reste, 1);
                    data_x[i]=new Array(0,reste,prc,data[i].rne);
                    if(total>max_classe) max_classe=total;
                }

                var chart2 = new RGraph.Gantt({
                    id: 'cvs',
                    data: data_x,
                    options: {
                        gutter: {left: 250,right: 15},
                        xmax: max_classe+1,
                        text: {font : 'Bold 19pt Arial'},
                        shadow: {self: true,color: '#bbb'},
                        vmargin: 4,
                    }
                }).grow()
            })

            .fail(function () {
                // If there is no communication between the server, show an error
                alert("error occured");
            })

            .always(function () {
                // No matter if request is successful or not, stop the spinner
                //spinner.stop();
            });
        }    

    </script>
@stop