@extends('layouts.dash')

@section('title') Banques @stop
@section('title_card') Banques @stop
@section('subtitle_card',"")
@section('content')
    @if (Session::has('message'))
        <div class="alert alert-warning">{!! Session::get('message') !!}</div>
    @endif

    @if ($errors)
        @foreach ($errors->all() as $error)
            <div class='bg-danger alert'>{!! $error !!}</div>
        @endforeach
    @endif

    @if (Session::has('success'))
        <div class="alert alert-success">{!! \Session::get('success') !!}</div>
    @endif

    <div class="card">
        <div class="card-header">
            <h1><i class="fa fa-employeurs"></i>Banques</h1>
        </div>
        <div class="card-body">
        <table id="_table" class="table table-condensed table-bordered">
            <thead>
                <tr>
                    <th>Nom</th>
                    <th>Agence</th>
                    <th>BIC</th>
                    <th>Ville</th>
                    <th>Tel1</th>
                    <th>Contact1</th>
                    <th>Tel2</th>
                    <th>Contact2</th>
                    <th>NbBenef</th>
                    <th>NbEmpl.</th>
                    <th>NbVers.</th>
                    <th width='1px'></th>
                </tr>
            </thead>
            <tbody>
                @foreach ($banques as $banque)
                <tr>
                    <td>
                        <a href="{{ url('banques/'.$banque->id) }}" style="margin-right: 3px;">
                            {!! $banque->nom !!}
                            @if(!$banque->active)
                                <br/><span class="right badge badge-danger">Inactive</span>
                            @endif
                        </a>
                    </td>
                    <td nowrap>{!! $banque->agence !!}</td>
                    <td nowrap>{!! $banque->bic !!}</td>
                    <td nowrap>{!! $banque->ville !!}</td>
                    <td nowrap>{!! $banque->tel !!}</td>
                    <td nowrap>{!! $banque->contact !!}</td>
                    <td nowrap>{!! $banque->tel2 !!}</td>
                    <td nowrap>{!! $banque->contact2 !!}</td>
                    <td nowrap align="center">{!! $banque->NbBeneficiaires !!}</td>
                    <td nowrap align="center">{!! $banque->NbEmployeurs !!}</td>
                    <td nowrap align="center">{!! $banque->NbVersements !!}</td>

                    <td nowrap>
                    @if($user->can("BQE_MAJ") || $user->HasRole("ADMINISTRATEUR"))
                        <a href="{{ url('banques/'.$banque->id) }}" class="btn btn-warning pull-left" style="margin-right: 3px;"><span class=' fas fa-eye'></span></a>
                    @endif

                    </td>
                </tr>
                @endforeach
            </tbody>
        </table>
        @if($user->can("BQE_AJO") || $user->HasRole("ADMINISTRATEUR"))
             <div>
                <h4><a href="{{ url('banques/create') }}" class="btn btn-success">Ajouter une banque</a></h4>
            </div>
        @endif
    </div>
@endsection

@section('scripts')
    @include("forms.scripts_datatable_btn")
@endsection

