@extends('layouts.dash')
@section('title') Bénéficiaire @stop
@section('title_card') Mise à jour d'une fiche bénéficiaire @stop


@section('content')
    @if ($errors)
        @foreach ($errors->all() as $error)
            <div class='bg-danger alert'>{!! $error !!}</div>
        @endforeach
    @endif
    <div class="card card-success">
        <div class="card-header">
            <h2>Bénéficiaire <span style='color:darkblue'>{!! $beneficiaire->nomcomplet !!}</span></h2>
        </div>
        <div class='card-body'>
            {{ html()->modelForm($beneficiaire, 'PUT', url('beneficiaires/' . $beneficiaire->id))->open() }}
                {{ html()->hidden( 'benef_type',$benef_type) }}
                @include("tiers.beneficiaires.content")
            {{ html()->closeModelForm() }}
        </div>
    </div>
@stop

@section('styles')
    <!-- FancyBox -->
    <link media="all" type="text/css" rel="stylesheet" href="{{ url('css/jquery.fancybox.css') }}">
    <link media="all" type="text/css" rel="stylesheet" href="{{ url('css/jquery.fancybox-buttons.css') }}">
@stop

@section('scripts0')
    <script src="{{ url('js/jquery.fancybox.js') }}"></script>
    <script src="{{ url('js/magicsuggest.js') }}"></script>
@stop

@section('scripts')
    @include('tiers.beneficiaires.scripts_beneficiaire');
    @include('tiers.beneficiaires.scripts_beneficiaire_tables');
@stop

