@extends('layouts.dash')
@section('title') Bénéficiaires @stop
@section('title_card',"Bénéficiaires")
@section('subtitle_card',"Liste")

@section('content')
    @if (Session::has('message'))
        <div class="alert alert-warning">{!! Session::get('message') !!}</div>
    @endif

    @if ($errors)
        @foreach ($errors->all() as $error)
            <div class='bg-danger alert'>{!! $error !!}</div>
        @endforeach
    @endif

    @if (Session::has('success'))
        <div class="alert alert-success">{!! \Session::get('success') !!}</div>
    @endif


    <div class="card">
        <div class="card-header">
            <div class="row">
                <div class="col-md-5">
                    {!! html()->label( 'Avec le statut :','') !!}
                    {!! html()->select('select_benef_type',$liste_beneftype,$select_benef_type)->attributes(['id' => 'select_benef_type','class' => 'form-control'])  !!}
                </div>
                @if($user->can("BEN_AJO") || $user->HasRole("ADMINISTRATEUR"))
                    <div class="col-md-5 ">
                        {!! html()->label( '&nbsp;','') !!}<br/>
                        {!! html()->a(url('beneficiaires_add/'.$benef_type),"Ajouter un bénéficiaire")->attributes(['class' => 'btn btn-success'])  !!}
                    </div>
                @endif
            </div>
        </div>
        <div class="card-body">
            <table id="_table" style="background-color:white;width:100%" class="table table-striped table-bordered table-hover">
                <thead>
                    <tr>
                        <th width='1px'>Id</th>
                        <th >Nom</th>
                        <th width='1px'>Date de naissance</th>
                        <th width='1px'>NbEnf.</th>
                        <th >Conjoint</th>
                        <th >Employeur</th>
                        <th >Montant Ret.</th>
                        <th >Montant CSR</th>
                        <th width='1px'>Statut</th>
                        <th width='1px'>Création</th>
                        @if($benef_type=="A")
                            <th width='1px'>AyantDroit</th>
                            @endif
                        @if($benef_type=="RET")
                            <th width='1px'>TypeRet</th>
                        @endif
                    </tr>
                </thead>

                <tbody>
                    @foreach ($beneficiaires as $beneficiaire)
                        <tr>
                            <td>{!! str_pad($beneficiaire->id, 5, "0", STR_PAD_LEFT) !!}</td>
                            <td>
                                <a href="{!! url('beneficiaires_filtre/'.$beneficiaire->id.'/'.$benef_type) !!}">
                                    {!! $beneficiaire->nom_complet !!}
                                </a>
                            </td>
                            <td>{!! $beneficiaire->datenaiss !!}</td>
                            <td align="center">{!! $beneficiaire->nb_enf."/".$beneficiaire->nb_enf_tot !!}</td>
                            <td>{!! $beneficiaire->nom_conjoint !!}</td>
                            <td>{!! $beneficiaire->employeur_court !!}</td>
                            <td align="center">{!! $beneficiaire->ret_montant !!}</td>
                            <td align="center">{!! $beneficiaire->csr_montant !!}</td>
                            <td align="center">{!! $beneficiaire->statut !!}</td>
                            <td align="center" title="{!! $beneficiaire->created_at !!}">{!! substr($beneficiaire->created_at,0,10) !!}</td>
                            @if($benef_type=="A")
                            <td align="center">{!! ($beneficiaire->ayantdroit)?"OUI":"NON" !!}</td>
                            @endif
                            @if($benef_type=="RET")
                                <td align="center">{!! $beneficiaire->ret_type !!}</td>
                            @endif
                        </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
    </div>
@endsection


@section('scripts')
    <script>
        $(function () {
            $('#select_benef_type').change(function() {select_filtre();});

            function select_filtre() {
                var opt=$('#select_benef_type').val();
                if(opt=="") opt=0;
                url="{!! url('beneficiaires_liste/'.$benef_type) !!}/"+opt;
                location.href=url;
            }
        });
    </script>

    @include("forms.scripts_datatable_btn")
@endsection
