@php
    $t_mois=["jan"=>"01","fev"=>"02","mar"=>"03","avr"=>"04","mai"=>"05",
        "jun"=>"06","jui"=>"07","aou"=>"08","sep"=>"09","oct"=>"10","nov"=>"11","dec"=>"12"];
@endphp
<div class="callout callout-warning">
    <div class="form-group row">
        <div class="col-md-12">
            <a href="{!! url('salaire_imprime/'.$beneficiaire->id) !!}" class="btn btn-sm btn-info" target="_blank" style="text-decoration:none;color:white" >Imprimer</a>
            <a href="{!! url('/salaire_liquidation/'.$beneficiaire->id) !!}" id=''  class="btn btn-sm  btn-info" target="_blank" style="text-decoration:none;color:white" >Feuille de Liquidation</a>
            @if( ($beneficiaire->sonum>0) && ($user->can("SAL_AJO") || $user->HasRole("ADMINISTRATEUR") ) )
                <a href="{!! url('salaire_annee/'.$beneficiaire->sonum.'/'.$beneficiaire->id) !!}" 
                    class="btn btn-sm btn-success" style="text-decoration:none;color:white"
                    target="_blank">Gestion des Salaires</a>
            @endif 
        </div>
    </div>

    <div class="form-group row">
        <div class="col-md-12">
            <table id="_table_salaire" class="table table-condensed table-striped table-bordered">
                <thead>
                    <tr>

                        <th width='1px'>N°</th>
                        <th >Employeur</th>
                        <th width='1px'>Année</th>
                        @foreach($t_mois as $mois=>$nummois)
                            <th width='1px'  align='center'>{!! $mois !!}</th>
                        @endforeach
                        <th width='1px'>&nbsp;</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($salaires as $salaire)
                    <tr>
                        <td>{!! $salaire->id !!}</td>
                        <td >{!! $salaire->employeur_nom !!}</td>
                        <td align="center">{!! $salaire->annee !!}</td>
                        @foreach($t_mois as $mois=>$nummois)
                            @php
                                $class='success';$style='';
                                $class=isset($t_salaires_ref[$salaire->annee.'-'.$nummois])?$class:'';
                                if($salaire->getIsHorsPlafond($mois)) $style="color:red;";
                                $montant_salaire=$salaire->{$mois};
                                if($salaire->getSuspendu($mois)) {
                                    $style.="background-color:darkgrey;font-size:.9em";
                                    $montant_salaire="SUSPENDU";
                                }
                            @endphp
                            <td  class='{!! $class !!}' align='right' style='{!! $style !!}'>
                                {!! $montant_salaire !!}
                            </td>
                        @endforeach
                        <td nowrap align='right'></td>
                    </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
    </div>

    <div class="form-group">
        <div class='col-md-8'>
            <?php
                $t=explode('~',$beneficiaire->MoyenneMeilleursSalaires);
            ?>
            {!! html()->label('Le salaire moyen des '.$t[1].' meilleurs mois est de : '.number_format($t[0],0,","," ")." CFP",'best_sal') !!}
        </div>
    </div>


</div>
