@extends('layouts.dash')

@section('title') Bénéficiaire @stop
@section('title_card') Consultation d'une fiche Bénéficiaire @stop

@section('content')
    <div class="card card-success">
        <div class="card-header">
            <h2>Bénéficiaire <span style='color:darkblue'>{!! $beneficiaire->nomcomplet !!}</span></h2>
        </div>
        <div class='card-body'>
            {{ html()->modelForm($beneficiaire)->open() }}
                {{ html()->hidden( 'benef_type',$benef_type) }}
                @include('tiers.beneficiaires.content')
                <input type="hidden" value="{{ $onglet_actif }}" id="tab_inplace" />
            {{ html()->closeModelForm() }}
        </div>
        <div class='card-footer'>
            @if($beneficiaire->IsSupprimable && ($user->hasRole("ADMINISTRATEUR") || $user->can("CRE_SUP")))
                {{ html()->form('DELETE', url('/beneficiaires/'. $beneficiaire->id."?benef_type=".$benef_type))->open() }}
                &nbsp;{!! html()->button('Supprimer')->value('Supprimer')->type('submit')
                    ->attributes(['onclick'=>'if(!confirm("Voulez-vous vraiment supprimer ce bénéficiaire ?")) return false;','class' => 'btn btn-danger']) !!}
                {{ html()->form()->close() }}
            @endif
        </div>
    </div>
@stop

@section('styles')
    <!-- FancyBox -->
    <link media="all" type="text/css" rel="stylesheet" href="{{ url('css/jquery.fancybox.css') }}">
    <link media="all" type="text/css" rel="stylesheet" href="{{ url('css/jquery.fancybox-buttons.css') }}">
@stop

@section('scripts0')
    <script src="{{ url('js/jquery.fancybox.js') }}"></script>
    <script src="{{ url('js/magicsuggest.js') }}"></script>

    <script type="text/javascript">
        //EDITIONS
        $(function() {
            $("#imprimer").click(function(){
                var radioValue = $("input[name='optionsRadios']:checked").val();
                var annee = ($("#ret_ann_annee").val()?$("#ret_ann_annee").val():{!! date('Y')-1; !!});
                if(radioValue){
                    url="{!! url('attestation_edition/'.$beneficiaire->id.'/'.$benef_type) !!}"+"/"+radioValue+"/"+annee;
                    window.open(url,'_blank');
                }
                return;
            });
        });
    </script>
@stop

@section('scripts')
    <script type="text/javascript">
        $(function () {
            $('.nav-item a').click(function(){
                var tab = $(this).attr("href").replace("#","");
                $('#tab_inplace').val(tab);
            })

            $('#mdyTab').click(function() {
                $('a[data-toggle="tab"]').bind('click', function (e) {
                    e.preventDefault();
                    var tab = $(this).attr("href").replace("#","");
                    $('#tab_inplace').val(tab);
                });
            });

            $('#btn_modifier').click(function() {
                var onglet=$('#tab_inplace').val();;
                var url="{!! url('beneficiaires_filtre/'.$beneficiaire->id).'/'.$benef_type !!}"+"/"+onglet+"/edit";
                location.href=url;
            });
        });
    </script>
    @include('tiers.beneficiaires.scripts_beneficiaire');
    @include('tiers.beneficiaires.scripts_beneficiaire_tables');
@stop


