

@if($mode!="create")
    <div class="form-group row">
        <div class="col-md-4">
            <div class="input-group mb-3">
                <div class="input-group-prepend">
                    <span class="input-group-text">N°</span>
                </div>
                {!! html()->text('num_creancier', ($mode!="show")?str_pad($creancier->num_creancier, 5, "0", STR_PAD_LEFT):$creancier->num_creancier)
                    ->placeholder("Numéro de créancier")
                    ->attributes([($mode=="show"?'disabled':''), 'class' => 'form-control']) !!}
            </div>
        </div>
    </div>
@endif

<div class="form-group row" >
    <div class="col-md-5">
        {!! html()->label('Nom','nom') !!}
        {!! html()->text('nom', null)->placeholder("Nom")
            ->attributes([($mode=="show"?'disabled':''), 'class' => 'identifiants form-control']) !!}
    </div>

    <div class="col-md-4">
        {!! html()->label('Prénom','prenom') !!}
        {!! html()->text('prenom', null)->placeholder("Prénom")
            ->attributes([($mode=="show"?'disabled':''), 'class' => 'identifiants form-control']) !!}
    </div>

    <div class="col-md-3">
        {!! html()->label( 'Date de naissance','datepicker_datenaiss') !!}
        <div class='input-group date' id='datepicker_datenaiss'>
            {!! html()->text('datenaiss', null)
                ->placeholder('Date')->attributes([($mode=="show"?'disabled':''),'class' => 'form-control']) !!}
            <span class='input-group-addon'></span>
        </div>
    </div>
</div>



<div class="form-group row callout callout-warning">
    <div class="col-md-2">
        {!! html()->label( 'N°mandat','idmandat') !!}
        {!! html()->text('idmandat', (isset($mandat->id)?$mandat->id:null))
            ->placeholder("Numéro de mandat")
            ->attributes([( ($mode=="edit") && (!isset($frame) || !$frame) )?'':'readonly', 'class' => 'form-control']) !!}
    </div>
    <div class="col-md-10">
        {!! html()->label( 'N°Imputation','idimp_mdt') !!}
        {!! html()->select('idimp_mdt',$imputations,null)
                ->placeholder('A définir')
                ->attributes([($mode=="show"?'disabled':''),'class' => 'form-control'])  !!}
    </div>
</div>


<div class="form-group row callout callout-danger">
    <div class="col-md-4">
        {!! html()->label( 'Banque','bqcle_creancier') !!}
        {!! html()->select('bqcle_creancier',DB::table('banques')->orderby(db::raw("nom"))->pluck(db::raw("CONCAT(id,' ',nom) as nom"), 'id')->toArray(),null)
                ->placeholder('A définir')
                ->attributes([($mode=="show"?'disabled':''),'class' => 'form-control'])  !!}

    </div>
    <div class="col-md-4">
        {!! html()->label( 'Compte','compte') !!}
        {!! html()->text('compte', null)->placeholder("Compte")->attributes([($mode=="show"?'disabled':''), 'class' => 'form-control']) !!}
    </div>
    <div class="col-md-2">
        {!! html()->label( 'Montant','montant') !!}
        {!! html()->text('montant', null)->placeholder("Montant")->attributes([($mode=="show"?'disabled':''), 'class' => 'form-control']) !!}
    </div>
    <div class="col-md-2">
        {!! html()->label( 'Type&nbsp;de&nbsp;paiement','typepmt') !!}
        {!! html()->select('typepmt',['BAN'=>'Banque','ESP' => 'Espèces','CHQ' => 'Chèque','TRE' => 'Trésor'],null)
                ->placeholder('A définir')
                ->attributes([($mode=="show"?'disabled':''),'class' => 'form-control'])  !!}
    </div>
</div>


<div class='form-group row'>
    <div class="col-md-12">
        {!! html()->label( 'Observations','obs') !!}
        {!! html()->textarea('obs', null)->placeholder('Observations')
            ->attributes([($mode=="show"?'disabled':''), 'class' => 'form-control', 'rows'=>'2']) !!}
    </div>
</div>

@if(isset($frame) && $frame)
    <div class='form-group'>
        @if($mode=="show")
            @if($user->hasRole("ADMINISTRATEUR") || $user->can("CRE_MAJ"))
                @if(!$frame)
                    <a class="btn btn-primary" href="{!! url('/creanciers/'.$creancier->id.'/edit') !!}">Modifier</a>
                @endif
            @endif
        @else
            {!! html()->button('Enregistrer')->value('Enregistrer')->type('submit')->attributes(['class' => 'btn btn-primary']) !!}
        @endif
        @if(!$frame)
            <a class="btn btn-warning"  href="{!! url('creanciers') !!}">Retour</a>
        @endif
    </div>
@else
    @if( ($mode=="show")&& (isset($mandat->id)) && ($creancier->IsModifiable && ($user->hasRole("ADMINISTRATEUR") || $user->can("CRE_MAJ"))) )
        <a class="btn btn-primary" href="{!! url('creancier_edit_avec_mandat/'.$creancier->id.'/'.$mandat->id) !!}" id="btn_modifier">Modifier</a>
    @endif
@endif



