@extends('layouts.dash'.($frame?'_pop':''))
@section('title') Creancier @stop

@section('content')
    @if (Session::has('message'))
        <div class="alert alert-success">{{ Session::get('message') }}</div>
        <script>
            parent.location.reload();
            parent.jQuery.fancybox.close();
        </script>
    @else
        @if ($errors)
            @foreach ($errors->all() as $error)
                <div class='bg-danger alert'>{!! $error !!}</div>
            @endforeach
        @endif
        <div class="card card-info">
            <div class="card-header">
                <h2>Creancier : <small>{{ $creancier->NomComplet }}</small></h2>
            </div>
            <div class='card-body'>
                {{ html()->modelForm($creancier, 'PUT', url('creanciers/' . $creancier->id))->open() }}
                    <input type="hidden" name="mode_frame" id="mode_frame" value="{!! $frame !!}">
                    <input type="hidden" name="id" id="id" value="{!! $creancier->id !!}">
                    @include("tiers.creanciers.content")
                {{ html()->closeModelForm() }}
            </div>
        </div>
    @endif
@stop

@section('scripts0')
    <script type="text/javascript">
        $(function () {
            $('#datepicker_datenaiss').datepicker({
                format: "dd/mm/yyyy",
                language: "fr",
                autoclose: true
            });
        });
    </script>
@stop
