@extends('layouts.dash')

@section('title') Créanciers @stop
@section('title_card') Créanciers @stop
@section('subtitle_card',"Liste complète")
@section('content')
    <div class="card">
        @if (Session::has('message'))
            <div class="alert alert-warning">{!! Session::get('message') !!}</div>
        @endif

        <div class="card-header">
            <div class="form-group row">
                <div class='col-md-3'>
                    {!! html()->label('Années du mandat :','annes') !!}
                    {!! html()->select('exercice')->options($exercices)
                        ->value($exercice)
                        ->placeholder('Choisir un exercice')
                        ->attributes(['class' => 'form-control','id' => 'select_exercice'])  !!}
                </div>
            </div>
        </div>

        <div class="card-body">
            <table id="_table" class="table table-condensed table-striped table-hover table-bordered">
                <thead>
                    <tr>
                        <th width='1%' nowrap>N°</th>
                        <th >Nom</th>
                        <th width='1%'>Compte</th>
                        <th width='1%'>Montant</th>
                        <th width='1%'>IdMandat</th>
                        <th width='1%'>DateMandat</th>
                        <th width='1%'>TypePmt</th>
                        <th width='1%'>IdImputation</th>
                    </tr>
                </thead>

                <tbody>
                    @foreach ($creanciers as $creancier)
                    <?php
                        $imputation=App\Models\Imputation::find($creancier->id);
                        $mandat=App\Models\Mandat::find($creancier->idmandat);
                    ?>
                    <tr>
                        <td>{!! str_pad($creancier->id,5,'0',STR_PAD_LEFT) !!}</td>
                        <td>
                            @if($user->can("CRE_VISU") || $user->HasRole("ADMINISTRATEUR"))
                                @if($origine=='M') 
                                    <a href="{!! url('creanciers_mandat_show/'.$creancier->id)!!}" style="margin-right: 3px;">
                                @else
                                    <a href="{!! url('creanciers/'.$creancier->id)!!}" style="margin-right: 3px;">
                                @endif
                            @endif
                                {!! $creancier->nomcomplet !!}
                            @if($user->can("CRE_VISU") || $user->HasRole("ADMINISTRATEUR"))
                                </a>
                            @endif
                        </td>
                        <td>{!! $creancier->Banque !!}<br/>{!! $creancier->compte !!}</td>
                        <td align="right">{!! $creancier->montant !!}</td>
                        <td>
                            @if($user->can("MDT_VISU") || $user->HasRole("ADMINISTRATEUR"))
                            <a href="{!! url('mandats/'.$creancier->idmandat)!!}" class="various fancybox.iframe " style="margin-right: 3px;">
                                {!! str_pad($creancier->idmandat,6,'0',STR_PAD_LEFT) !!}
                            </a>
                            @endif
                        </td>
                        <td align="center">{!! $mandat->date_sai !!}</td>
                        <td align="center">{!! $creancier->typepmt !!}</td>
                        <td align="center">
                            @if($user->can("IMP_VISU") || $user->HasRole("ADMINISTRATEUR"))
                            <a href="{!! url('imputations/'.$creancier->idimp_mdt)!!}"
                                class="various fancybox.iframe " style="margin-right: 3px;">
                                {!! str_pad($creancier->idimp_mdt,6,'0',STR_PAD_LEFT) !!}
                            </a>
                            @endif
                        </td>
                    </tr>
                    @endforeach
                </tbody>
            </table>
        </div>

    </div>
</div>

@endsection


@section('styles')
    <!-- FancyBox -->
    <link media="all" type="text/css" rel="stylesheet" href="{{ url('css/jquery.fancybox.css') }}">
    <link media="all" type="text/css" rel="stylesheet" href="{{ url('css/jquery.fancybox-buttons.css') }}">
@stop


@section('scripts')
   <script src="{{ url('js/jquery.fancybox.js') }}"></script>

    <script>
        $(function () {
            $('#select_exercice').change(function() {
                var exercice=$('#select_exercice').val();
                if(exercice=="") return false;;
                url="{!! url('/creanciers_annee') !!}/"+exercice  ;
                location.href=url;
            });
        });
    </script>

    <script type="text/javascript">
        $(".various").fancybox({
            //maxWidth    : 800,
            //maxHeight   : 600,
            fitToView   : true,
            width       : '85%',
            height      : '70%',
            //autoSize    : true,
            //autoScale   : true,
            closeClick  : true,
            openEffect  : 'fade',
            closeEffect : 'fade',
        });
    </script>

    @include("forms.scripts_datatable_btn")
@endsection


