@extends('layouts.dash'.($frame?'_pop':''))
@section('title') Créancier @stop


@section('content')
    @if (Session::has('message')|| !$creancier)
        <div class="alert alert-success">{{ Session::get('message') }}</div>
        <script>
            parent.location.reload();
            parent.jQuery.fancybox.close();
        </script>
    @else
        <div class="card card-info">
            <div class="card-header">
                <h2>Creancier : <small>{{ $creancier->NomComplet }}</small></h2>
            </div>
            <div class='card-body'>
                {{ html()->modelForm($creancier)->open() }}
                    <input type="hidden" name="mode_frame" id="mode_frame" value="{!! $frame !!}">
                    @include("tiers.creanciers.content")
                {{ html()->closeModelForm() }}
            </div>
            <div class='card-footer'>
                @if($creancier->IsSupprimable && ($user->hasRole("ADMINISTRATEUR") || $user->can("CRE_SUP")))
                    @if(!$frame)
                        {{ html()->form('DELETE', url('/creanciers/'. $creancier->id))->open() }}
                            &nbsp;{!! html()->button('Supprimer')->value('Supprimer')->type('submit')
                            ->attributes(['onclick'=>'if(!confirm("Voulez-vous vraiment supprimer ce créancier ?")) return false;','class' => 'btn btn-danger']) !!}
                        {{ html()->form()->close() }}
                    @endif
                @endif
            </div>
        </div>
    @endif
@stop


