
<ul class="nav nav-tabs" id="myTab" role="tablist">
    <li class="nav-item">
        <a class="nav-link {!! ($onglet_actif=='nom')?'active show':'' !!}" href="#nom" data-toggle="tab">Nom - Statut</a></li>
    <li class="nav-item">
        <a class="nav-link {!! ($onglet_actif=='adresse')?'active show':'' !!}" href="#adresse" data-toggle="tab">Contact</a></li>
    @if($mode!="create")
        <li class="nav-item">
            <a class="nav-link {!! ($onglet_actif=='employes')?'active show':'' !!}" href="#employes" data-toggle="tab">Employes</a></li>
    @endif
        <li class="nav-item">
            <a class="nav-link {!! ($onglet_actif=='banque')?'active show':'' !!}" href="#banque" data-toggle="tab">Banque</a></li>
        <li class="nav-item">
            <a class="nav-link {!! ($onglet_actif=='cotisations')?'active show':'' !!}" href="#cotisations" data-toggle="tab">Cotisations</a></li>
    @if($mode!="create")
        <li class="nav-item">
            <a class="nav-link {!! ($onglet_actif=='controles')?'active show':'' !!}" href="#controles" data-toggle="tab">Contrôles</a></li>
        <li class="nav-item">
            <a class="nav-link {!! ($onglet_actif=='compta')?'active show':'' !!}" href="#compta" data-toggle="tab">Comptabilité</a></li>
    @endif
</ul>

<div class="tab-content p-3">
    <!-- ------------------------------------- ONGLET NOM ------------------------------- -->
    <div class="tab-pane fade {!! ($onglet_actif=='nom')?'active show':'' !!}" id="nom" role="tabpanel" aria-labelledby="nom-tab">
        @include("tiers.employeurs.rows_general")
    </div>

    <!-- ------------------------------------- ONGLET CONTACTS ------------------------------- -->
    <div class="tab-pane fade {!! ($onglet_actif=='adresse')?'active show':'' !!}" id="adresse" role="tabpanel" aria-labelledby="adresse-tab">
        @include("tiers.employeurs.rows_contacts")
    </div>

    @if($mode!="create")
        <!-- ------------------------------------- ONGLET EMPLOYES ------------------------------- -->
        <div class="tab-pane fade {!! ($onglet_actif=='employes')?'active show':'' !!}" id="employes" role="tabpanel" aria-labelledby="employes-tab">
            @include("tiers.employeurs.rows_employes")
        </div>
    @endif

        <!-- ------------------------------------- ONGLET BANQUE ------------------------------- -->
        <div class="tab-pane fade {!! ($onglet_actif=='banque')?'active show':'' !!}" id="banque" role="tabpanel" aria-labelledby="banque-tab">
            @include("tiers.employeurs.rows_banques")
        </div>

    
        <!-- ------------------------------------- ONGLET COTISATIONS ------------------------------- -->
        <div class="tab-pane fade {!! ($onglet_actif=='cotisations')?'active show':'' !!}" id="cotisations" role="tabpanel" aria-labelledby="cotisations-tab">
            @include("tiers.employeurs.rows_cotisations")
        </div>
    

    @if($mode!="create")
        <!-- ------------------------------------- ONGLET CONTROLES ------------------------------- -->
        <div class="tab-pane fade {!! ($onglet_actif=='controles')?'active show':'' !!}" id="controles" role="tabpanel" aria-labelledby="controles-tab">
            @include("tiers.employeurs.rows_controles")
        </div>

        <!-- ------------------------------------- ONGLET COMPTA ------------------------------- -->
        <div class="tab-pane fade {!! ($onglet_actif=='compta')?'active show':'' !!}" id="compta" role="tabpanel" aria-labelledby="compta-tab">
            @include("tiers.employeurs.rows_compta")
        </div>
    @endif
    
</div>

<!-- modal : saisie péridoe de cotisation -->
<div class="modal fade" id="modal-bordereau">
    <div class="modal-dialog">
      <div class="modal-content">
        <div class="modal-header">
          <h4 class="modal-title">Bordereau de cotisation</h4>
          <button type="button" class="close" data-dismiss="modal" aria-label="Close">
            <span aria-hidden="true">&times;</span>
          </button>
        </div>
        <div class="modal-body">
            {!! html()->label('Veuillez saisir la période de cotisation','per_cotis') !!}
            {!! html()->select('annee_cotis')->options($exercices)
                ->value(date('Y')-1)
                ->placeholder('')
                ->attributes(['id' => 'annee_cotis','class' => 'form-control selectpicker','data-width' => "100%",'style' => 'font-weight:bold;background:whitesmoke'])  !!}
            <br/><br/>
           {!! html()->select('tri_cotis')->options([""=>"Choisissez un trimestre","T1"=>"1er trimestre","T2"=>"2e trimestre","T3"=>"3e trimestre","T4"=>"4e trimestre"])
                ->value("")
                ->placeholder('')
                ->attributes(['id'=>'tri_cotis','class' => 'form-control selectpicker','data-width' => "100%",'style' => 'font-weight:bold;background:whitesmoke'])  !!}

            <br/><br/>
            {!! html()->text('per_cotis', null)->placeholder('Libellé de la période')->attributes(['class' => 'form-control','id'=>'per_cotis']) !!}
        </div>
        <div class="modal-footer justify-content-between">
          <button id="btn_close_periode_bordereau" type="button" class="btn btn-default" data-dismiss="modal">Annuler</button>
          <button id="btn_valide_periode_bordereau" type="button" class="btn btn-primary">OK</button>
        </div>
      </div>
      <!-- /.modal-content -->
    </div>
    <!-- /.modal-dialog -->
</div>
<!-- /.modal -->


<div class='form-group'>
    @if($mode=="show")
        @if($user->hasRole("ADMINISTRATEUR") || $user->can("EMP_MAJ"))
            <a class="btn btn-primary" href="{!! url('/employeurs_filtre/'.$employeur->id.'/'.$origine.'/'.$onglet_actif.'/edit') !!}">Modifier</a>
        @endif
        <a class="btn btn-warning"  href="{!! url('/employeurs_liste/'.$origine) !!}">Retour</a>
    @else
        @if(($origine=="C") && isset($mode_lettrage) && ($mode_lettrage))
            <a class="btn btn-warning"  href="{!! url('/employeurs_filtre/'.$employeur->id.'/'.$origine.'/'.$onglet_actif) !!}">Sortir du Lettrage</a>
        @else
            {!! html()->button('Enregistrer')->value('Enregistrer')->type('submit')->attributes(['class' => 'btn btn-primary']) !!}
            <a class="btn btn-warning"  href="{!! url('/employeurs_liste/'.$origine) !!}">Retour</a>
        @endif
    @endif
</div>


