@extends('layouts.dash')

@section('title') Employeurs @stop
@section('title_card') Mise à jour d'une fiche Employeur @stop
@section('subtitle_card',"Liste complète")


@section('content')
    @if ($errors)
        @foreach ($errors->all() as $error)
            <div class='bg-danger alert'>{!! $error !!}</div>
        @endforeach
    @endif
    <div class="card card-info">
        <div class="card-header">
            <h3 class="card-title">{!! $employeur->nom !!}</h3>
        </div>
        <div class='card-body'>
            @if(isset($mode_lettrage) && ($mode_lettrage))
                {{ html()->modelForm($employeur, 'PUT', url('employeurs_lettrage/' . $employeur->id.'/'.$origine))->open() }}
            @else
                {{ html()->modelForm($employeur, 'PUT', url('employeurs/' . $employeur->id))->open() }}
            @endif
                {{ html()->hidden( 'origine',$origine) }}
                @include("tiers.employeurs.content")
            {{ html()->closeModelForm() }}
        </div>
    </div>

@endsection

@section('styles')
    <!-- FancyBox -->
    <link media="all" type="text/css" rel="stylesheet" href="{{ url('css/jquery.fancybox.css') }}">
    <link media="all" type="text/css" rel="stylesheet" href="{{ url('css/jquery.fancybox-buttons.css') }}">
@stop



@section('scripts0')
    <script src="{{ url('js/jquery.fancybox.js') }}"></script>
    <script src="{{ url('js/magicsuggest.js') }}"></script>

    @include('tiers.employeurs.scripts_employeur');
@stop
