@extends('layouts.dash')

@section('title') Employeurs @stop
@section('title_card') Employeurs @stop
@section('subtitle_card',"Liste complète")
@section('content')
    @if (Session::has('message'))
        <div class="alert alert-warning">{!! Session::get('message') !!}</div>
    @endif

    @if ($errors)
        @foreach ($errors->all() as $error)
            <div class='bg-danger alert'>{!! $error !!}</div>
        @endforeach
    @endif

    @if (Session::has('success'))
        <div class="alert alert-success">{!! \Session::get('success') !!}</div>
    @endif

    <div class="card">
        <div class="card-header">
            <div class="form-group row">
                <div class='col-md-3'>
                    {!! html()->label('Type de Statut','select_statut') !!}
                    {!! html()->select('select_statut')->options($statuts)
                        ->value(isset($statut)?$statut:"")
                        ->placeholder('Choisir un statut')
                        ->attributes(['class' => 'form-control','id' => 'select_statut'])  !!}
                </div>
                <div class='col-md-2'>
                    {!! html()->label('Type de Ile','select_ile') !!}
                    {!! html()->select('select_ile')->options($iles)
                        ->value(isset($ile)?$ile:"")
                        ->placeholder('Choisr une origine')
                        ->attributes(['class' => 'form-control','id' => 'select_ile'])  !!}
                </div>
                @if($user->can("EMP_AJO") || $user->HasRole("ADMINISTRATEUR"))
                    <div class="col-md-3 ">
                        {!! html()->label( '&nbsp;','') !!}<br/>
                        {!! html()->a(url('employeurs_add/'.$origine),"Ajouter un employeur")->attributes(['class' => 'btn btn-success'])  !!}
                    </div>
                @endif
            </div>
        </div>
        <div class="card-body">
            <table id="_table" class="table table-condensed table-striped table-hover table-bordered">
                <thead>
                    <tr>
                        <th width='1px'>N°</th>
                        <th>Nom</th>
                        <th width='1px'>CompteAux</th>
                        <th width='1px'>NbSalariés</th>
                        <th width='1px'>Ile</th>
                        <th width='30%'>Responsable</th>
                        <th width='30%'>Email</th>
                        <th width='1px'>Secteur</th>
                        <th width='1px'>Statut</th>
                        <th width='1px'>Solde&nbsp;{{ date('Y') }}</th>
                    </tr>
                </thead>

                <tbody>
                    @foreach ($employeurs as $employeur)
                    @php
                        $solde=$employeur->getSoldeCompta();
                    @endphp
                    <tr>
                        <td class="">{!! str_pad($employeur->id,4,'0',STR_PAD_LEFT) !!}</td>
                        <td>
                            @if($user->can("EMP_VISU") || $user->HasRole("ADMINISTRATEUR"))
                                <a href="{!! url('employeurs_filtre/'.$employeur->id."/".$origine) !!}" >{!! $employeur->NomReduit !!}</a>
                            @else
                                {!! $employeur->NomReduit !!}
                            @endif
                        </td>
                        <td>{!! $employeur->compte_aux !!}</td>
                        <td>{!! $employeur->Nbemployes !!}</td>
                        <td>{!! $employeur->ile !!}</td>
                        <td>{!! (strlen($employeur->responsable)>20)?substr($employeur->responsable,0,20):$employeur->responsable !!}</td>
                        <td>{!! $employeur->email !!}</td>
                        <td>{!! $employeur->secteur !!}</td>
                        <td>{!! $employeur->statut !!}</td>
                        <td nowrap align="right" style="font-weight:bold;color:{{ ($solde<0)?'red':'green' }}">{!! is_numeric($solde)?number_format($solde,0,","," "):"-" !!}</td>
                    </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
    </div>
@endsection


@section('scripts')
<script>
    $(function () {
        $('#select_statut').change(function() {select_filtre();});
        $('#select_ile').change(function() {select_filtre();});

        function select_filtre() {
            var statut=$('#select_statut').val();
            if(statut=="") statut=0;
            var ile=$('#select_ile').val();
            if(ile=="") ile=0;
            url="{!! url('employeurs/'.$origine) !!}"+"/"+statut+"/"+ile  ;
            location.href=url;
        }
    });
</script>
    @include("forms.scripts_datatable")
@endsection


