<div class="col-lg-max">
    <div class="form-group row callout callout-danger">
        <div class="col-md-3">
            {!! html()->hidden('checklist','',['id'=>'checklist']) !!}
            {!! html()->label( 'Compte auxiliaire','compte_aux') !!}
            {!! html()->text('compte_aux', null)->attributes(['disabled', 'placeholder' => '','class' => 'form-control']) !!}
        </div>
    </div>

    @if($origine=="C")
        @if($mode=="show" || (isset($mode_lettrage) && ($mode_lettrage)) )
            <div class="row ">
                @if(isset($mode_lettrage) && ($mode_lettrage))
                    <div class="col-md-8 " style="">
                        <span class="btn btn-default bts-sm"><a href="{!! url('view_lettrage/'.$employeur->id.'/'.$origine.'/lettrage') !!}">
                            {!! ($view_lettrage==0)?"Voir les lignes lettrées":"Ne pas voir les ligne lettrées" !!}
                        </a></span>
                    </div>
                    <div class="col-md-3" style="">
                        {!! html()->label( 'Total lettrage','montant_lettrage') !!}
                        {!! html()->text('montant_lettrage', '')->attributes(['id'=>'montant_lettrage','readonly','class' => 'form-control','style'=>'text-align:right']) !!}
                    </div>
                    <div class="col-md-1" style="padding-top:34px">
                        {!! html()->button('Lettrer')->value('Lettrer')->type('submit')->attributes(['id'=>'bt_lettrer','class' => 'btn btn-success']) !!}
                    </div>
                @else
                    <div class="col-md-8 " style="">
                        <span class="btn btn-default bts-sm"><a href="{!! url('view_lettrage/'.$employeur->id.'/'.$origine) !!}">
                            {!! ($view_lettrage==0)?"Voir les lignes lettrées":"Ne pas voir les ligne lettrées" !!}
                        </a></span>
                    </div>
                    <div class="col-md-4 " style="">
                        <div class="float-right">
                            <a class="btn btn-info"  href="{!! url('employeurs_lettrage').'/'.$employeur->id.'/'.$origine !!}">Lettrage</a>
                        </div>
                    </div>
                @endif
            </div>
        @endif
    @endif


    <div class="row">
        <div class="col-md-12">
            <div class="tab-pane" id="compta">
                <legend>Liste des écritures</legend>
                <div class="form-group">
                    <div class="table">
                        <table id="_table_ecritures" class="table table-condensed table-striped table-bordered" >
                            @if(count($ecritures)>0)
                                    <thead>
                                        <tr>
                                            <th width='1px'>Transaction</th>
                                            <th width='1px'>Date</th>
                                            <th width='1px'>Ref</th>
                                            <th width='1px'>Journal</th>
                                            <th width='1px'>Compte</th>
                                            <th >Désignation</th>
                                            <th width='1px'>Débit</th>
                                            <th width='1px'>Crédit</th>
                                            <th width='1px'>Lettrage
                                                @if(isset($mode_lettrage) && ($mode_lettrage) )
                                                    <span style="color:grey;">Tout&nbsp;</span>
                                                    {!! html()->checkbox('box_all', '1',false)->attributes(['id'=>'box_all','style'=>'']); !!}
                                                @endif
                                            </th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @php
                                            $total_debit=0;$total_credit=0;$solde=0;
                                        @endphp
                                        @foreach ($ecritures as $ecriture)
                                        @php
                                            if(!$ecriture->debit) $ecriture->debit=0;
                                            if(!$ecriture->credit) $ecriture->credit=0;
                                            $total_debit+=$ecriture->debit;
                                            $total_credit+=$ecriture->credit;
                                            $solde+=$ecriture->credit-$ecriture->debit;

                                        @endphp
                                        <tr>
                                            <td align="center">
                                                <a href="{!! url('transaction/'.$ecriture->IdTransaction) !!}" target="_blank">
                                                    {!! str_pad($ecriture->IdTransaction,5,"0", STR_PAD_LEFT); !!}
                                                </a>
                                            </td>
                                            <td>{!! $ecriture->date_doc !!}</td>
                                            <td nowrap>{!! $ecriture->ref_doc !!}</td>
                                            <td align="center">{!! $ecriture->journal !!}</td>
                                            <td align="center">{!! $ecriture->compte !!}</td>
                                            <td>{!! $ecriture->designation !!}</td>
                                            <td id="debit_{!! $ecriture->id !!}" class="text-danger" align="right">{!! $ecriture->debit !!}</td>
                                            <td id="credit_{!! $ecriture->id !!}" class="text-success" align="right">{!! $ecriture->credit !!}</td>
                                            <td nowrap>
                                                @if(isset($mode_lettrage) && ($mode_lettrage) && ($ecriture->lettrage_code==""))
                                                    <input id="box_{!! $ecriture->id !!}" class="form-control box_td"
                                                        name="box_{!! $ecriture->id !!}" type="checkbox" value="1">
                                                @else
                                                    {!! $ecriture->lettrage_code !!}
                                                @endif
                                            </td>
                                        </tr>
                                        @endforeach
                                    </tbody>
                                    <tfoot>
                                        <tr>
                                            <th rowspan="2" colspan="6" style='vertical-align:middle;text-align:right'>TOTAL</th>
                                            <th class="text-danger" style='text-align:right'>{{ $total_debit }}</th>
                                            <th class="text-success" style='text-align:right'>{{ $total_credit }}</th>
                                            <th rowspan="2" style='text-align:right'></th>
                                        </tr>
                                        <tr>
                                            <th colspan="2" nowrap style='text-align:center'>
                                                <span style="text-align:right;color:{{ ($solde<0)?'red':'green' }};">{{ number_format($solde,0,","," ") }}</span></th>
                                        </tr>
                                    </thead>
                            @else
                                <thead>
                                    <tr>
                                        <td nowrap width='1px' style="font-style:italic;color:darkred">
                                            Aucune écriture
                                        </td>
                                    </tr>
                                </thead>
                            @endif
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

